/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.resourcematcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.resourcematcher.CaseInsensitiveRecursiveWildcardMatcher;
import org.apache.ranger.plugin.resourcematcher.CaseInsensitiveStartsWithMatcher;
import org.apache.ranger.plugin.resourcematcher.CaseSensitiveRecursiveWildcardMatcher;
import org.apache.ranger.plugin.resourcematcher.CaseSensitiveStartsWithMatcher;
import org.apache.ranger.plugin.resourcematcher.RangerDefaultResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.ResourceMatcher;

public class RangerPathResourceMatcher
extends RangerDefaultResourceMatcher {
    private static final Log LOG = LogFactory.getLog(RangerPathResourceMatcher.class);
    private static final String OPTION_PATH_SEPARATOR = "pathSeparatorChar";
    private static final char DEFAULT_PATH_SEPARATOR_CHAR = '/';
    private boolean policyIsRecursive = false;
    private char pathSeparatorChar = (char)47;

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerPathResourceMatcher.init()");
        }
        this.policyIsRecursive = this.policyResource == null ? false : this.policyResource.getIsRecursive();
        this.pathSeparatorChar = this.getCharOption(OPTION_PATH_SEPARATOR, '/');
        super.init();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerPathResourceMatcher.init()");
        }
    }

    @Override
    protected List<ResourceMatcher> buildResourceMatchers() {
        ArrayList<ResourceMatcher> ret = new ArrayList<ResourceMatcher>();
        for (String policyValue : this.policyValues) {
            ResourceMatcher matcher;
            if (this.optWildCard && this.policyIsRecursive && policyValue.charAt(policyValue.length() - 1) == this.pathSeparatorChar) {
                policyValue = policyValue + "*";
            }
            if ((matcher = this.getMatcher(policyValue)) == null) continue;
            if (matcher.isMatchAny()) {
                ret.clear();
                break;
            }
            ret.add(matcher);
        }
        Collections.sort(ret);
        return ret;
    }

    @Override
    ResourceMatcher getMatcher(String policyValue) {
        int len;
        if (!this.policyIsRecursive) {
            return super.getMatcher(policyValue);
        }
        int n = len = policyValue != null ? policyValue.length() : 0;
        if (len == 0) {
            return null;
        }
        boolean isWildcardPresent = false;
        if (this.optWildCard) {
            for (int i = 0; i < len; ++i) {
                char c = policyValue.charAt(i);
                if (c != '?' && c != '*') continue;
                isWildcardPresent = true;
                break;
            }
        }
        ResourceMatcher ret = isWildcardPresent ? (this.optIgnoreCase ? new CaseInsensitiveRecursiveWildcardMatcher(policyValue, this.pathSeparatorChar) : new CaseSensitiveRecursiveWildcardMatcher(policyValue, this.pathSeparatorChar)) : (this.optIgnoreCase ? new CaseInsensitiveStartsWithMatcher(policyValue) : new CaseSensitiveStartsWithMatcher(policyValue));
        return ret;
    }

    static boolean isRecursiveWildCardMatch(String pathToCheck, String wildcardPath, char pathSeparatorChar, IOCase caseSensitivity) {
        boolean ret = false;
        if (!StringUtils.isEmpty((String)pathToCheck)) {
            Object[] pathElements = StringUtils.split((String)pathToCheck, (char)pathSeparatorChar);
            if (!ArrayUtils.isEmpty((Object[])pathElements)) {
                StringBuilder sb = new StringBuilder();
                if (pathToCheck.charAt(0) == pathSeparatorChar) {
                    sb.append(pathSeparatorChar);
                }
                for (Object p : pathElements) {
                    sb.append((String)p);
                    ret = FilenameUtils.wildcardMatch((String)sb.toString(), (String)wildcardPath, (IOCase)caseSensitivity);
                    if (ret) break;
                    sb.append(pathSeparatorChar);
                }
                sb = null;
            } else {
                ret = FilenameUtils.wildcardMatch((String)pathToCheck, (String)wildcardPath, (IOCase)caseSensitivity);
            }
        }
        return ret;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerPathResourceMatcher={");
        super.toString(sb);
        sb.append("policyIsRecursive={").append(this.policyIsRecursive).append("} ");
        sb.append("}");
        return sb;
    }
}

