/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.store.file;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.apache.ranger.plugin.model.RangerBaseModelObject;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.store.AbstractServiceStore;
import org.apache.ranger.plugin.store.EmbeddedServiceDefsUtil;
import org.apache.ranger.plugin.store.ServicePredicateUtil;
import org.apache.ranger.plugin.store.file.FileStoreUtil;
import org.apache.ranger.plugin.util.SearchFilter;
import org.apache.ranger.plugin.util.ServicePolicies;

public class ServiceFileStore
extends AbstractServiceStore {
    private static final Log LOG = LogFactory.getLog(ServiceFileStore.class);
    public static final String PROPERTY_SERVICE_FILE_STORE_DIR = "ranger.service.store.file.dir";
    protected static final String FILE_PREFIX_SERVICE_DEF = "ranger-servicedef-";
    protected static final String FILE_PREFIX_SERVICE = "ranger-service-";
    protected static final String FILE_PREFIX_POLICY = "ranger-policy-";
    private String dataDir = null;
    private long nextServiceDefId = 0L;
    private long nextServiceId = 0L;
    private long nextPolicyId = 0L;
    private ServicePredicateUtil predicateUtil = null;
    private FileStoreUtil fileStoreUtil = null;
    private Boolean populateExistingBaseFields = false;

    public ServiceFileStore() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> ServiceFileStore.ServiceFileStore()");
        }
        this.dataDir = RangerConfiguration.getInstance().get(PROPERTY_SERVICE_FILE_STORE_DIR, "file:///etc/ranger/data");
        this.predicateUtil = new ServicePredicateUtil(this);
        this.fileStoreUtil = new FileStoreUtil();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== ServiceFileStore.ServiceFileStore()");
        }
    }

    public ServiceFileStore(String dataDir) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> ServiceFileStore.ServiceFileStore()");
        }
        this.dataDir = dataDir;
        this.predicateUtil = new ServicePredicateUtil(this);
        this.fileStoreUtil = new FileStoreUtil();
        this.fileStoreUtil.initStore(dataDir);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== ServiceFileStore.ServiceFileStore()");
        }
    }

    @Override
    public void init() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> ServiceFileStore.init()");
        }
        this.fileStoreUtil.initStore(this.dataDir);
        EmbeddedServiceDefsUtil.instance().init(this);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== ServiceFileStore.init()");
        }
    }

    @Override
    public RangerServiceDef createServiceDef(RangerServiceDef serviceDef) throws Exception {
        RangerServiceDef existing;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceDefFileStore.createServiceDef(" + serviceDef + ")"));
        }
        if ((existing = this.getServiceDefByName(serviceDef.getName())) != null) {
            throw new Exception(serviceDef.getName() + ": service-def already exists (id=" + existing.getId() + ")");
        }
        RangerServiceDef ret = null;
        try {
            this.preCreate(serviceDef);
            serviceDef.setId(this.nextServiceDefId++);
            ret = this.fileStoreUtil.saveToFile(serviceDef, FILE_PREFIX_SERVICE_DEF, false);
            this.postCreate(ret);
        }
        catch (Exception excp) {
            LOG.warn((Object)("ServiceDefFileStore.createServiceDef(): failed to save service-def '" + serviceDef.getName() + "'"), (Throwable)excp);
            throw new Exception("failed to save service-def '" + serviceDef.getName() + "'", excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceDefFileStore.createServiceDef(" + serviceDef + ")"));
        }
        return ret;
    }

    @Override
    public RangerServiceDef updateServiceDef(RangerServiceDef serviceDef) throws Exception {
        boolean renamed;
        RangerServiceDef existing;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceDefFileStore.updateServiceDef(" + serviceDef + ")"));
        }
        if ((existing = this.getServiceDef(serviceDef.getId())) == null) {
            throw new Exception(serviceDef.getId() + ": service-def does not exist");
        }
        String existingName = existing.getName();
        boolean bl = renamed = !StringUtils.equalsIgnoreCase((String)serviceDef.getName(), (String)existingName);
        if (renamed) {
            LOG.warn((Object)("ServiceDefFileStore.updateServiceDef(): service-def renaming not supported. " + existingName + " ==> " + serviceDef.getName()));
            throw new Exception("service-def renaming not supported. " + existingName + " ==> " + serviceDef.getName());
        }
        RangerServiceDef ret = null;
        try {
            existing.updateFrom(serviceDef);
            this.preUpdate(existing);
            ret = this.fileStoreUtil.saveToFile(existing, FILE_PREFIX_SERVICE_DEF, true);
            this.postUpdate(ret);
        }
        catch (Exception excp) {
            LOG.warn((Object)("ServiceDefFileStore.updateServiceDef(): failed to save service-def '" + existing.getName() + "'"), (Throwable)excp);
            throw new Exception("failed to save service-def '" + existing.getName() + "'", excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceDefFileStore.updateServiceDef(" + serviceDef + "): " + ret));
        }
        return ret;
    }

    @Override
    public void deleteServiceDef(Long id) throws Exception {
        RangerServiceDef existing;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceDefFileStore.deleteServiceDef(" + id + ")"));
        }
        if ((existing = this.getServiceDef(id)) == null) {
            throw new Exception("service-def does not exist. id=" + id);
        }
        try {
            this.preDelete(existing);
            Path filePath = new Path(this.fileStoreUtil.getDataFile(FILE_PREFIX_SERVICE_DEF, id));
            this.fileStoreUtil.deleteFile(filePath);
            this.postDelete(existing);
        }
        catch (Exception excp) {
            throw new Exception("failed to delete service-def. id=" + id + "; name=" + existing.getName(), excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceDefFileStore.deleteServiceDef(" + id + ")"));
        }
    }

    @Override
    public RangerServiceDef getServiceDef(Long id) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceDefFileStore.getServiceDef(" + id + ")"));
        }
        RangerServiceDef ret = null;
        if (id != null) {
            SearchFilter filter = new SearchFilter("serviceTypeId", id.toString());
            List<RangerServiceDef> serviceDefs = this.getServiceDefs(filter);
            RangerServiceDef rangerServiceDef = ret = CollectionUtils.isEmpty(serviceDefs) ? null : serviceDefs.get(0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceDefFileStore.getServiceDef(" + id + "): " + ret));
        }
        return ret;
    }

    @Override
    public RangerServiceDef getServiceDefByName(String name) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceDefFileStore.getServiceDefByName(" + name + ")"));
        }
        RangerServiceDef ret = null;
        if (name != null) {
            SearchFilter filter = new SearchFilter("serviceType", name);
            List<RangerServiceDef> serviceDefs = this.getServiceDefs(filter);
            RangerServiceDef rangerServiceDef = ret = CollectionUtils.isEmpty(serviceDefs) ? null : serviceDefs.get(0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceDefFileStore.getServiceDefByName(" + name + "): " + ret));
        }
        return ret;
    }

    @Override
    public List<RangerServiceDef> getServiceDefs(SearchFilter filter) throws Exception {
        List<RangerServiceDef> ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> ServiceDefFileStore.getServiceDefs()");
        }
        if ((ret = this.getAllServiceDefs()) != null && filter != null && !filter.isEmpty()) {
            CollectionUtils.filter(ret, (Predicate)this.predicateUtil.getPredicate(filter));
            Comparator<RangerBaseModelObject> comparator = this.predicateUtil.getSorter(filter);
            if (comparator != null) {
                Collections.sort(ret, comparator);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceDefFileStore.getServiceDefs(): count=" + (ret == null ? 0 : ret.size())));
        }
        return ret;
    }

    @Override
    public RangerService createService(RangerService service) throws Exception {
        RangerService existing;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceFileStore.createService(" + service + ")"));
        }
        if ((existing = this.getServiceByName(service.getName())) != null) {
            throw new Exception("service already exists - '" + service.getName() + "'. ID=" + existing.getId());
        }
        RangerService ret = null;
        try {
            this.preCreate(service);
            service.setId(this.nextServiceId++);
            ret = this.fileStoreUtil.saveToFile(service, FILE_PREFIX_SERVICE, false);
            this.postCreate(service);
        }
        catch (Exception excp) {
            throw new Exception("failed to save service '" + service.getName() + "'", excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceFileStore.createService(" + service + "): " + ret));
        }
        return ret;
    }

    @Override
    public RangerService updateService(RangerService service) throws Exception {
        boolean hasIsEnabledChanged;
        RangerService newNameService;
        boolean renamed;
        RangerService existing;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceFileStore.updateService(" + service + ")"));
        }
        if ((existing = this.getService(service.getId())) == null) {
            throw new Exception("no service exists with ID=" + service.getId());
        }
        String existingName = existing.getName();
        boolean bl = renamed = !StringUtils.equalsIgnoreCase((String)service.getName(), (String)existingName);
        if (renamed && (newNameService = this.getServiceByName(service.getName())) != null) {
            throw new Exception("another service already exists with name '" + service.getName() + "'. ID=" + newNameService.getId());
        }
        boolean bl2 = hasIsEnabledChanged = !existing.getIsEnabled().equals(service.getIsEnabled());
        if (hasIsEnabledChanged) {
            this.handlePolicyUpdate(service);
        }
        RangerService ret = null;
        try {
            existing.updateFrom(service);
            this.preUpdate(existing);
            ret = this.fileStoreUtil.saveToFile(existing, FILE_PREFIX_SERVICE, true);
            this.postUpdate(ret);
            if (renamed) {
                this.handleServiceRename(ret, existingName);
            }
        }
        catch (Exception excp) {
            throw new Exception("failed to update service '" + existing.getName() + "'", excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceFileStore.updateService(" + service + "): " + ret));
        }
        return ret;
    }

    @Override
    public void deleteService(Long id) throws Exception {
        RangerService existing;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceFileStore.deleteService(" + id + ")"));
        }
        if ((existing = this.getService(id)) == null) {
            throw new Exception("no service exists with ID=" + id);
        }
        try {
            Path filePath = new Path(this.fileStoreUtil.getDataFile(FILE_PREFIX_SERVICE, id));
            this.preDelete(existing);
            this.handleServiceDelete(existing);
            this.fileStoreUtil.deleteFile(filePath);
            this.postDelete(existing);
        }
        catch (Exception excp) {
            throw new Exception("failed to delete service with ID=" + id, excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceFileStore.deleteService(" + id + ")"));
        }
    }

    @Override
    public RangerService getService(Long id) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceFileStore.getService(" + id + ")"));
        }
        RangerService ret = null;
        try {
            Path filePath = new Path(this.fileStoreUtil.getDataFile(FILE_PREFIX_SERVICE, id));
            ret = this.fileStoreUtil.loadFromFile(filePath, RangerService.class);
        }
        catch (Exception excp) {
            LOG.error((Object)("ServiceFileStore.getService(" + id + "): failed to read service"), (Throwable)excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceFileStore.getService(" + id + "): " + ret));
        }
        return ret;
    }

    @Override
    public RangerService getServiceByName(String name) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceFileStore.getServiceByName(" + name + ")"));
        }
        RangerService ret = null;
        if (name != null) {
            SearchFilter filter = new SearchFilter("serviceName", name);
            List<RangerService> services = this.getServices(filter);
            RangerService rangerService = ret = CollectionUtils.isEmpty(services) ? null : services.get(0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceFileStore.getServiceByName(" + name + "): " + ret));
        }
        return ret;
    }

    @Override
    public List<RangerService> getServices(SearchFilter filter) throws Exception {
        List<RangerService> ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> ServiceFileStore.getServices()");
        }
        if ((ret = this.getAllServices()) != null && filter != null && !filter.isEmpty()) {
            CollectionUtils.filter(ret, (Predicate)this.predicateUtil.getPredicate(filter));
            Comparator<RangerBaseModelObject> comparator = this.predicateUtil.getSorter(filter);
            if (comparator != null) {
                Collections.sort(ret, comparator);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceFileStore.getServices(): count=" + (ret == null ? 0 : ret.size())));
        }
        return ret;
    }

    @Override
    public RangerPolicy createPolicy(RangerPolicy policy) throws Exception {
        RangerService service;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceFileStore.createPolicy(" + policy + ")"));
        }
        if ((service = this.getServiceByName(policy.getService())) == null) {
            throw new Exception("service does not exist - name=" + policy.getService());
        }
        RangerPolicy existing = this.findPolicyByName(policy.getService(), policy.getName());
        if (existing != null) {
            throw new Exception("policy already exists: ServiceName=" + policy.getService() + "; PolicyName=" + policy.getName() + ". ID=" + existing.getId());
        }
        RangerPolicy ret = null;
        try {
            this.preCreate(policy);
            policy.setId(this.nextPolicyId++);
            ret = this.fileStoreUtil.saveToFile(policy, FILE_PREFIX_POLICY, service.getId(), false);
            this.handlePolicyUpdate(service);
            this.postCreate(ret);
        }
        catch (Exception excp) {
            throw new Exception("failed to save policy: ServiceName=" + policy.getService() + "; PolicyName=" + policy.getName(), excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceFileStore.createPolicy(" + policy + "): " + ret));
        }
        return ret;
    }

    @Override
    public RangerPolicy updatePolicy(RangerPolicy policy) throws Exception {
        RangerPolicy newNamePolicy;
        boolean renamed;
        RangerPolicy existing;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceFileStore.updatePolicy(" + policy + ")"));
        }
        if ((existing = this.getPolicy(policy.getId())) == null) {
            throw new Exception("no policy exists with ID=" + policy.getId());
        }
        RangerService service = this.getServiceByName(policy.getService());
        if (service == null) {
            throw new Exception("service does not exist - name=" + policy.getService());
        }
        if (!StringUtils.equalsIgnoreCase((String)existing.getService(), (String)policy.getService())) {
            throw new Exception("policy id=" + policy.getId() + " already exists in service " + existing.getService() + ". It can not be moved to service " + policy.getService());
        }
        boolean bl = renamed = !StringUtils.equalsIgnoreCase((String)policy.getName(), (String)existing.getName());
        if (renamed && (newNamePolicy = this.findPolicyByName(service.getName(), policy.getName())) != null) {
            throw new Exception("another policy already exists with name '" + policy.getName() + "'. ID=" + newNamePolicy.getId());
        }
        RangerPolicy ret = null;
        try {
            existing.updateFrom(policy);
            this.preUpdate(existing);
            ret = this.fileStoreUtil.saveToFile(existing, FILE_PREFIX_POLICY, service.getId(), true);
            this.handlePolicyUpdate(service);
            this.postUpdate(ret);
        }
        catch (Exception excp) {
            throw new Exception("failed to update policy - ID=" + existing.getId(), excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceFileStore.updatePolicy(" + policy + "): " + ret));
        }
        return ret;
    }

    @Override
    public void deletePolicy(Long id) throws Exception {
        RangerPolicy existing;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceFileStore.deletePolicy(" + id + ")"));
        }
        if ((existing = this.getPolicy(id)) == null) {
            throw new Exception("no policy exists with ID=" + id);
        }
        RangerService service = this.getServiceByName(existing.getService());
        if (service == null) {
            throw new Exception("service does not exist - name='" + existing.getService());
        }
        try {
            this.preDelete(existing);
            Path filePath = new Path(this.fileStoreUtil.getDataFile(FILE_PREFIX_POLICY, service.getId(), existing.getId()));
            this.fileStoreUtil.deleteFile(filePath);
            this.handlePolicyUpdate(service);
            this.postDelete(existing);
        }
        catch (Exception excp) {
            throw new Exception(existing.getId() + ": failed to delete policy", excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceFileStore.deletePolicy(" + id + ")"));
        }
    }

    @Override
    public RangerPolicy getPolicy(Long id) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceFileStore.getPolicy(" + id + ")"));
        }
        RangerPolicy ret = null;
        if (id != null) {
            SearchFilter filter = new SearchFilter("policyId", id.toString());
            List<RangerPolicy> policies = this.getPolicies(filter);
            RangerPolicy rangerPolicy = ret = CollectionUtils.isEmpty(policies) ? null : policies.get(0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceFileStore.getPolicy(" + id + "): " + ret));
        }
        return ret;
    }

    @Override
    public List<RangerPolicy> getPoliciesByResourceSignature(String serviceName, String policySignature, Boolean isPolicyEnabled) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> ServiceFileStore.getPoliciesByResourceSignature(%s, %s, %s)", serviceName, policySignature, isPolicyEnabled));
        }
        List<RangerPolicy> ret = this.getAllPolicies();
        CollectionUtils.filter(ret, (Predicate)this.predicateUtil.createPredicateForResourceSignature(policySignature));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== ServiceFileStore.getPoliciesByResourceSignature(%s, %s, %s): count[%d]: %s", serviceName, policySignature, isPolicyEnabled, ret == null ? 0 : ret.size(), ret));
        }
        return ret;
    }

    @Override
    public List<RangerPolicy> getPolicies(SearchFilter filter) throws Exception {
        List<RangerPolicy> ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> ServiceFileStore.getPolicies()");
        }
        if ((ret = this.getAllPolicies()) != null && filter != null && !filter.isEmpty()) {
            CollectionUtils.filter(ret, (Predicate)this.predicateUtil.getPredicate(filter));
            Comparator<RangerBaseModelObject> comparator = this.predicateUtil.getSorter(filter);
            if (comparator != null) {
                Collections.sort(ret, comparator);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceFileStore.getPolicies(): count=" + (ret == null ? 0 : ret.size())));
        }
        return ret;
    }

    @Override
    public List<RangerPolicy> getServicePolicies(Long serviceId, SearchFilter filter) throws Exception {
        RangerService service;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceFileStore.getServicePolicies(" + serviceId + ")"));
        }
        if ((service = this.getService(serviceId)) == null) {
            throw new Exception("service does not exist - id='" + serviceId);
        }
        List<RangerPolicy> ret = this.getServicePolicies(service.getName(), filter);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceFileStore.getServicePolicies(" + serviceId + "): " + (ret == null ? 0 : ret.size())));
        }
        return ret;
    }

    @Override
    public List<RangerPolicy> getServicePolicies(String serviceName, SearchFilter filter) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceFileStore.getServicePolicies(" + serviceName + ")"));
        }
        ArrayList<RangerPolicy> ret = new ArrayList();
        try {
            if (filter == null) {
                filter = new SearchFilter();
            }
            filter.setParam("serviceName", serviceName);
            ret = this.getPolicies(filter);
        }
        catch (Exception excp) {
            LOG.error((Object)("ServiceFileStore.getServicePolicies(" + serviceName + "): failed to read policies"), (Throwable)excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceFileStore.getServicePolicies(" + serviceName + "): count=" + (ret == null ? 0 : ret.size())));
        }
        return ret;
    }

    @Override
    public ServicePolicies getServicePoliciesIfUpdated(String serviceName, Long lastKnownVersion) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceFileStore.getServicePoliciesIfUpdated(" + serviceName + ", " + lastKnownVersion + ")"));
        }
        ServicePolicies ret = null;
        RangerService service = this.getServiceByName(serviceName);
        if (service == null) {
            throw new Exception("service does not exist - name=" + serviceName);
        }
        RangerServiceDef serviceDef = this.getServiceDefByName(service.getType());
        if (serviceDef == null) {
            throw new Exception(service.getType() + ": unknown service-def)");
        }
        if (lastKnownVersion == null || service.getPolicyVersion() == null || lastKnownVersion.longValue() != service.getPolicyVersion().longValue()) {
            ArrayList<RangerPolicy> policies = null;
            if (service.getIsEnabled().booleanValue()) {
                SearchFilter filter = new SearchFilter("serviceName", serviceName);
                policies = this.getPolicies(filter);
            } else {
                policies = new ArrayList();
            }
            ret = new ServicePolicies();
            ret.setServiceId(service.getId());
            ret.setServiceName(service.getName());
            ret.setPolicyVersion(service.getPolicyVersion());
            ret.setPolicyUpdateTime(service.getPolicyUpdateTime());
            ret.setPolicies(policies);
            ret.setServiceDef(serviceDef);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceFileStore.getServicePoliciesIfUpdated(" + serviceName + ", " + lastKnownVersion + "): count=" + (ret == null || ret.getPolicies() == null ? 0 : ret.getPolicies().size())));
        }
        if (ret != null && ret.getPolicies() != null) {
            Collections.sort(ret.getPolicies(), ServicePredicateUtil.idComparator);
        }
        return ret;
    }

    @Override
    public ServicePolicies getServicePolicies(String serviceName) throws Exception {
        return this.getServicePoliciesIfUpdated(serviceName, -1L);
    }

    private void handleServiceRename(RangerService service, String oldName) throws Exception {
        List<RangerPolicy> policies = this.getAllPolicies();
        if (policies != null) {
            for (RangerPolicy policy : policies) {
                if (!StringUtils.equalsIgnoreCase((String)policy.getService(), (String)oldName)) continue;
                policy.setService(service.getName());
                this.preUpdate(policy);
                this.fileStoreUtil.saveToFile(policy, FILE_PREFIX_POLICY, service.getId(), true);
                this.postUpdate(policy);
            }
        }
    }

    private void handleServiceDelete(RangerService service) throws Exception {
        List<RangerPolicy> policies = this.getAllPolicies();
        if (policies != null) {
            for (RangerPolicy policy : policies) {
                if (!StringUtils.equals((String)policy.getService(), (String)service.getName())) continue;
                this.preDelete(policy);
                Path filePath = new Path(this.fileStoreUtil.getDataFile(FILE_PREFIX_POLICY, service.getId(), policy.getId()));
                this.fileStoreUtil.deleteFile(filePath);
                this.postDelete(policy);
            }
        }
    }

    private void handlePolicyUpdate(RangerService service) throws Exception {
        if (service == null) {
            return;
        }
        service.setPolicyVersion(this.getNextVersion(service.getPolicyVersion()));
        service.setPolicyUpdateTime(new Date());
        this.fileStoreUtil.saveToFile(service, FILE_PREFIX_SERVICE, true);
        boolean isTagServiceDef = StringUtils.equals((String)service.getType(), (String)"tag");
        if (isTagServiceDef) {
            SearchFilter filter = new SearchFilter();
            filter.setParam("tagServiceName", service.getName());
            List<RangerService> referringServices = this.getServices(filter);
            if (CollectionUtils.isNotEmpty(referringServices)) {
                for (RangerService referringService : referringServices) {
                    referringService.setPolicyVersion(this.getNextVersion(referringService.getPolicyVersion()));
                    referringService.setPolicyUpdateTime(service.getPolicyUpdateTime());
                    this.fileStoreUtil.saveToFile(referringService, FILE_PREFIX_SERVICE, true);
                }
            }
        }
    }

    private RangerPolicy findPolicyByName(String serviceName, String policyName) throws Exception {
        RangerService service;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> ServiceFileStore.findPolicyByName(" + serviceName + ", " + policyName + ")"));
        }
        if ((service = this.getServiceByName(serviceName)) == null) {
            throw new Exception("service does not exist - name='" + serviceName);
        }
        RangerPolicy ret = null;
        SearchFilter filter = new SearchFilter();
        filter.setParam("serviceName", serviceName);
        filter.setParam("policyName", policyName);
        List<RangerPolicy> policies = this.getPolicies(filter);
        RangerPolicy rangerPolicy = ret = CollectionUtils.isEmpty(policies) ? null : policies.get(0);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceFileStore.findPolicyByName(" + serviceName + ", " + policyName + "): " + ret));
        }
        return ret;
    }

    private List<RangerServiceDef> getAllServiceDefs() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> ServiceDefFileStore.getAllServiceDefs()");
        }
        ArrayList<RangerServiceDef> ret = new ArrayList<RangerServiceDef>();
        try {
            List<RangerServiceDef> sds = this.fileStoreUtil.loadFromDir(new Path(this.fileStoreUtil.getDataDir()), FILE_PREFIX_SERVICE_DEF, RangerServiceDef.class);
            if (sds != null) {
                for (RangerServiceDef sd : sds) {
                    if (sd == null) continue;
                    for (int i = 0; i < ret.size(); ++i) {
                        RangerServiceDef currSd = (RangerServiceDef)ret.get(i);
                        if (!StringUtils.equals((String)currSd.getName(), (String)sd.getName()) && !ObjectUtils.equals((Object)currSd.getId(), (Object)sd.getId())) continue;
                        ret.remove(i);
                    }
                    ret.add(sd);
                }
            }
            this.nextServiceDefId = this.getMaxId(ret) + 1L;
        }
        catch (Exception excp) {
            LOG.error((Object)"ServiceDefFileStore.getAllServiceDefs(): failed to read service-defs", (Throwable)excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceDefFileStore.getAllServiceDefs(): count=" + (ret == null ? 0 : ret.size())));
        }
        if (ret != null) {
            Collections.sort(ret, ServicePredicateUtil.idComparator);
            for (RangerServiceDef sd : ret) {
                Collections.sort(sd.getResources(), ServicePredicateUtil.resourceLevelComparator);
            }
        }
        return ret;
    }

    private List<RangerService> getAllServices() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> ServiceFileStore.getAllServices()");
        }
        List<RangerService> ret = null;
        try {
            ret = this.fileStoreUtil.loadFromDir(new Path(this.fileStoreUtil.getDataDir()), FILE_PREFIX_SERVICE, RangerService.class);
            this.nextServiceId = this.getMaxId(ret) + 1L;
        }
        catch (Exception excp) {
            LOG.error((Object)"ServiceFileStore.getAllServices(): failed to read services", (Throwable)excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceFileStore.getAllServices(): count=" + (ret == null ? 0 : ret.size())));
        }
        if (ret != null) {
            Collections.sort(ret, ServicePredicateUtil.idComparator);
        }
        return ret;
    }

    private List<RangerPolicy> getAllPolicies() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> ServiceFileStore.getAllPolicies()");
        }
        List<RangerPolicy> ret = null;
        try {
            ret = this.fileStoreUtil.loadFromDir(new Path(this.fileStoreUtil.getDataDir()), FILE_PREFIX_POLICY, RangerPolicy.class);
            this.nextPolicyId = this.getMaxId(ret) + 1L;
        }
        catch (Exception excp) {
            LOG.error((Object)"ServiceFileStore.getAllPolicies(): failed to read policies", (Throwable)excp);
        }
        if (ret != null) {
            Collections.sort(ret, ServicePredicateUtil.idComparator);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== ServiceFileStore.getAllPolicies(): count=" + (ret == null ? 0 : ret.size())));
        }
        return ret;
    }

    @Override
    public void setPopulateExistingBaseFields(Boolean populateExistingBaseFields) {
        this.populateExistingBaseFields = populateExistingBaseFields;
    }

    @Override
    public Boolean getPopulateExistingBaseFields() {
        return this.populateExistingBaseFields;
    }
}

