/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceEvaluator;
import org.apache.ranger.plugin.resourcematcher.RangerResourceMatcher;
import org.apache.ranger.plugin.util.TrieNode;

public class RangerResourceTrie<T extends RangerPolicyResourceEvaluator> {
    private static final Log LOG = LogFactory.getLog(RangerResourceTrie.class);
    private static final String DEFAULT_WILDCARD_CHARS = "*?";
    private final String resourceName;
    private final boolean optIgnoreCase;
    private final boolean optWildcard;
    private final String wildcardChars;
    private final TrieNode root;

    public RangerResourceTrie(RangerServiceDef.RangerResourceDef resourceDef, List<T> evaluators) {
        Map<String, String> matcherOptions;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerResourceTrie(" + resourceDef.getName() + ", evaluatorCount=" + evaluators.size() + ")"));
        }
        String strIgnoreCase = (matcherOptions = resourceDef.getMatcherOptions()) != null ? matcherOptions.get("ignoreCase") : null;
        String strWildcard = matcherOptions != null ? matcherOptions.get("wildCard") : null;
        this.resourceName = resourceDef.getName();
        this.optIgnoreCase = strIgnoreCase != null ? Boolean.parseBoolean(strIgnoreCase) : false;
        this.optWildcard = strWildcard != null ? Boolean.parseBoolean(strWildcard) : false;
        this.wildcardChars = this.optWildcard ? DEFAULT_WILDCARD_CHARS : "";
        this.root = new TrieNode(Character.valueOf('\u0000'));
        for (RangerPolicyResourceEvaluator evaluator : evaluators) {
            RangerPolicy.RangerPolicyResource policyResource;
            Map<String, RangerPolicy.RangerPolicyResource> policyResources = evaluator.getPolicyResource();
            RangerPolicy.RangerPolicyResource rangerPolicyResource = policyResource = policyResources != null ? policyResources.get(this.resourceName) : null;
            if (policyResource == null) {
                if (evaluator.getLeafResourceLevel() == null || resourceDef.getLevel() == null || evaluator.getLeafResourceLevel() >= resourceDef.getLevel()) continue;
                this.root.addWildcardEvaluator(evaluator);
                continue;
            }
            if (policyResource.getIsExcludes().booleanValue()) {
                this.root.addWildcardEvaluator(evaluator);
                continue;
            }
            RangerResourceMatcher resourceMatcher = evaluator.getResourceMatcher(this.resourceName);
            if (resourceMatcher != null && resourceMatcher.isMatchAny()) {
                this.root.addWildcardEvaluator(evaluator);
                continue;
            }
            if (!CollectionUtils.isNotEmpty(policyResource.getValues())) continue;
            for (String resource : policyResource.getValues()) {
                this.insert(resource, policyResource.getIsRecursive(), evaluator);
            }
        }
        this.root.postSetup(null);
        LOG.info((Object)this.toString());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerResourceTrie(" + resourceDef.getName() + ", evaluatorCount=" + evaluators.size() + "): " + this.toString()));
        }
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public List<T> getEvaluatorsForResource(String resource) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerResourceTrie.getEvaluatorsForResource(" + resource + ")"));
        }
        List ret = null;
        TrieNode curr = this.root;
        int len = resource.length();
        for (int i = 0; i < len; ++i) {
            Character ch = this.getLookupChar(resource.charAt(i));
            TrieNode child = curr.getChild(ch);
            if (child == null) {
                ret = curr.getWildcardEvaluators();
                curr = null;
                break;
            }
            curr = child;
        }
        if (ret == null && curr != null) {
            ret = curr.getEvaluators();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerResourceTrie.getEvaluatorsForResource(" + resource + "): evaluatorCount=" + (ret == null ? 0 : ret.size())));
        }
        return ret;
    }

    public TrieData getTrieData() {
        TrieData ret = new TrieData();
        this.root.populateTrieData(ret);
        ret.maxDepth = this.getMaxDepth();
        return ret;
    }

    public int getMaxDepth() {
        return this.root.getMaxDepth();
    }

    public void reorderEvaluators() {
        this.root.reorderEvaluators(null);
    }

    private final Character getLookupChar(char ch) {
        if (this.optIgnoreCase) {
            ch = Character.toLowerCase(ch);
        }
        return Character.valueOf(ch);
    }

    private void insert(String resource, boolean isRecursive, T evaluator) {
        TrieNode curr = this.root;
        boolean isWildcard = false;
        int len = resource.length();
        for (int i = 0; i < len; ++i) {
            Character ch = this.getLookupChar(resource.charAt(i));
            if (this.optWildcard && this.wildcardChars.indexOf(ch.charValue()) != -1) {
                isWildcard = true;
                break;
            }
            curr = curr.getOrCreateChild(ch);
        }
        if (isWildcard || isRecursive) {
            curr.addWildcardEvaluator(evaluator);
        } else {
            curr.addEvaluator(evaluator);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        TrieData trieData = this.getTrieData();
        sb.append("resourceName=").append(this.resourceName);
        sb.append("; optIgnoreCase=").append(this.optIgnoreCase);
        sb.append("; optWildcard=").append(this.optWildcard);
        sb.append("; wildcardChars=").append(this.wildcardChars);
        sb.append("; nodeCount=").append(trieData.nodeCount);
        sb.append("; leafNodeCount=").append(trieData.leafNodeCount);
        sb.append("; singleChildNodeCount=").append(trieData.singleChildNodeCount);
        sb.append("; maxDepth=").append(trieData.maxDepth);
        sb.append("; evaluatorListCount=").append(trieData.evaluatorListCount);
        sb.append("; wildcardEvaluatorListCount=").append(trieData.wildcardEvaluatorListCount);
        sb.append("; evaluatorListRefCount=").append(trieData.evaluatorListRefCount);
        sb.append("; wildcardEvaluatorListRefCount=").append(trieData.wildcardEvaluatorListRefCount);
        return sb.toString();
    }

    public class TrieData {
        int nodeCount = 0;
        int leafNodeCount = 0;
        int singleChildNodeCount = 0;
        int maxDepth = 0;
        int evaluatorListCount = 0;
        int wildcardEvaluatorListCount = 0;
        int evaluatorListRefCount = 0;
        int wildcardEvaluatorListRefCount = 0;
    }
}

