/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.conditionevaluator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.conditionevaluator.RangerAbstractConditionEvaluator;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyresourcematcher.RangerDefaultPolicyResourceMatcher;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.RangerRequestedResources;

public class RangerHiveResourcesAccessedTogetherCondition
extends RangerAbstractConditionEvaluator {
    private static final Log LOG = LogFactory.getLog(RangerHiveResourcesAccessedTogetherCondition.class);
    private List<RangerPolicyResourceMatcher> matchers = new ArrayList<RangerPolicyResourceMatcher>();
    private boolean isInitialized = false;

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerHiveResourcesAccessedTogetherCondition.init(" + this.condition + ")"));
        }
        super.init();
        if (this.serviceDef != null) {
            this.doInitialize();
        } else {
            LOG.error((Object)"RangerHiveResourcesAccessedTogetherCondition.init() - ServiceDef not set ... ERROR ..");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerHiveResourcesAccessedTogetherCondition.init(" + this.condition + ")"));
        }
    }

    @Override
    public boolean isMatched(RangerAccessRequest request) {
        boolean ret = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerHiveResourcesAccessedTogetherCondition.isMatched(" + request + ")"));
        }
        if (this.isInitialized && CollectionUtils.isNotEmpty(this.matchers)) {
            RangerRequestedResources resources = RangerAccessRequestUtil.getRequestedResourcesFromContext(request.getContext());
            ret = resources == null ? false : !resources.isMutuallyExcluded(this.matchers, request.getContext());
        } else {
            LOG.error((Object)"RangerHiveResourcesAccessedTogetherCondition.isMatched() - condition is not initialized correctly and will NOT be enforced");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerHiveResourcesAccessedTogetherCondition.isMatched(" + request + "), result=" + ret));
        }
        return ret;
    }

    private void doInitialize() {
        List<String> mutuallyExclusiveResources = this.condition.getValues();
        if (CollectionUtils.isNotEmpty(mutuallyExclusiveResources)) {
            this.initializeMatchers(mutuallyExclusiveResources);
            if (CollectionUtils.isEmpty(this.matchers)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"RangerHiveResourcesAccessedTogetherCondition.doInitialize() - Cannot create matchers from values in MutualExclustionEnforcer");
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("RangerHiveResourcesAccessedTogetherCondition.doInitialize() - Created " + this.matchers.size() + " matchers from values in MutualExclustionEnforcer"));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"RangerHiveResourcesAccessedTogetherCondition.doInitialize() - No values in MutualExclustionEnforcer");
        }
        this.isInitialized = true;
    }

    private void initializeMatchers(List<String> mutuallyExclusiveResources) {
        for (String s : mutuallyExclusiveResources) {
            String policyResourceSpec = s.trim();
            RangerPolicyResourceMatcher matcher = this.buildMatcher(policyResourceSpec);
            if (matcher == null) continue;
            this.matchers.add(matcher);
        }
    }

    private RangerPolicyResourceMatcher buildMatcher(String policyResourceSpec) {
        RangerDefaultPolicyResourceMatcher matcher = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerHiveResourcesAccessedTogetherCondition.buildMatcher(" + policyResourceSpec + ")"));
        }
        if (this.serviceDef != null && this.serviceDef.getName().equals("hive")) {
            char separator = '.';
            String any = "*";
            HashMap<String, RangerPolicy.RangerPolicyResource> policyResources = new HashMap<String, RangerPolicy.RangerPolicyResource>();
            String[] elements = StringUtils.split((String)policyResourceSpec, (char)separator);
            if (elements.length > 0 && elements.length < 4) {
                RangerPolicy.RangerPolicyResource policyResource = elements.length == 3 ? new RangerPolicy.RangerPolicyResource(elements[2]) : new RangerPolicy.RangerPolicyResource(any);
                policyResources.put("column", policyResource);
                policyResource = elements.length >= 2 ? new RangerPolicy.RangerPolicyResource(elements[1]) : new RangerPolicy.RangerPolicyResource(any);
                policyResources.put("table", policyResource);
                policyResource = new RangerPolicy.RangerPolicyResource(elements[0]);
                policyResources.put("database", policyResource);
                matcher = new RangerDefaultPolicyResourceMatcher();
                matcher.setPolicyResources(policyResources);
                matcher.setServiceDef(this.serviceDef);
                matcher.init();
            } else {
                LOG.error((Object)("RangerHiveResourcesAccessedTogetherCondition.buildMatcher() - Incorrect elements in the hierarchy specified (" + elements.length + ")"));
            }
        } else {
            LOG.error((Object)"RangerHiveResourcesAccessedTogetherCondition.buildMatcher() - ServiceDef not set or ServiceDef is not for Hive");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerHiveResourcesAccessedTogetherCondition.buildMatcher(" + policyResourceSpec + "), matcher=" + matcher));
        }
        return matcher;
    }
}

