/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.contextenricher;

import java.nio.channels.ClosedByInterruptException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.admin.client.RangerAdminClient;
import org.apache.ranger.plugin.contextenricher.RangerTagRetriever;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.apache.ranger.plugin.util.ServiceTags;

public class RangerAdminTagRetriever
extends RangerTagRetriever {
    private static final Log LOG = LogFactory.getLog(RangerAdminTagRetriever.class);
    private RangerAdminClient adminClient;

    @Override
    public void init(Map<String, String> options) {
        if (StringUtils.isNotBlank((String)this.serviceName) && this.serviceDef != null && StringUtils.isNotBlank((String)this.appId)) {
            String propertyPrefix = "ranger.plugin." + this.serviceDef.getName();
            this.adminClient = RangerBasePlugin.createAdminClient(this.serviceName, this.appId, propertyPrefix);
        } else {
            LOG.error((Object)"FATAL: Cannot find service/serviceDef to use for retrieving tags. Will NOT be able to retrieve tags.");
        }
    }

    @Override
    public ServiceTags retrieveTags(long lastKnownVersion) throws InterruptedException {
        ServiceTags serviceTags = null;
        if (this.adminClient != null) {
            try {
                serviceTags = this.adminClient.getServiceTagsIfUpdated(lastKnownVersion);
            }
            catch (InterruptedException interruptedException) {
                LOG.error((Object)"Tag-retriever thread was interrupted");
                throw interruptedException;
            }
            catch (ClosedByInterruptException closedByInterruptException) {
                LOG.error((Object)"Tag-retriever thread was interrupted while blocked on I/O");
                throw new InterruptedException();
            }
            catch (Exception exception) {
                LOG.error((Object)"RangerAdminTagRetriever.retrieveTags() - Error retrieving resources, exception=", (Throwable)exception);
            }
        }
        return serviceTags;
    }
}

