/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.contextenricher;

import java.nio.channels.ClosedByInterruptException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.contextenricher.RangerTagRetriever;
import org.apache.ranger.plugin.store.TagStore;
import org.apache.ranger.plugin.store.file.TagFileStore;
import org.apache.ranger.plugin.util.ServiceTags;

public class RangerTagFileStoreRetriever
extends RangerTagRetriever {
    private static final Log LOG = LogFactory.getLog(RangerTagFileStoreRetriever.class);
    private TagStore tagStore;

    @Override
    public void init(Map<String, String> options) {
        if (StringUtils.isNotBlank((String)this.serviceName) && this.serviceDef != null && StringUtils.isNotBlank((String)this.appId)) {
            this.tagStore = TagFileStore.getInstance();
        } else {
            LOG.error((Object)"FATAL: Cannot find service-name to use for retrieving tags. Will NOT be able to retrieve tags.");
        }
    }

    @Override
    public ServiceTags retrieveTags(long lastKnownVersion) throws InterruptedException {
        ServiceTags serviceTags = null;
        if (this.tagStore != null) {
            try {
                serviceTags = this.tagStore.getServiceTagsIfUpdated(this.serviceName, lastKnownVersion);
            }
            catch (InterruptedException interruptedException) {
                LOG.error((Object)"Tag-retriever thread was interrupted");
                throw interruptedException;
            }
            catch (ClosedByInterruptException closedByInterruptException) {
                LOG.error((Object)"Tag-retriever thread was interrupted while blocked on I/O");
                throw new InterruptedException();
            }
            catch (Exception exception) {
                LOG.error((Object)"RangerTagFileStoreRetriever.retrieveTags() - Error retrieving resources, exception=", (Throwable)exception);
            }
        }
        return serviceTags;
    }
}

