/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model.validation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;

public class RangerServiceDefHelper {
    private static final Log LOG = LogFactory.getLog(RangerServiceDefHelper.class);
    static final Map<String, Delegate> _Cache = new ConcurrentHashMap<String, Delegate>();
    final Delegate _delegate;

    public RangerServiceDefHelper(RangerServiceDef serviceDef) {
        this(serviceDef, true);
    }

    public RangerServiceDefHelper(RangerServiceDef serviceDef, boolean useCache) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerPolicyValidator.isValidResourceNames(%s)", serviceDef));
        }
        String serviceName = serviceDef.getName();
        Date serviceDefFreshnessDate = serviceDef.getUpdateTime();
        Delegate delegate = null;
        if (useCache && _Cache.containsKey(serviceName)) {
            LOG.debug((Object)"RangerServiceDefHelper(): found delegate in cache with matching serviceName.  Need to check date");
            Delegate that = _Cache.get(serviceName);
            if (Objects.equals(that.getServiceFreshnessDate(), serviceDefFreshnessDate)) {
                delegate = that;
                LOG.debug((Object)"RangerServiceDefHelper(): cached delegate matched in date, too! Will use it now.");
            } else {
                LOG.debug((Object)"RangerServiceDefHelper(): cached delegate date mismatch!");
            }
        }
        if (delegate == null) {
            delegate = new Delegate(serviceDef);
            if (useCache) {
                LOG.debug((Object)"RangerServiceDefHelper(): Created new delegate and put in delegate cache!");
                _Cache.put(serviceName, delegate);
            }
        }
        this._delegate = delegate;
    }

    public Set<List<RangerServiceDef.RangerResourceDef>> getResourceHierarchies(Integer policyType) {
        return this._delegate.getResourceHierarchies(policyType);
    }

    public Set<String> getMandatoryResourceNames(List<RangerServiceDef.RangerResourceDef> hierarchy) {
        HashSet<String> result = new HashSet<String>(hierarchy.size());
        for (RangerServiceDef.RangerResourceDef resourceDef : hierarchy) {
            if (!Boolean.TRUE.equals(resourceDef.getMandatory())) continue;
            result.add(resourceDef.getName());
        }
        return result;
    }

    public Set<String> getAllResourceNames(List<RangerServiceDef.RangerResourceDef> hierarchy) {
        HashSet<String> result = new HashSet<String>(hierarchy.size());
        for (RangerServiceDef.RangerResourceDef resourceDef : hierarchy) {
            result.add(resourceDef.getName());
        }
        return result;
    }

    public List<String> getAllResourceNamesOrdered(List<RangerServiceDef.RangerResourceDef> hierarchy) {
        ArrayList<String> result = new ArrayList<String>(hierarchy.size());
        for (RangerServiceDef.RangerResourceDef resourceDef : hierarchy) {
            result.add(resourceDef.getName());
        }
        return result;
    }

    public boolean isResourceGraphValid() {
        return this._delegate.isResourceGraphValid();
    }

    static class DirectedGraph {
        Map<String, Set<String>> _nodes = new HashMap<String, Set<String>>();

        DirectedGraph() {
        }

        void add(String node) {
            if (node == null) {
                throw new IllegalArgumentException("Node can't be null!");
            }
            if (!this._nodes.containsKey(node)) {
                this._nodes.put(node, new HashSet());
            }
        }

        void addArc(String from, String to) {
            if (!this._nodes.containsKey(from)) {
                this.add(from);
            }
            if (!this._nodes.containsKey(to)) {
                this.add(to);
            }
            this._nodes.get(from).add(to);
        }

        boolean hasArc(String from, String to) {
            return this._nodes.containsKey(from) && this._nodes.containsKey(to) && this._nodes.get(from).contains(to);
        }

        boolean hasNeighbors(String from) {
            return this._nodes.containsKey(from) && this._nodes.get(from).size() > 0;
        }

        Set<String> getSources() {
            HashSet<String> sources = new HashSet<String>(this._nodes.keySet());
            for (Map.Entry<String, Set<String>> entry : this._nodes.entrySet()) {
                Set<String> nbrs = entry.getValue();
                sources.removeAll(nbrs);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Returning sources: " + sources));
            }
            return sources;
        }

        Set<String> getSinks() {
            HashSet<String> sinks = new HashSet<String>();
            for (Map.Entry<String, Set<String>> entry : this._nodes.entrySet()) {
                Set<String> nbrs = entry.getValue();
                if (!nbrs.isEmpty()) continue;
                String node = entry.getKey();
                sinks.add(node);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Returning sinks: " + sinks));
            }
            return sinks;
        }

        List<String> getAPath(String from, String to, Set<String> alreadyVisited) {
            ArrayList<String> path = new ArrayList<String>(this._nodes.size());
            if (this._nodes.containsKey(from) && this._nodes.containsKey(to)) {
                if (this.hasArc(from, to)) {
                    path.add(from);
                    path.add(to);
                } else {
                    alreadyVisited.add(from);
                    Set<String> nbrs = this._nodes.get(from);
                    for (String nbr : nbrs) {
                        List<String> subPath;
                        if (alreadyVisited.contains(nbr) || (subPath = this.getAPath(nbr, to, alreadyVisited)).isEmpty()) continue;
                        path.add(from);
                        path.addAll(subPath);
                    }
                }
            }
            return path;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            DirectedGraph that = (DirectedGraph)object;
            return Objects.equals(this._nodes, that._nodes);
        }

        public int hashCode() {
            return Objects.hashCode(this._nodes);
        }

        public String toString() {
            return "_nodes=" + Objects.toString(this._nodes);
        }
    }

    static class Delegate {
        final Map<Integer, Set<List<RangerServiceDef.RangerResourceDef>>> _hierarchies = new HashMap<Integer, Set<List<RangerServiceDef.RangerResourceDef>>>();
        final Date _serviceDefFreshnessDate;
        final String _serviceName;
        final boolean _valid;
        static final Set<List<RangerServiceDef.RangerResourceDef>> EMPTY_RESOURCE_HIERARCHY = Collections.unmodifiableSet(new HashSet());

        public Delegate(RangerServiceDef serviceDef) {
            this._serviceName = serviceDef.getName();
            this._serviceDefFreshnessDate = serviceDef.getUpdateTime();
            boolean isValid = true;
            int[] nArray = RangerPolicy.POLICY_TYPES;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer policyType = nArray[i];
                List<RangerServiceDef.RangerResourceDef> resources = this.getResourceDefs(serviceDef, policyType);
                DirectedGraph graph = this.createGraph(resources);
                if (graph != null) {
                    if (this.isValid(graph)) {
                        Set<List<String>> hierarchies = this.getHierarchies(graph);
                        this._hierarchies.put(policyType, Collections.unmodifiableSet(this.convertHierarchies(hierarchies, this.getResourcesAsMap(resources))));
                        continue;
                    }
                    isValid = false;
                    this._hierarchies.put(policyType, EMPTY_RESOURCE_HIERARCHY);
                    continue;
                }
                this._hierarchies.put(policyType, EMPTY_RESOURCE_HIERARCHY);
            }
            this._valid = isValid;
            if (LOG.isDebugEnabled()) {
                String message = String.format("Found [%d] resource hierarchies for service [%s] update-date[%s]: %s", this._hierarchies.size(), this._serviceName, this._serviceDefFreshnessDate == null ? null : this._serviceDefFreshnessDate.toString(), this._hierarchies);
                LOG.debug((Object)message);
            }
        }

        public Set<List<RangerServiceDef.RangerResourceDef>> getResourceHierarchies(Integer policyType) {
            Set<List<RangerServiceDef.RangerResourceDef>> ret;
            if (policyType == null) {
                policyType = 0;
            }
            if ((ret = this._hierarchies.get(policyType)) == null) {
                ret = EMPTY_RESOURCE_HIERARCHY;
            }
            return ret;
        }

        public String getServiceName() {
            return this._serviceName;
        }

        public Date getServiceFreshnessDate() {
            return this._serviceDefFreshnessDate;
        }

        public boolean isResourceGraphValid() {
            return this._valid;
        }

        DirectedGraph createGraph(List<RangerServiceDef.RangerResourceDef> resourceDefs) {
            DirectedGraph graph = null;
            if (CollectionUtils.isNotEmpty(resourceDefs)) {
                graph = new DirectedGraph();
                for (RangerServiceDef.RangerResourceDef resourceDef : resourceDefs) {
                    String name = resourceDef.getName();
                    graph.add(name);
                    String parent = resourceDef.getParent();
                    if (!StringUtils.isNotEmpty((String)parent)) continue;
                    graph.addArc(parent, name);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Created graph for resources: " + graph));
            }
            return graph;
        }

        List<RangerServiceDef.RangerResourceDef> getResourceDefs(RangerServiceDef serviceDef, Integer policyType) {
            List<RangerServiceDef.RangerResourceDef> resourceDefs = policyType == null || policyType == 0 ? serviceDef.getResources() : (policyType == 1 ? (serviceDef.getDataMaskDef() != null ? serviceDef.getDataMaskDef().getResources() : null) : (policyType == 2 ? (serviceDef.getRowFilterDef() != null ? serviceDef.getRowFilterDef().getResources() : null) : serviceDef.getResources()));
            return resourceDefs;
        }

        boolean isValid(DirectedGraph graph) {
            return graph.getSources().size() > 0 && graph.getSinks().size() > 0;
        }

        Set<List<String>> getHierarchies(DirectedGraph graph) {
            HashSet<List<String>> hierarchies = new HashSet<List<String>>();
            Set<String> sources = graph.getSources();
            Set<String> sinks = graph.getSinks();
            for (String source : sources) {
                if (!graph.hasNeighbors(source)) {
                    ArrayList path = Lists.newArrayList((Object[])new String[]{source});
                    hierarchies.add(path);
                    continue;
                }
                for (String sink : sinks) {
                    List<String> path = graph.getAPath(source, sink, new HashSet<String>());
                    if (path.isEmpty()) continue;
                    hierarchies.add(path);
                }
            }
            return hierarchies;
        }

        Set<List<RangerServiceDef.RangerResourceDef>> convertHierarchies(Set<List<String>> hierarchies, Map<String, RangerServiceDef.RangerResourceDef> resourceMap) {
            HashSet<List<RangerServiceDef.RangerResourceDef>> result = new HashSet<List<RangerServiceDef.RangerResourceDef>>(hierarchies.size());
            for (List<String> hierarchy : hierarchies) {
                ArrayList<RangerServiceDef.RangerResourceDef> resourceList = new ArrayList<RangerServiceDef.RangerResourceDef>(hierarchy.size());
                for (String name : hierarchy) {
                    RangerServiceDef.RangerResourceDef def = resourceMap.get(name);
                    resourceList.add(def);
                }
                result.add(resourceList);
            }
            return result;
        }

        Map<String, RangerServiceDef.RangerResourceDef> getResourcesAsMap(List<RangerServiceDef.RangerResourceDef> resourceList) {
            HashMap<String, RangerServiceDef.RangerResourceDef> map = new HashMap<String, RangerServiceDef.RangerResourceDef>(resourceList.size());
            for (RangerServiceDef.RangerResourceDef resourceDef : resourceList) {
                map.put(resourceDef.getName(), resourceDef);
            }
            return map;
        }
    }
}

