/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceReadOnly;
import org.apache.ranger.plugin.policyengine.RangerMutableResource;

public class RangerAccessResourceImpl
implements RangerMutableResource {
    private String ownerUser = null;
    private Map<String, String> elements = null;
    private String stringifiedValue = null;
    private String stringifiedCacheKeyValue = null;
    private String leafName = null;
    private RangerServiceDef serviceDef = null;

    public RangerAccessResourceImpl() {
        this(null, null);
    }

    public RangerAccessResourceImpl(Map<String, String> elements) {
        this(elements, null);
    }

    public RangerAccessResourceImpl(Map<String, String> elements, String ownerUser) {
        this.elements = elements;
        this.ownerUser = ownerUser;
    }

    @Override
    public String getOwnerUser() {
        return this.ownerUser;
    }

    @Override
    public boolean exists(String name) {
        return this.elements != null && this.elements.containsKey(name);
    }

    @Override
    public String getValue(String name) {
        String ret = null;
        if (this.elements != null && this.elements.containsKey(name)) {
            ret = this.elements.get(name);
        }
        return ret;
    }

    @Override
    public Set<String> getKeys() {
        Set<String> ret = null;
        if (this.elements != null) {
            ret = this.elements.keySet();
        }
        return ret;
    }

    @Override
    public void setOwnerUser(String ownerUser) {
        this.ownerUser = ownerUser;
    }

    @Override
    public void setValue(String name, String value) {
        if (value == null) {
            if (this.elements != null) {
                this.elements.remove(name);
                if (this.elements.isEmpty()) {
                    this.elements = null;
                }
            }
        } else {
            if (this.elements == null) {
                this.elements = new HashMap<String, String>();
            }
            this.elements.put(name, value);
        }
        this.leafName = null;
        this.stringifiedCacheKeyValue = null;
        this.stringifiedValue = null;
    }

    @Override
    public void setServiceDef(RangerServiceDef serviceDef) {
        this.serviceDef = serviceDef;
        this.leafName = null;
        this.stringifiedCacheKeyValue = null;
        this.stringifiedValue = null;
    }

    @Override
    public RangerServiceDef getServiceDef() {
        return this.serviceDef;
    }

    @Override
    public String getLeafName() {
        String ret = this.leafName;
        if (ret == null && this.serviceDef != null && this.serviceDef.getResources() != null) {
            List<RangerServiceDef.RangerResourceDef> resourceDefs = this.serviceDef.getResources();
            for (int idx = resourceDefs.size() - 1; idx >= 0; --idx) {
                RangerServiceDef.RangerResourceDef resourceDef = resourceDefs.get(idx);
                if (resourceDef == null || !this.exists(resourceDef.getName())) continue;
                ret = this.leafName = resourceDef.getName();
                break;
            }
        }
        return ret;
    }

    @Override
    public String getAsString() {
        String ret = this.stringifiedValue;
        if (ret == null && this.serviceDef != null && this.serviceDef.getResources() != null) {
            StringBuilder sb = new StringBuilder();
            for (RangerServiceDef.RangerResourceDef resourceDef : this.serviceDef.getResources()) {
                if (resourceDef == null || !this.exists(resourceDef.getName())) continue;
                if (sb.length() > 0) {
                    sb.append("/");
                }
                sb.append(this.getValue(resourceDef.getName()));
            }
            if (sb.length() > 0) {
                ret = this.stringifiedValue = sb.toString();
            }
        }
        return ret;
    }

    @Override
    public String getCacheKey() {
        String ret = this.stringifiedCacheKeyValue;
        if (ret == null && this.serviceDef != null && this.serviceDef.getResources() != null) {
            StringBuilder sb = new StringBuilder();
            for (RangerServiceDef.RangerResourceDef resourceDef : this.serviceDef.getResources()) {
                if (resourceDef == null || !this.exists(resourceDef.getName())) continue;
                if (sb.length() > 0) {
                    sb.append("/");
                }
                sb.append(resourceDef.getName()).append("=").append(this.getValue(resourceDef.getName()));
            }
            if (sb.length() > 0) {
                ret = this.stringifiedCacheKeyValue = sb.toString();
            }
        }
        return ret;
    }

    @Override
    public Map<String, String> getAsMap() {
        return Collections.unmodifiableMap(this.elements);
    }

    @Override
    public RangerAccessResource getReadOnlyCopy() {
        return new RangerAccessResourceReadOnly(this);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RangerAccessResourceImpl)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        RangerAccessResourceImpl other = (RangerAccessResourceImpl)obj;
        return ObjectUtils.equals((Object)this.ownerUser, (Object)other.ownerUser) && ObjectUtils.equals(this.elements, other.elements);
    }

    public int hashCode() {
        int ret = 7;
        ret = 31 * ret + ObjectUtils.hashCode((Object)this.ownerUser);
        ret = 31 * ret + ObjectUtils.hashCode(this.elements);
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerResourceImpl={");
        sb.append("ownerUser={").append(this.ownerUser).append("} ");
        sb.append("elements={");
        if (this.elements != null) {
            for (Map.Entry<String, String> e : this.elements.entrySet()) {
                sb.append(e.getKey()).append("=").append(e.getValue()).append("; ");
            }
        }
        sb.append("} ");
        sb.append("}");
        return sb;
    }
}

