/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.resourcematcher;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.resourcematcher.RecursiveMatcher;

final class CaseSensitiveRecursiveMatcher
extends RecursiveMatcher {
    CaseSensitiveRecursiveMatcher(String value, char levelSeparatorChar) {
        super(value, levelSeparatorChar);
    }

    @Override
    boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
        String noSeparator;
        if (this.getNeedsDynamicEval()) {
            noSeparator = this.getStringToCompare(this.getExpandedValue(evalContext));
        } else {
            if (this.valueWithoutSeparator == null) {
                this.valueWithoutSeparator = this.getStringToCompare(this.value);
                this.valueWithSeparator = this.valueWithoutSeparator + Character.toString(this.levelSeparatorChar);
            }
            noSeparator = this.valueWithoutSeparator;
        }
        boolean ret = StringUtils.equals((String)resourceValue, (String)noSeparator);
        if (!ret) {
            String withSeparator = this.getNeedsDynamicEval() ? noSeparator + Character.toString(this.levelSeparatorChar) : this.valueWithSeparator;
            ret = StringUtils.startsWith((String)resourceValue, (String)withSeparator);
        }
        return ret;
    }

    @Override
    int getPriority() {
        return 7 + (this.getNeedsDynamicEval() ? 8 : 0);
    }
}

