/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerBaseModelObject;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.util.SearchFilter;

public class AbstractPredicateUtil {
    private static Map<String, Comparator<RangerBaseModelObject>> sorterMap = new HashMap<String, Comparator<RangerBaseModelObject>>();
    public static final Comparator<RangerBaseModelObject> idComparator = new Comparator<RangerBaseModelObject>(){

        @Override
        public int compare(RangerBaseModelObject o1, RangerBaseModelObject o2) {
            Long val1 = o1 != null ? o1.getId() : null;
            Long val2 = o2 != null ? o2.getId() : null;
            return ObjectUtils.compare((Comparable)val1, (Comparable)val2);
        }
    };
    protected static final Comparator<RangerBaseModelObject> createTimeComparator = new Comparator<RangerBaseModelObject>(){

        @Override
        public int compare(RangerBaseModelObject o1, RangerBaseModelObject o2) {
            Date val1 = o1 != null ? o1.getCreateTime() : null;
            Date val2 = o2 != null ? o2.getCreateTime() : null;
            return ObjectUtils.compare((Comparable)val1, (Comparable)val2);
        }
    };
    protected static final Comparator<RangerBaseModelObject> updateTimeComparator = new Comparator<RangerBaseModelObject>(){

        @Override
        public int compare(RangerBaseModelObject o1, RangerBaseModelObject o2) {
            Date val1 = o1 != null ? o1.getUpdateTime() : null;
            Date val2 = o2 != null ? o2.getUpdateTime() : null;
            return ObjectUtils.compare((Comparable)val1, (Comparable)val2);
        }
    };
    protected static final Comparator<RangerBaseModelObject> serviceDefNameComparator = new Comparator<RangerBaseModelObject>(){

        @Override
        public int compare(RangerBaseModelObject o1, RangerBaseModelObject o2) {
            String val1 = null;
            String val2 = null;
            if (o1 != null) {
                if (o1 instanceof RangerServiceDef) {
                    val1 = ((RangerServiceDef)o1).getName();
                } else if (o1 instanceof RangerService) {
                    val1 = ((RangerService)o1).getType();
                }
            }
            if (o2 != null) {
                if (o2 instanceof RangerServiceDef) {
                    val2 = ((RangerServiceDef)o2).getName();
                } else if (o2 instanceof RangerService) {
                    val2 = ((RangerService)o2).getType();
                }
            }
            return ObjectUtils.compare(val1, val2);
        }
    };
    protected static final Comparator<RangerBaseModelObject> serviceNameComparator = new Comparator<RangerBaseModelObject>(){

        @Override
        public int compare(RangerBaseModelObject o1, RangerBaseModelObject o2) {
            String val1 = null;
            String val2 = null;
            if (o1 != null) {
                if (o1 instanceof RangerPolicy) {
                    val1 = ((RangerPolicy)o1).getService();
                } else if (o1 instanceof RangerService) {
                    val1 = ((RangerService)o1).getType();
                }
            }
            if (o2 != null) {
                if (o2 instanceof RangerPolicy) {
                    val2 = ((RangerPolicy)o2).getService();
                } else if (o2 instanceof RangerService) {
                    val2 = ((RangerService)o2).getType();
                }
            }
            return ObjectUtils.compare(val1, val2);
        }
    };
    protected static final Comparator<RangerBaseModelObject> policyNameComparator = new Comparator<RangerBaseModelObject>(){

        @Override
        public int compare(RangerBaseModelObject o1, RangerBaseModelObject o2) {
            String val1 = o1 != null && o1 instanceof RangerPolicy ? ((RangerPolicy)o1).getName() : null;
            String val2 = o2 != null && o2 instanceof RangerPolicy ? ((RangerPolicy)o2).getName() : null;
            return ObjectUtils.compare((Comparable)((Object)val1), val2);
        }
    };
    public static final Comparator<RangerServiceDef.RangerResourceDef> resourceLevelComparator = new Comparator<RangerServiceDef.RangerResourceDef>(){

        @Override
        public int compare(RangerServiceDef.RangerResourceDef o1, RangerServiceDef.RangerResourceDef o2) {
            Integer val1 = o1 != null ? o1.getLevel() : null;
            Integer val2 = o2 != null ? o2.getLevel() : null;
            return ObjectUtils.compare((Comparable)val1, (Comparable)val2);
        }
    };

    public void applyFilter(List<? extends RangerBaseModelObject> objList, SearchFilter filter) {
        Comparator<RangerBaseModelObject> sorter;
        if (CollectionUtils.isEmpty(objList)) {
            return;
        }
        Predicate pred = this.getPredicate(filter);
        if (pred != null) {
            CollectionUtils.filter(objList, (Predicate)pred);
        }
        if ((sorter = this.getSorter(filter)) != null) {
            Collections.sort(objList, sorter);
        }
    }

    public Predicate getPredicate(SearchFilter filter) {
        if (filter == null || filter.isEmpty()) {
            return null;
        }
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.addPredicates(filter, predicates);
        Predicate ret = CollectionUtils.isEmpty(predicates) ? null : PredicateUtils.allPredicate(predicates);
        return ret;
    }

    public void addPredicates(SearchFilter filter, List<Predicate> predicates) {
        this.addPredicateForServiceType(filter.getParam("serviceType"), predicates);
        this.addPredicateForServiceTypeId(filter.getParam("serviceTypeId"), predicates);
        this.addPredicateForServiceName(filter.getParam("serviceName"), predicates);
        this.addPredicateForPolicyName(filter.getParam("policyName"), predicates);
        this.addPredicateForPolicyId(filter.getParam("policyId"), predicates);
        this.addPredicateForIsEnabled(filter.getParam("isEnabled"), predicates);
        this.addPredicateForIsRecursive(filter.getParam("isRecursive"), predicates);
        this.addPredicateForTagServiceName(filter.getParam("tagServiceName"), predicates);
        this.addPredicateForUserName(filter.getParam("user"), predicates);
        this.addPredicateForGroupName(filter.getParam("group"), predicates);
        this.addPredicateForResources(filter.getParamsWithPrefix("resource:", true), predicates);
        this.addPredicateForPolicyResource(filter.getParam("polResource"), predicates);
        this.addPredicateForPartialPolicyName(filter.getParam("policyNamePartial"), predicates);
        this.addPredicateForResourceSignature(filter.getParam("resourceSignature:"), predicates);
        this.addPredicateForPolicyType(filter.getParam("policyType"), predicates);
    }

    public Comparator<RangerBaseModelObject> getSorter(SearchFilter filter) {
        String sortBy;
        String string = sortBy = filter == null ? null : filter.getParam("sortBy");
        if (StringUtils.isEmpty((String)sortBy)) {
            return null;
        }
        Comparator<RangerBaseModelObject> ret = sorterMap.get(sortBy);
        return ret;
    }

    private Predicate addPredicateForServiceType(final String serviceType, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)serviceType)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerServiceDef) {
                    RangerServiceDef serviceDef = (RangerServiceDef)object;
                    String svcType = serviceDef.getName();
                    ret = StringUtils.equals((String)svcType, (String)serviceType);
                } else {
                    ret = true;
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForServiceTypeId(final String serviceTypeId, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)serviceTypeId)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerServiceDef) {
                    RangerServiceDef serviceDef = (RangerServiceDef)object;
                    Long svcDefId = serviceDef.getId();
                    if (svcDefId != null) {
                        ret = StringUtils.equals((String)serviceTypeId, (String)svcDefId.toString());
                    }
                } else {
                    ret = true;
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForServiceName(final String serviceName, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)serviceName)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerPolicy) {
                    RangerPolicy policy = (RangerPolicy)object;
                    ret = StringUtils.equals((String)serviceName, (String)policy.getService());
                } else if (object instanceof RangerService) {
                    RangerService service = (RangerService)object;
                    ret = StringUtils.equals((String)serviceName, (String)service.getName());
                } else {
                    ret = true;
                }
                return ret;
            }
        };
        if (ret != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForPolicyName(final String policyName, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)policyName)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerPolicy) {
                    RangerPolicy policy = (RangerPolicy)object;
                    ret = StringUtils.equals((String)policyName, (String)policy.getName());
                } else {
                    ret = true;
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForPartialPolicyName(final String policyName, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)policyName)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerPolicy) {
                    RangerPolicy policy = (RangerPolicy)object;
                    ret = StringUtils.containsIgnoreCase((String)policy.getName(), (String)policyName);
                } else {
                    ret = true;
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForPolicyId(final String policyId, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)policyId)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerPolicy) {
                    RangerPolicy policy = (RangerPolicy)object;
                    if (policy.getId() != null) {
                        ret = StringUtils.equals((String)policyId, (String)policy.getId().toString());
                    }
                } else {
                    ret = true;
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForUserName(final String userName, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)userName)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerPolicy) {
                    List[] policyItemsList;
                    RangerPolicy policy = (RangerPolicy)object;
                    List[] listArray = policyItemsList = new List[]{policy.getPolicyItems(), policy.getDenyPolicyItems(), policy.getAllowExceptions(), policy.getDenyExceptions(), policy.getDataMaskPolicyItems(), policy.getRowFilterPolicyItems()};
                    int n = listArray.length;
                    block0: for (int i = 0; i < n; ++i) {
                        List policyItemsObj;
                        List policyItems = policyItemsObj = listArray[i];
                        for (RangerPolicy.RangerPolicyItem policyItem : policyItems) {
                            if (!policyItem.getUsers().contains(userName)) continue;
                            ret = true;
                            continue block0;
                        }
                    }
                } else {
                    ret = true;
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForGroupName(final String groupName, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)groupName)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerPolicy) {
                    List[] policyItemsList;
                    RangerPolicy policy = (RangerPolicy)object;
                    List[] listArray = policyItemsList = new List[]{policy.getPolicyItems(), policy.getDenyPolicyItems(), policy.getAllowExceptions(), policy.getDenyExceptions(), policy.getDataMaskPolicyItems(), policy.getRowFilterPolicyItems()};
                    int n = listArray.length;
                    block0: for (int i = 0; i < n; ++i) {
                        List policyItemsObj;
                        List policyItems = policyItemsObj = listArray[i];
                        for (RangerPolicy.RangerPolicyItem policyItem : policyItems) {
                            if (!policyItem.getGroups().contains(groupName)) continue;
                            ret = true;
                            continue block0;
                        }
                    }
                } else {
                    ret = true;
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForIsEnabled(final String status, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)status)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerBaseModelObject) {
                    RangerBaseModelObject obj = (RangerBaseModelObject)object;
                    ret = Boolean.parseBoolean(status) ? obj.getIsEnabled() : obj.getIsEnabled() == false;
                } else {
                    ret = true;
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForResources(final Map<String, String> resources, List<Predicate> predicates) {
        if (MapUtils.isEmpty(resources)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerPolicy) {
                    RangerPolicy policy = (RangerPolicy)object;
                    if (!MapUtils.isEmpty(policy.getResources())) {
                        int numFound = 0;
                        for (String name : resources.keySet()) {
                            boolean isMatch = false;
                            RangerPolicy.RangerPolicyResource policyResource = policy.getResources().get(name);
                            if (policyResource != null && !CollectionUtils.isEmpty(policyResource.getValues())) {
                                String val = (String)resources.get(name);
                                if (policyResource.getValues().contains(val)) {
                                    isMatch = true;
                                } else {
                                    for (String policyResourceValue : policyResource.getValues()) {
                                        if (!FilenameUtils.wildcardMatch((String)val, (String)policyResourceValue)) continue;
                                        isMatch = true;
                                        break;
                                    }
                                }
                            }
                            if (!isMatch) break;
                            ++numFound;
                        }
                        ret = numFound == resources.size();
                    }
                } else {
                    ret = true;
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForPolicyResource(final String resourceValue, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)resourceValue)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerPolicy) {
                    RangerPolicy policy = (RangerPolicy)object;
                    Map<String, RangerPolicy.RangerPolicyResource> policyResources = policy.getResources();
                    if (MapUtils.isNotEmpty(policyResources)) {
                        block0: for (Map.Entry<String, RangerPolicy.RangerPolicyResource> entry : policyResources.entrySet()) {
                            RangerPolicy.RangerPolicyResource policyResource = entry.getValue();
                            if (policyResource == null || !CollectionUtils.isNotEmpty(policyResource.getValues())) continue;
                            for (String policyResoureValue : policyResource.getValues()) {
                                if (!StringUtils.containsIgnoreCase((String)policyResoureValue, (String)resourceValue)) continue;
                                ret = true;
                                continue block0;
                            }
                        }
                    }
                } else {
                    ret = true;
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForIsRecursive(String isRecursiveStr, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)isRecursiveStr)) {
            return null;
        }
        final boolean isRecursive = Boolean.parseBoolean(isRecursiveStr);
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                RangerPolicy policy;
                if (object == null) {
                    return false;
                }
                boolean ret = true;
                if (object instanceof RangerPolicy && !MapUtils.isEmpty((policy = (RangerPolicy)object).getResources())) {
                    for (Map.Entry<String, RangerPolicy.RangerPolicyResource> e : policy.getResources().entrySet()) {
                        RangerPolicy.RangerPolicyResource resValue = e.getValue();
                        if (resValue.getIsRecursive() == null) {
                            ret = !isRecursive;
                        } else {
                            boolean bl = ret = resValue.getIsRecursive() == isRecursive;
                        }
                        if (!ret) continue;
                        break;
                    }
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForTagServiceName(final String tagServiceName, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)tagServiceName)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerService) {
                    RangerService service = (RangerService)object;
                    ret = StringUtils.equals((String)tagServiceName, (String)service.getTagService());
                } else {
                    ret = true;
                }
                return ret;
            }
        };
        if (ret != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForResourceSignature(String signature, List<Predicate> predicates) {
        Predicate ret = this.createPredicateForResourceSignature(signature);
        if (predicates != null && ret != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForPolicyType(final String policyType, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)policyType)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                RangerPolicy policy;
                if (object == null) {
                    return false;
                }
                boolean ret = true;
                if (object instanceof RangerPolicy && (policy = (RangerPolicy)object).getPolicyType() != null) {
                    ret = StringUtils.equalsIgnoreCase((String)policyType, (String)policy.getPolicyType().toString());
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    public Predicate createPredicateForResourceSignature(final String policySignature) {
        if (StringUtils.isEmpty((String)policySignature)) {
            return null;
        }
        return new Predicate(){

            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerPolicy) {
                    RangerPolicy policy = (RangerPolicy)object;
                    ret = StringUtils.equals((String)policy.getResourceSignature(), (String)policySignature);
                } else {
                    ret = true;
                }
                return ret;
            }
        };
    }

    static {
        sorterMap.put("serviceType", serviceDefNameComparator);
        sorterMap.put("serviceTypeId", idComparator);
        sorterMap.put("serviceName", serviceNameComparator);
        sorterMap.put("serviceTypeId", idComparator);
        sorterMap.put("policyName", policyNameComparator);
        sorterMap.put("policyId", idComparator);
        sorterMap.put("createTime", createTimeComparator);
        sorterMap.put("updateTime", updateTimeComparator);
    }
}

