/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.model.RangerTag;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.util.RangerRequestedResources;

public class RangerAccessRequestUtil {
    private static final Log LOG = LogFactory.getLog(RangerAccessRequestUtil.class);
    public static final String KEY_CONTEXT_TAGS = "TAGS";
    public static final String KEY_CONTEXT_TAG_OBJECT = "TAG_OBJECT";
    public static final String KEY_CONTEXT_RESOURCE = "RESOURCE";
    public static final String KEY_CONTEXT_REQUESTED_RESOURCES = "REQUESTED_RESOURCES";
    public static final String KEY_TOKEN_NAMESPACE = "token:";
    public static final String KEY_USER = "USER";

    public static void setRequestTagsInContext(Map<String, Object> context, List<RangerTag> tags) {
        if (CollectionUtils.isEmpty(tags)) {
            context.remove(KEY_CONTEXT_TAGS);
        } else {
            context.put(KEY_CONTEXT_TAGS, tags);
        }
    }

    public static List<RangerTag> getRequestTagsFromContext(Map<String, Object> context) {
        List ret = null;
        Object val = context.get(KEY_CONTEXT_TAGS);
        if (val != null && val instanceof List) {
            try {
                List tags;
                ret = tags = (List)val;
            }
            catch (Throwable t) {
                LOG.error((Object)"getRequestTags(): failed to get tags from context", t);
            }
        }
        return ret;
    }

    public static void setCurrentTagInContext(Map<String, Object> context, RangerTag tag) {
        context.put(KEY_CONTEXT_TAG_OBJECT, tag);
    }

    public static RangerTag getCurrentTagFromContext(Map<String, Object> context) {
        RangerTag ret = null;
        Object val = context.get(KEY_CONTEXT_TAGS);
        if (val != null && val instanceof RangerTag) {
            ret = (RangerTag)val;
        }
        return ret;
    }

    public static void setRequestedResourcesInContext(Map<String, Object> context, RangerRequestedResources resources) {
        context.put(KEY_CONTEXT_REQUESTED_RESOURCES, resources);
    }

    public static RangerRequestedResources getRequestedResourcesFromContext(Map<String, Object> context) {
        RangerRequestedResources ret = null;
        Object val = context.get(KEY_CONTEXT_REQUESTED_RESOURCES);
        if (val != null && val instanceof RangerRequestedResources) {
            ret = (RangerRequestedResources)val;
        }
        return ret;
    }

    public static void setCurrentResourceInContext(Map<String, Object> context, RangerAccessResource resource) {
        context.put(KEY_CONTEXT_RESOURCE, resource);
    }

    public static RangerAccessResource getCurrentResourceFromContext(Map<String, Object> context) {
        RangerAccessResource ret = null;
        Object val = context.get(KEY_CONTEXT_RESOURCE);
        if (val != null && val instanceof RangerAccessResource) {
            ret = (RangerAccessResource)val;
        }
        return ret;
    }

    public static Map<String, Object> copyContext(Map<String, Object> context) {
        HashMap<String, Object> ret;
        if (MapUtils.isEmpty(context)) {
            ret = new HashMap();
        } else {
            ret = new HashMap<String, Object>(context);
            ret.remove(KEY_CONTEXT_TAGS);
            ret.remove(KEY_CONTEXT_TAG_OBJECT);
            ret.remove(KEY_CONTEXT_RESOURCE);
        }
        return ret;
    }

    public static void setCurrentUserInContext(Map<String, Object> context, String user) {
        RangerAccessRequestUtil.setTokenInContext(context, KEY_USER, user);
    }

    public static String getCurrentUserFromContext(Map<String, Object> context) {
        Object ret = RangerAccessRequestUtil.getTokenFromContext(context, KEY_USER);
        return ret != null ? ret.toString() : "";
    }

    public static void setTokenInContext(Map<String, Object> context, String tokenName, Object tokenValue) {
        String tokenNameWithNamespace = KEY_TOKEN_NAMESPACE + tokenName;
        context.put(tokenNameWithNamespace, tokenValue);
    }

    public static Object getTokenFromContext(Map<String, Object> context, String tokenName) {
        String tokenNameWithNamespace = KEY_TOKEN_NAMESPACE + tokenName;
        return MapUtils.isNotEmpty(context) ? context.get(tokenNameWithNamespace) : null;
    }
}

