/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;

public class StringTokenReplacer {
    private final char startChar;
    private final char endChar;
    private final char escapeChar;
    private final String tokenPrefix;

    public StringTokenReplacer(char startChar, char endChar, char escapeChar, String tokenPrefix) {
        this.startChar = startChar;
        this.endChar = endChar;
        this.escapeChar = escapeChar;
        this.tokenPrefix = tokenPrefix;
    }

    public String replaceTokens(String value, Map<String, Object> tokens) {
        if (tokens == null || tokens.size() < 1 || value == null || value.length() < 1 || value.indexOf(this.startChar) == -1 && value.indexOf(this.endChar) == -1 && value.indexOf(this.escapeChar) == -1) {
            return value;
        }
        StringBuilder ret = new StringBuilder();
        StringBuilder token = null;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == this.escapeChar) {
                if (++i >= value.length()) continue;
                c = value.charAt(i);
                if (token != null) {
                    token.append(c);
                    continue;
                }
                ret.append(c);
                continue;
            }
            if (token == null) {
                if (c == this.startChar) {
                    token = new StringBuilder();
                    continue;
                }
                ret.append(c);
                continue;
            }
            if (c == this.endChar) {
                String rawToken = token.toString();
                if (this.tokenPrefix.length() == 0 || rawToken.startsWith(this.tokenPrefix)) {
                    Object replaced = RangerAccessRequestUtil.getTokenFromContext(tokens, rawToken.substring(this.tokenPrefix.length()));
                    if (replaced != null) {
                        ret.append(replaced.toString());
                    }
                } else {
                    ret.append(this.startChar).append((CharSequence)token).append(this.endChar);
                }
                token = null;
                continue;
            }
            token.append(c);
        }
        if (token != null) {
            ret.append(this.startChar).append((CharSequence)token);
        }
        return ret.toString();
    }

    public static void main(String[] args) {
        char startChar = '%';
        char endChar = '%';
        char escapeChar = '\\';
        String tokenPrefix = "ranger:";
        HashMap<String, Object> tokens = new HashMap<String, Object>();
        tokens.put("USER", "testUser");
        tokens.put("COUNTRY", "USA");
        tokens.put("STATE", "CA");
        tokens.put("CITY", "Santa Clara");
        StringTokenReplacer tokenReplacer = new StringTokenReplacer(startChar, endChar, escapeChar, tokenPrefix);
        if (args.length == 0) {
            args = new String[]{"/home/%USER%/*", "/home/%ranger:USER%/*", "tmp_%USER%", "tmp_%ranger:USER%", "%USER%_db", "%ranger:USER%_db", "\\%USER_db", "\\%ranger:USER_db", "\\%USER%_db", "\\%ranger:USER%_db"};
        }
        for (String str : args) {
            System.out.println(str + " ==> " + tokenReplacer.replaceTokens(str, tokens));
        }
    }
}

