/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.conditionevaluator;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.contextenricher.RangerTagForEval;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;

public final class RangerScriptExecutionContext {
    private static final Log LOG = LogFactory.getLog(RangerScriptExecutionContext.class);
    public static final String DATETIME_FORMAT_PATTERN = "yyyy/MM/dd";
    private final RangerAccessRequest accessRequest;
    private Boolean result = false;

    RangerScriptExecutionContext(RangerAccessRequest accessRequest) {
        this.accessRequest = accessRequest;
    }

    public String getResource() {
        String ret = null;
        Object val = this.getRequestContext().get("RESOURCE");
        if (val != null) {
            ret = val instanceof RangerAccessResource ? ((RangerAccessResource)val).getAsString() : val.toString();
        }
        return ret;
    }

    public Map<String, Object> getRequestContext() {
        return this.accessRequest.getContext();
    }

    public String getRequestContextAttribute(String attributeName) {
        Object val;
        String ret = null;
        if (StringUtils.isNotBlank((String)attributeName) && (val = this.getRequestContext().get(attributeName)) != null) {
            ret = val.toString();
        }
        return ret;
    }

    public boolean isAccessTypeAny() {
        return this.accessRequest.isAccessTypeAny();
    }

    public boolean isAccessTypeDelegatedAdmin() {
        return this.accessRequest.isAccessTypeDelegatedAdmin();
    }

    public String getUser() {
        return this.accessRequest.getUser();
    }

    public Set<String> getUserGroups() {
        return this.accessRequest.getUserGroups();
    }

    public Date getAccessTime() {
        return this.accessRequest.getAccessTime();
    }

    public String getClientIPAddress() {
        return this.accessRequest.getClientIPAddress();
    }

    public String getClientType() {
        return this.accessRequest.getClientType();
    }

    public String getAction() {
        return this.accessRequest.getAction();
    }

    public String getRequestData() {
        return this.accessRequest.getRequestData();
    }

    public String getSessionId() {
        return this.accessRequest.getSessionId();
    }

    public RangerTagForEval getCurrentTag() {
        RangerTagForEval ret = null;
        Object val = this.getRequestContext().get("TAG_OBJECT");
        if (val != null && val instanceof RangerTagForEval) {
            ret = (RangerTagForEval)val;
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getCurrentTag() - No current TAG object. Script execution must be for resource-based policy.");
        }
        return ret;
    }

    public String getCurrentTagType() {
        RangerTagForEval tagObject = this.getCurrentTag();
        return tagObject != null ? tagObject.getType() : null;
    }

    public Set<String> getAllTagTypes() {
        HashSet<String> allTagTypes = null;
        Set<RangerTagForEval> tagObjectList = this.getAllTags();
        if (CollectionUtils.isNotEmpty(tagObjectList)) {
            for (RangerTagForEval tag : tagObjectList) {
                String tagType = tag.getType();
                if (allTagTypes == null) {
                    allTagTypes = new HashSet<String>();
                }
                allTagTypes.add(tagType);
            }
        }
        return allTagTypes;
    }

    public Map<String, String> getTagAttributes(String tagType) {
        Set<RangerTagForEval> tagObjectList;
        Map<String, String> ret = null;
        if (StringUtils.isNotBlank((String)tagType) && CollectionUtils.isNotEmpty(tagObjectList = this.getAllTags())) {
            for (RangerTagForEval tag : tagObjectList) {
                if (!tag.getType().equals(tagType)) continue;
                ret = tag.getAttributes();
                break;
            }
        }
        return ret;
    }

    public Set<String> getAttributeNames(String tagType) {
        Set<String> ret = null;
        Map<String, String> attributes = this.getTagAttributes(tagType);
        if (attributes != null) {
            ret = attributes.keySet();
        }
        return ret;
    }

    public String getAttributeValue(String tagType, String attributeName) {
        Map<String, String> attributes;
        String ret = null;
        if ((StringUtils.isNotBlank((String)tagType) || StringUtils.isNotBlank((String)attributeName)) && (attributes = this.getTagAttributes(tagType)) != null) {
            ret = attributes.get(attributeName);
        }
        return ret;
    }

    public String getAttributeValue(String attributeName) {
        String ret = null;
        if (StringUtils.isNotBlank((String)attributeName)) {
            RangerTagForEval tag = this.getCurrentTag();
            Map<String, String> attributes = null;
            if (tag != null) {
                attributes = tag.getAttributes();
            }
            if (attributes != null) {
                ret = attributes.get(attributeName);
            }
        }
        return ret;
    }

    public boolean getResult() {
        return this.result;
    }

    public void setResult(boolean result) {
        this.result = result;
    }

    public Date getAsDate(String value) {
        Date ret = null;
        if (StringUtils.isNotBlank((String)value)) {
            SimpleDateFormat df = new SimpleDateFormat(DATETIME_FORMAT_PATTERN);
            try {
                Date expiryDate = df.parse(value);
                if (expiryDate == null) {
                    LOG.error((Object)("Could not parse provided expiry_date into a valid date, expiry_date=" + value + ", Format-String=" + DATETIME_FORMAT_PATTERN));
                } else {
                    ret = StringUtil.getUTCDateForLocalDate(expiryDate);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)("RangerScriptExecutionContext.getAsDate() - Could not convert " + value + " to Date, exception=" + ex));
            }
        }
        return ret;
    }

    public Date getTagAttributeAsDate(String tagType, String attributeName) {
        String attrValue = this.getAttributeValue(tagType, attributeName);
        return this.getAsDate(attrValue);
    }

    public boolean isAccessedAfter(String tagType, String attributeName) {
        boolean ret = false;
        Date accessDate = this.getAccessTime();
        Date expiryDate = this.getTagAttributeAsDate(tagType, attributeName);
        if (expiryDate == null || accessDate.after(expiryDate) || accessDate.equals(expiryDate)) {
            ret = true;
        }
        return ret;
    }

    public boolean isAccessedAfter(String attributeName) {
        boolean ret = false;
        Date accessDate = this.getAccessTime();
        Date expiryDate = this.getAsDate(this.getAttributeValue(attributeName));
        if (expiryDate == null || accessDate.after(expiryDate) || accessDate.equals(expiryDate)) {
            ret = true;
        }
        return ret;
    }

    public boolean isAccessedBefore(String tagType, String attributeName) {
        boolean ret = true;
        Date accessDate = this.getAccessTime();
        Date expiryDate = this.getTagAttributeAsDate(tagType, attributeName);
        if (expiryDate == null || accessDate.after(expiryDate)) {
            ret = false;
        }
        return ret;
    }

    public boolean isAccessedBefore(String attributeName) {
        boolean ret = true;
        Date accessDate = this.getAccessTime();
        Date expiryDate = this.getAsDate(this.getAttributeValue(attributeName));
        if (expiryDate == null || accessDate.after(expiryDate)) {
            ret = false;
        }
        return ret;
    }

    private Set<RangerTagForEval> getAllTags() {
        Set<RangerTagForEval> ret = RangerAccessRequestUtil.getRequestTagsFromContext(this.accessRequest.getContext());
        if (ret == null && LOG.isDebugEnabled()) {
            String resource = this.accessRequest.getResource().getAsString();
            LOG.debug((Object)("getAllTags() - No TAGS. No TAGS for the RangerAccessResource=" + resource));
        }
        return ret;
    }

    public void logDebug(String msg) {
        LOG.debug((Object)msg);
    }

    public void logInfo(String msg) {
        LOG.info((Object)msg);
    }

    public void logWarn(String msg) {
        LOG.warn((Object)msg);
    }

    public void logError(String msg) {
        LOG.error((Object)msg);
    }

    public void logFatal(String msg) {
        LOG.fatal((Object)msg);
    }
}

