/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.contextenricher;

import java.util.Map;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.RangerServiceResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceEvaluator;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.RangerResourceMatcher;
import org.apache.ranger.plugin.util.ServiceDefUtil;

public class RangerServiceResourceMatcher
implements RangerPolicyResourceEvaluator {
    private final RangerServiceResource serviceResource;
    private final RangerPolicyResourceMatcher policyResourceMatcher;
    private final Integer leafResourceLevel;

    public RangerServiceResourceMatcher(RangerServiceResource serviceResource, RangerPolicyResourceMatcher policyResourceMatcher) {
        this.serviceResource = serviceResource;
        this.policyResourceMatcher = policyResourceMatcher;
        this.leafResourceLevel = ServiceDefUtil.getLeafResourceLevel(this.getServiceDef(), this.getPolicyResource());
    }

    public RangerServiceResource getServiceResource() {
        return this.serviceResource;
    }

    @Override
    public long getId() {
        return this.serviceResource != null ? this.serviceResource.getId() : -1L;
    }

    @Override
    public RangerPolicyResourceMatcher getPolicyResourceMatcher() {
        return this.policyResourceMatcher;
    }

    @Override
    public Map<String, RangerPolicy.RangerPolicyResource> getPolicyResource() {
        return this.serviceResource != null ? this.serviceResource.getResourceElements() : null;
    }

    @Override
    public RangerResourceMatcher getResourceMatcher(String resourceName) {
        return this.policyResourceMatcher != null ? this.policyResourceMatcher.getResourceMatcher(resourceName) : null;
    }

    @Override
    public Integer getLeafResourceLevel() {
        return this.leafResourceLevel;
    }

    @Override
    public int compareTo(RangerPolicyResourceEvaluator other) {
        return Long.compare(this.getId(), other.getId());
    }

    public RangerPolicyResourceMatcher.MatchType getMatchType(RangerAccessResource requestedResource, Map<String, Object> evalContext) {
        return this.policyResourceMatcher != null ? this.policyResourceMatcher.getMatchType(requestedResource, evalContext) : RangerPolicyResourceMatcher.MatchType.NONE;
    }

    RangerServiceDef getServiceDef() {
        return this.policyResourceMatcher != null ? this.policyResourceMatcher.getServiceDef() : null;
    }
}

