/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RangerPluginInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int ENTITY_TYPE_POLICIES = 0;
    public static final int ENTITY_TYPE_TAGS = 1;
    public static final String PLUGIN_INFO_POLICY_DOWNLOAD_TIME = "policyDownloadTime";
    public static final String PLUGIN_INFO_POLICY_DOWNLOADED_VERSION = "policyDownloadedVersion";
    public static final String PLUGIN_INFO_POLICY_ACTIVATION_TIME = "policyActivationTime";
    public static final String PLUGIN_INFO_POLICY_ACTIVE_VERSION = "policyActiveVersion";
    public static final String PLUGIN_INFO_TAG_DOWNLOAD_TIME = "tagDownloadTime";
    public static final String PLUGIN_INFO_TAG_DOWNLOADED_VERSION = "tagDownloadedVersion";
    public static final String PLUGIN_INFO_TAG_ACTIVATION_TIME = "tagActivationTime";
    public static final String PLUGIN_INFO_TAG_ACTIVE_VERSION = "tagActiveVersion";
    public static final String RANGER_ADMIN_LAST_POLICY_UPDATE_TIME = "lastPolicyUpdateTime";
    public static final String RANGER_ADMIN_LATEST_POLICY_VERSION = "latestPolicyVersion";
    public static final String RANGER_ADMIN_LAST_TAG_UPDATE_TIME = "lastTagUpdateTime";
    public static final String RANGER_ADMIN_LATEST_TAG_VERSION = "latestTagVersion";
    private Long id = null;
    private Date createTime = null;
    private Date updateTime = null;
    private String serviceName;
    private String hostName;
    private String appType;
    private String ipAddress;
    private Map<String, String> info;

    public RangerPluginInfo(Long id, Date createTime, Date updateTime, String serviceName, String appType, String hostName, String ipAddress, Map<String, String> info) {
        this.setId(id);
        this.setCreateTime(createTime);
        this.setUpdateTime(updateTime);
        this.setServiceName(serviceName);
        this.setAppType(appType);
        this.setHostName(hostName);
        this.setIpAddress(ipAddress);
        this.setInfo(info);
    }

    public RangerPluginInfo() {
        this(null, null, null, null, null, null, null, null);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getAppType() {
        return this.appType;
    }

    public void setAppType(String appType) {
        this.appType = appType;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public Map<String, String> getInfo() {
        return this.info;
    }

    public void setInfo(Map<String, String> info) {
        this.info = info == null ? new HashMap() : info;
    }

    @JsonIgnore
    public void setPolicyDownloadTime(Long policyDownloadTime) {
        this.getInfo().put(PLUGIN_INFO_POLICY_DOWNLOAD_TIME, policyDownloadTime == null ? null : Long.toString(policyDownloadTime));
    }

    @JsonIgnore
    public Long getPolicyDownloadTime() {
        String downloadTimeString = this.getInfo().get(PLUGIN_INFO_POLICY_DOWNLOAD_TIME);
        return StringUtils.isNotBlank((String)downloadTimeString) ? Long.valueOf(downloadTimeString) : null;
    }

    @JsonIgnore
    public void setPolicyDownloadedVersion(Long policyDownloadedVersion) {
        this.getInfo().put(PLUGIN_INFO_POLICY_DOWNLOADED_VERSION, policyDownloadedVersion == null ? null : Long.toString(policyDownloadedVersion));
    }

    @JsonIgnore
    public Long getPolicyDownloadedVersion() {
        String downloadedVersionString = this.getInfo().get(PLUGIN_INFO_POLICY_DOWNLOADED_VERSION);
        return StringUtils.isNotBlank((String)downloadedVersionString) ? Long.valueOf(downloadedVersionString) : null;
    }

    @JsonIgnore
    public void setPolicyActivationTime(Long policyActivationTime) {
        this.getInfo().put(PLUGIN_INFO_POLICY_ACTIVATION_TIME, policyActivationTime == null ? null : Long.toString(policyActivationTime));
    }

    @JsonIgnore
    public Long getPolicyActivationTime() {
        String activationTimeString = this.getInfo().get(PLUGIN_INFO_POLICY_ACTIVATION_TIME);
        return StringUtils.isNotBlank((String)activationTimeString) ? Long.valueOf(activationTimeString) : null;
    }

    @JsonIgnore
    public void setPolicyActiveVersion(Long policyActiveVersion) {
        this.getInfo().put(PLUGIN_INFO_POLICY_ACTIVE_VERSION, policyActiveVersion == null ? null : Long.toString(policyActiveVersion));
    }

    @JsonIgnore
    public Long getPolicyActiveVersion() {
        String activeVersionString = this.getInfo().get(PLUGIN_INFO_POLICY_ACTIVE_VERSION);
        return StringUtils.isNotBlank((String)activeVersionString) ? Long.valueOf(activeVersionString) : null;
    }

    @JsonIgnore
    public void setTagDownloadTime(Long tagDownloadTime) {
        this.getInfo().put(PLUGIN_INFO_TAG_DOWNLOAD_TIME, tagDownloadTime == null ? null : Long.toString(tagDownloadTime));
    }

    @JsonIgnore
    public Long getTagDownloadTime() {
        String downloadTimeString = this.getInfo().get(PLUGIN_INFO_TAG_DOWNLOAD_TIME);
        return StringUtils.isNotBlank((String)downloadTimeString) ? Long.valueOf(downloadTimeString) : null;
    }

    @JsonIgnore
    public void setTagDownloadedVersion(Long tagDownloadedVersion) {
        this.getInfo().put(PLUGIN_INFO_TAG_DOWNLOADED_VERSION, tagDownloadedVersion == null ? null : Long.toString(tagDownloadedVersion));
    }

    @JsonIgnore
    public Long getTagDownloadedVersion() {
        String downloadedVersion = this.getInfo().get(PLUGIN_INFO_TAG_DOWNLOADED_VERSION);
        return StringUtils.isNotBlank((String)downloadedVersion) ? Long.valueOf(downloadedVersion) : null;
    }

    @JsonIgnore
    public void setTagActivationTime(Long tagActivationTime) {
        this.getInfo().put(PLUGIN_INFO_TAG_ACTIVATION_TIME, tagActivationTime == null ? null : Long.toString(tagActivationTime));
    }

    @JsonIgnore
    public Long getTagActivationTime() {
        String activationTimeString = this.getInfo().get(PLUGIN_INFO_TAG_ACTIVATION_TIME);
        return StringUtils.isNotBlank((String)activationTimeString) ? Long.valueOf(activationTimeString) : null;
    }

    @JsonIgnore
    public void setTagActiveVersion(Long tagActiveVersion) {
        this.getInfo().put(PLUGIN_INFO_TAG_ACTIVE_VERSION, tagActiveVersion == null ? null : Long.toString(tagActiveVersion));
    }

    @JsonIgnore
    public Long getTagActiveVersion() {
        String activeVersionString = this.getInfo().get(PLUGIN_INFO_TAG_ACTIVE_VERSION);
        return StringUtils.isNotBlank((String)activeVersionString) ? Long.valueOf(activeVersionString) : null;
    }

    @JsonIgnore
    public Long getLatestPolicyVersion() {
        String latestPolicyVersionString = this.getInfo().get(RANGER_ADMIN_LATEST_POLICY_VERSION);
        return StringUtils.isNotBlank((String)latestPolicyVersionString) ? Long.valueOf(latestPolicyVersionString) : null;
    }

    @JsonIgnore
    public Long getLastPolicyUpdateTime() {
        String updateTimeString = this.getInfo().get(RANGER_ADMIN_LAST_POLICY_UPDATE_TIME);
        return StringUtils.isNotBlank((String)updateTimeString) ? Long.valueOf(updateTimeString) : null;
    }

    @JsonIgnore
    public Long getLatestTagVersion() {
        String latestTagVersionString = this.getInfo().get(RANGER_ADMIN_LATEST_TAG_VERSION);
        return StringUtils.isNotBlank((String)latestTagVersionString) ? Long.valueOf(latestTagVersionString) : null;
    }

    @JsonIgnore
    public Long getLastTagUpdateTime() {
        String updateTimeString = this.getInfo().get(RANGER_ADMIN_LAST_TAG_UPDATE_TIME);
        return StringUtils.isNotBlank((String)updateTimeString) ? Long.valueOf(updateTimeString) : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerPluginInfo={");
        sb.append("id={").append(this.id).append("} ");
        sb.append("createTime={").append(this.createTime).append("} ");
        sb.append("updateTime={").append(this.updateTime).append("} ");
        sb.append("serviceName={").append(this.serviceName).append("} ");
        sb.append("hostName={").append(this.hostName).append("} ");
        sb.append("appType={").append(this.appType).append("} ");
        sb.append("ipAddress={").append(this.ipAddress).append("} ");
        sb.append("info={").append(this.info).append("} ");
        sb.append(" }");
        return sb;
    }
}

