/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.apache.ranger.plugin.contextenricher.RangerContextEnricher;
import org.apache.ranger.plugin.contextenricher.RangerTagForEval;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.policyengine.RangerDataMaskResult;
import org.apache.ranger.plugin.policyengine.RangerMutableResource;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngine;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.policyengine.RangerPolicyRepository;
import org.apache.ranger.plugin.policyengine.RangerResourceAccessInfo;
import org.apache.ranger.plugin.policyengine.RangerRowFilterResult;
import org.apache.ranger.plugin.policyengine.RangerTagAccessRequest;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.ServicePolicies;

public class RangerPolicyEngineImpl
implements RangerPolicyEngine {
    private static final Log LOG = LogFactory.getLog(RangerPolicyEngineImpl.class);
    private static final Log PERF_POLICYENGINE_INIT_LOG = RangerPerfTracer.getPerfLogger("policyengine.init");
    private static final Log PERF_POLICYENGINE_REQUEST_LOG = RangerPerfTracer.getPerfLogger("policyengine.request");
    private static final Log PERF_POLICYENGINE_AUDIT_LOG = RangerPerfTracer.getPerfLogger("policyengine.audit");
    private static final Log PERF_CONTEXTENRICHER_REQUEST_LOG = RangerPerfTracer.getPerfLogger("contextenricher.request");
    private static final Log PERF_POLICYENGINE_REBALANCE_LOG = RangerPerfTracer.getPerfLogger("policyengine.rebalance");
    private static final Log PERF_POLICYENGINE_USAGE_LOG = RangerPerfTracer.getPerfLogger("policyengine.usage");
    private static final int MAX_POLICIES_FOR_CACHE_TYPE_EVALUATOR = 100;
    private final RangerPolicyRepository policyRepository;
    private final RangerPolicyRepository tagPolicyRepository;
    private List<RangerContextEnricher> allContextEnrichers;
    private final Map<Long, RangerPolicyEvaluator> policyEvaluatorsMap;
    private boolean useForwardedIPAddress = false;
    private String[] trustedProxyAddresses = null;

    public RangerPolicyEngineImpl(String appId, ServicePolicies servicePolicies, RangerPolicyEngineOptions options) {
        List<RangerContextEnricher> tmpList;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl(" + appId + ", " + servicePolicies + ", " + options + ")"));
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "RangerPolicyEngine.init(appId=" + appId + ",hashCode=" + Integer.toHexString(System.identityHashCode(this)) + ")");
            long freeMemory = Runtime.getRuntime().freeMemory();
            long totalMemory = Runtime.getRuntime().totalMemory();
            PERF_POLICYENGINE_INIT_LOG.debug((Object)("In-Use memory: " + (totalMemory - freeMemory) + ", Free memory:" + freeMemory));
        }
        if (options == null) {
            options = new RangerPolicyEngineOptions();
        }
        if (StringUtils.isBlank((String)options.evaluatorType) || StringUtils.equalsIgnoreCase((String)options.evaluatorType, (String)"auto")) {
            String serviceType = servicePolicies.getServiceDef().getName();
            String propertyName = "ranger.plugin." + serviceType + ".policyengine.evaluator.auto.maximum.policycount.for.cache.type";
            int thresholdForUsingOptimizedEvaluator = RangerConfiguration.getInstance().getInt(propertyName, 100);
            int servicePoliciesCount = servicePolicies.getPolicies().size() + (servicePolicies.getTagPolicies() != null ? servicePolicies.getTagPolicies().getPolicies().size() : 0);
            options.evaluatorType = servicePoliciesCount > thresholdForUsingOptimizedEvaluator ? "optimized" : "cached";
        } else {
            options.evaluatorType = StringUtils.equalsIgnoreCase((String)options.evaluatorType, (String)"cached") ? "cached" : "optimized";
        }
        this.policyRepository = new RangerPolicyRepository(appId, servicePolicies, options);
        ServicePolicies.TagPolicies tagPolicies = servicePolicies.getTagPolicies();
        if (!(options.disableTagPolicyEvaluation || tagPolicies == null || StringUtils.isEmpty((String)tagPolicies.getServiceName()) || tagPolicies.getServiceDef() == null || CollectionUtils.isEmpty(tagPolicies.getPolicies()))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("RangerPolicyEngineImpl : Building tag-policy-repository for tag-service " + tagPolicies.getServiceName()));
            }
            this.tagPolicyRepository = new RangerPolicyRepository(appId, tagPolicies, options, servicePolicies.getServiceDef(), servicePolicies.getServiceName());
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("RangerPolicyEngineImpl : No tag-policy-repository for service " + servicePolicies.getServiceName()));
            }
            this.tagPolicyRepository = null;
        }
        List<RangerContextEnricher> tagContextEnrichers = this.tagPolicyRepository == null ? null : this.tagPolicyRepository.getContextEnrichers();
        List<RangerContextEnricher> resourceContextEnrichers = this.policyRepository.getContextEnrichers();
        if (CollectionUtils.isEmpty(tagContextEnrichers)) {
            tmpList = resourceContextEnrichers;
        } else if (CollectionUtils.isEmpty(resourceContextEnrichers)) {
            tmpList = tagContextEnrichers;
        } else {
            tmpList = new ArrayList<RangerContextEnricher>(tagContextEnrichers);
            tmpList.addAll(resourceContextEnrichers);
        }
        this.allContextEnrichers = tmpList;
        this.policyEvaluatorsMap = this.createPolicyEvaluatorsMap();
        RangerPerfTracer.log(perf);
        if (PERF_POLICYENGINE_INIT_LOG.isDebugEnabled()) {
            long freeMemory = Runtime.getRuntime().freeMemory();
            long totalMemory = Runtime.getRuntime().totalMemory();
            PERF_POLICYENGINE_INIT_LOG.debug((Object)("In-Use memory: " + (totalMemory - freeMemory) + ", Free memory:" + freeMemory));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerPolicyEngineImpl()");
        }
    }

    @Override
    public String getServiceName() {
        return this.policyRepository.getServiceName();
    }

    @Override
    public RangerServiceDef getServiceDef() {
        return this.policyRepository.getServiceDef();
    }

    @Override
    public long getPolicyVersion() {
        return this.policyRepository.getPolicyVersion();
    }

    public RangerPolicyEvaluator getPolicyEvaluator(Long id) {
        return this.policyEvaluatorsMap.get(id);
    }

    public RangerPolicy getPolicy(Long id) {
        RangerPolicyEvaluator evaluator = this.getPolicyEvaluator(id);
        return evaluator != null ? evaluator.getPolicy() : null;
    }

    @Override
    public RangerAccessResult createAccessResult(RangerAccessRequest request) {
        RangerAccessResult ret = new RangerAccessResult(this.getServiceName(), this.policyRepository.getServiceDef(), request);
        switch (this.policyRepository.getAuditModeEnum()) {
            case AUDIT_ALL: {
                ret.setIsAudited(true);
                break;
            }
            case AUDIT_NONE: {
                ret.setIsAudited(false);
                break;
            }
        }
        return ret;
    }

    @Override
    public void preProcess(RangerAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.preProcess(" + request + ")"));
        }
        this.setResourceServiceDef(request);
        if (request instanceof RangerAccessRequestImpl) {
            ((RangerAccessRequestImpl)request).extractAndSetClientIPAddress(this.useForwardedIPAddress, this.trustedProxyAddresses);
        }
        RangerAccessRequestUtil.setCurrentUserInContext(request.getContext(), request.getUser());
        List<RangerContextEnricher> enrichers = this.allContextEnrichers;
        if (!CollectionUtils.isEmpty(enrichers)) {
            for (RangerContextEnricher enricher : enrichers) {
                RangerPerfTracer perf = null;
                if (RangerPerfTracer.isPerfTraceEnabled(PERF_CONTEXTENRICHER_REQUEST_LOG)) {
                    perf = RangerPerfTracer.getPerfTracer(PERF_CONTEXTENRICHER_REQUEST_LOG, "RangerContextEnricher.enrich(requestHashCode=" + Integer.toHexString(System.identityHashCode(request)) + ", enricherName=" + enricher.getName() + ")");
                }
                enricher.enrich(request);
                RangerPerfTracer.log(perf);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.preProcess(" + request + ")"));
        }
    }

    @Override
    public void preProcess(Collection<RangerAccessRequest> requests) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.preProcess(" + requests + ")"));
        }
        if (CollectionUtils.isNotEmpty(requests)) {
            for (RangerAccessRequest request : requests) {
                this.preProcess(request);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.preProcess(" + requests + ")"));
        }
    }

    @Override
    public RangerAccessResult isAccessAllowed(RangerAccessRequest request, RangerAccessResultProcessor resultProcessor) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.isAccessAllowed(" + request + ")"));
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_REQUEST_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_REQUEST_LOG, "RangerPolicyEngine.isAccessAllowed(requestHashCode=" + Integer.toHexString(System.identityHashCode(request)) + ")");
        }
        RangerAccessResult ret = this.isAccessAllowedNoAudit(request);
        this.updatePolicyUsageCounts(request, ret);
        if (resultProcessor != null) {
            RangerPerfTracer perfAuditTracer = null;
            if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_AUDIT_LOG)) {
                perfAuditTracer = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_AUDIT_LOG, "RangerPolicyEngine.processAudit(requestHashCode=" + Integer.toHexString(System.identityHashCode(request)) + ")");
            }
            resultProcessor.processResult(ret);
            RangerPerfTracer.log(perfAuditTracer);
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.isAccessAllowed(" + request + "): " + ret));
        }
        return ret;
    }

    @Override
    public Collection<RangerAccessResult> isAccessAllowed(Collection<RangerAccessRequest> requests, RangerAccessResultProcessor resultProcessor) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.isAccessAllowed(" + requests + ")"));
        }
        ArrayList<RangerAccessResult> ret = new ArrayList<RangerAccessResult>();
        if (requests != null) {
            for (RangerAccessRequest request : requests) {
                RangerAccessResult result = this.isAccessAllowedNoAudit(request);
                ret.add(result);
            }
        }
        if (resultProcessor != null) {
            resultProcessor.processResults(ret);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.isAccessAllowed(" + requests + "): " + ret));
        }
        return ret;
    }

    @Override
    public RangerDataMaskResult evalDataMaskPolicies(RangerAccessRequest request, RangerAccessResultProcessor resultProcessor) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.evalDataMaskPolicies(" + request + ")"));
        }
        RangerDataMaskResult ret = new RangerDataMaskResult(this.getServiceName(), this.getServiceDef(), request);
        if (request != null) {
            List<RangerPolicyEvaluator> evaluators = this.policyRepository.getDataMaskPolicyEvaluators(request.getResource());
            for (RangerPolicyEvaluator evaluator : evaluators) {
                evaluator.evaluate(request, ret);
                if (!ret.getIsAccessDetermined() || !ret.getIsAuditedDetermined()) continue;
                if (!StringUtils.equalsIgnoreCase((String)ret.getMaskType(), (String)"MASK_NONE")) break;
                ret.setMaskType(null);
                ret.setIsAccessDetermined(false);
            }
        }
        if (!ret.isMaskEnabled()) {
            ret.setIsAudited(false);
        }
        this.updatePolicyUsageCounts(request, ret);
        if (resultProcessor != null) {
            resultProcessor.processResult(ret);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.evalDataMaskPolicies(" + request + "): " + ret));
        }
        return ret;
    }

    @Override
    public RangerRowFilterResult evalRowFilterPolicies(RangerAccessRequest request, RangerAccessResultProcessor resultProcessor) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.evalRowFilterPolicies(" + request + ")"));
        }
        RangerRowFilterResult ret = new RangerRowFilterResult(this.getServiceName(), this.getServiceDef(), request);
        if (request != null) {
            List<RangerPolicyEvaluator> evaluators = this.policyRepository.getRowFilterPolicyEvaluators(request.getResource());
            for (RangerPolicyEvaluator evaluator : evaluators) {
                evaluator.evaluate(request, ret);
                if (!ret.getIsAccessDetermined() || !ret.getIsAuditedDetermined()) continue;
                if (StringUtils.isNotEmpty((String)ret.getFilterExpr())) break;
                ret.setIsAccessDetermined(false);
            }
        }
        if (!ret.isRowFilterEnabled()) {
            ret.setIsAudited(false);
        }
        this.updatePolicyUsageCounts(request, ret);
        if (resultProcessor != null) {
            resultProcessor.processResult(ret);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.evalRowFilterPolicies(" + request + "): " + ret));
        }
        return ret;
    }

    @Override
    public boolean isAccessAllowed(RangerAccessResource resource, String user, Set<String> userGroups, String accessType) {
        RangerPolicyEvaluator evaluator;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.isAccessAllowed(" + resource + ", " + user + ", " + userGroups + ", " + accessType + ")"));
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_REQUEST_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_REQUEST_LOG, "RangerPolicyEngine.isAccessAllowed(user=" + user + ",accessType=" + accessType + "resource=" + resource.getAsString() + ")");
        }
        boolean ret = false;
        Iterator<RangerPolicyEvaluator> iterator = this.policyRepository.getPolicyEvaluators(resource).iterator();
        while (iterator.hasNext() && !(ret = (evaluator = iterator.next()).isAccessAllowed(resource, user, userGroups, accessType))) {
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.isAccessAllowed(" + resource + ", " + user + ", " + userGroups + ", " + accessType + "): " + ret));
        }
        return ret;
    }

    @Override
    public boolean isAccessAllowed(Map<String, RangerPolicy.RangerPolicyResource> resources, String user, Set<String> userGroups, String accessType) {
        RangerPolicyEvaluator evaluator;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.isAccessAllowed(" + resources + ", " + user + ", " + userGroups + ", " + accessType + ")"));
        }
        boolean ret = false;
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_REQUEST_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_REQUEST_LOG, "RangerPolicyEngine.isAccessAllowed(user=" + user + "," + userGroups + ",accessType=" + accessType + ")");
        }
        Iterator<RangerPolicyEvaluator> iterator = this.policyRepository.getPolicyEvaluators().iterator();
        while (iterator.hasNext() && !(ret = (evaluator = iterator.next()).isAccessAllowed(resources, user, userGroups, accessType))) {
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.isAccessAllowed(" + resources + ", " + user + ", " + userGroups + ", " + accessType + "): " + ret));
        }
        return ret;
    }

    @Override
    public List<RangerPolicy> getExactMatchPolicies(RangerAccessResource resource, Map<String, Object> evalContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.getExactMatchPolicies(" + resource + ", " + evalContext + ")"));
        }
        ArrayList<RangerPolicy> ret = null;
        for (RangerPolicyEvaluator evaluator : this.policyRepository.getPolicyEvaluators()) {
            if (!evaluator.isCompleteMatch(resource, evalContext)) continue;
            if (ret == null) {
                ret = new ArrayList<RangerPolicy>();
            }
            ret.add(evaluator.getPolicy());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.getExactMatchPolicies(" + resource + ", " + evalContext + "): " + ret));
        }
        return ret;
    }

    @Override
    public List<RangerPolicy> getExactMatchPolicies(Map<String, RangerPolicy.RangerPolicyResource> resources, Map<String, Object> evalContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.getExactMatchPolicies(" + resources + ", " + evalContext + ")"));
        }
        ArrayList<RangerPolicy> ret = null;
        for (RangerPolicyEvaluator evaluator : this.policyRepository.getPolicyEvaluators()) {
            if (!evaluator.isCompleteMatch(resources, evalContext)) continue;
            if (ret == null) {
                ret = new ArrayList<RangerPolicy>();
            }
            ret.add(evaluator.getPolicy());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.getExactMatchPolicies(" + resources + ", " + evalContext + "): " + ret));
        }
        return ret;
    }

    @Override
    public List<RangerPolicy> getAllowedPolicies(String user, Set<String> userGroups, String accessType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.getAllowedPolicies(" + user + ", " + userGroups + ", " + accessType + ")"));
        }
        ArrayList<RangerPolicy> ret = new ArrayList<RangerPolicy>();
        for (RangerPolicyEvaluator evaluator : this.policyRepository.getPolicyEvaluators()) {
            RangerPolicy policy = evaluator.getPolicy();
            boolean isAccessAllowed = this.isAccessAllowed(policy.getResources(), user, userGroups, accessType);
            if (!isAccessAllowed) continue;
            ret.add(policy);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.getAllowedPolicies(" + user + ", " + userGroups + ", " + accessType + "): policyCount=" + ret.size()));
        }
        return ret;
    }

    @Override
    public RangerResourceAccessInfo getResourceAccessInfo(RangerAccessRequest request) {
        List<RangerPolicyEvaluator> resPolicyEvaluators;
        Set<RangerTagForEval> tags;
        List<RangerPolicyEvaluator> tagPolicyEvaluators;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.getResourceAccessInfo(" + request + ")"));
        }
        RangerResourceAccessInfo ret = new RangerResourceAccessInfo(request);
        List<RangerPolicyEvaluator> list = tagPolicyEvaluators = this.tagPolicyRepository == null ? null : this.tagPolicyRepository.getPolicyEvaluators();
        if (CollectionUtils.isNotEmpty(tagPolicyEvaluators) && CollectionUtils.isNotEmpty(tags = RangerAccessRequestUtil.getRequestTagsFromContext(request.getContext()))) {
            for (RangerTagForEval tag : tags) {
                RangerTagAccessRequest tagEvalRequest = new RangerTagAccessRequest(tag, this.tagPolicyRepository.getServiceDef(), request);
                List<RangerPolicyEvaluator> evaluators = this.tagPolicyRepository.getPolicyEvaluators(tagEvalRequest.getResource());
                for (RangerPolicyEvaluator evaluator : evaluators) {
                    evaluator.getResourceAccessInfo(tagEvalRequest, ret);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(resPolicyEvaluators = this.policyRepository.getPolicyEvaluators(request.getResource()))) {
            for (RangerPolicyEvaluator evaluator : resPolicyEvaluators) {
                evaluator.getResourceAccessInfo(request, ret);
            }
        }
        ret.getAllowedUsers().removeAll(ret.getDeniedUsers());
        ret.getAllowedGroups().removeAll(ret.getDeniedGroups());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.getResourceAccessInfo(" + request + "): " + ret));
        }
        return ret;
    }

    protected RangerAccessResult isAccessAllowedNoAudit(RangerAccessRequest request) {
        RangerAccessResult ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.isAccessAllowedNoAudit(" + request + ")"));
        }
        if ((ret = this.createAccessResult(request)) != null && request != null) {
            boolean evaluateResourcePolicies;
            if (this.hasTagPolicies()) {
                this.isAccessAllowedForTagPolicies(request, ret);
                if (LOG.isDebugEnabled() && ret.getIsAccessDetermined() && ret.getIsAuditedDetermined()) {
                    LOG.debug((Object)("RangerPolicyEngineImpl.isAccessAllowedNoAudit() - access and audit determined by tag policy. No resource policies will be evaluated, request=" + request + ", result=" + ret));
                }
            }
            boolean isAllowedByTags = ret.getIsAccessDetermined() && ret.getIsAllowed();
            boolean isDeniedByTags = ret.getIsAccessDetermined() && !ret.getIsAllowed();
            boolean bl = evaluateResourcePolicies = this.hasResourcePolicies() && (!isDeniedByTags || !ret.getIsAuditedDetermined());
            if (evaluateResourcePolicies) {
                boolean foundInCache;
                boolean findAuditByResource = !ret.getIsAuditedDetermined();
                boolean bl2 = foundInCache = findAuditByResource ? this.policyRepository.setAuditEnabledFromCache(request, ret) : false;
                if (isAllowedByTags) {
                    ret.setIsAccessDetermined(false);
                }
                List<RangerPolicyEvaluator> evaluators = this.policyRepository.getPolicyEvaluators(request.getResource());
                for (RangerPolicyEvaluator evaluator : evaluators) {
                    ret.incrementEvaluatedPoliciesCount();
                    evaluator.evaluate(request, ret);
                    if (ret.getIsAllowed() && !evaluator.hasDeny()) {
                        ret.setIsAccessDetermined(true);
                    }
                    if (!ret.getIsAuditedDetermined() || !ret.getIsAccessDetermined()) continue;
                    break;
                }
                if (ret.getIsAllowed()) {
                    ret.setIsAccessDetermined(true);
                }
                if (findAuditByResource && !foundInCache) {
                    this.policyRepository.storeAuditEnabledInCache(request, ret);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.isAccessAllowedNoAudit(" + request + "): " + ret));
        }
        return ret;
    }

    protected void isAccessAllowedForTagPolicies(RangerAccessRequest request, RangerAccessResult result) {
        Set<RangerTagForEval> tags;
        List<RangerPolicyEvaluator> tagEvaluators;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.isAccessAllowedForTagPolicies(" + request + ", " + result + ")"));
        }
        List<RangerPolicyEvaluator> list = tagEvaluators = this.tagPolicyRepository == null ? null : this.tagPolicyRepository.getPolicyEvaluators();
        if (CollectionUtils.isNotEmpty(tagEvaluators) && CollectionUtils.isNotEmpty(tags = RangerAccessRequestUtil.getRequestTagsFromContext(request.getContext()))) {
            for (RangerTagForEval tag : tags) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("RangerPolicyEngineImpl.isAccessAllowedForTagPolicies: Evaluating policies for tag (" + tag.getType() + ")"));
                }
                RangerTagAccessRequest tagEvalRequest = new RangerTagAccessRequest(tag, this.tagPolicyRepository.getServiceDef(), request);
                RangerAccessResult tagEvalResult = this.createAccessResult(tagEvalRequest);
                if (result.getIsAllowed()) {
                    tagEvalResult.setIsAllowed(result.getIsAllowed());
                }
                tagEvalResult.setAuditResultFrom(result);
                List<RangerPolicyEvaluator> evaluators = this.tagPolicyRepository.getPolicyEvaluators(tagEvalRequest.getResource());
                for (RangerPolicyEvaluator evaluator : evaluators) {
                    tagEvalResult.incrementEvaluatedPoliciesCount();
                    evaluator.evaluate((RangerAccessRequest)tagEvalRequest, tagEvalResult);
                    if (tagEvalResult.getIsAllowed() && !evaluator.hasDeny()) {
                        tagEvalResult.setIsAccessDetermined(true);
                    }
                    if (!tagEvalResult.getIsAuditedDetermined() || !tagEvalResult.getIsAccessDetermined()) continue;
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug((Object)("RangerPolicyEngineImpl.isAccessAllowedForTagPolicies: concluding eval of tag (" + tag.getType() + ") with authorization=" + tagEvalResult.getIsAllowed()));
                    break;
                }
                if (tagEvalResult.getIsAllowed()) {
                    tagEvalResult.setIsAccessDetermined(true);
                }
                if (tagEvalResult.getIsAudited()) {
                    result.setIsAudited(true);
                    result.setAuditPolicyId(tagEvalResult.getAuditPolicyId());
                }
                if (!result.getIsAccessDetermined() && tagEvalResult.getIsAccessDetermined()) {
                    if (!tagEvalResult.getIsAllowed()) {
                        result.setAccessResultFrom(tagEvalResult);
                    } else if (!result.getIsAllowed()) {
                        result.setAccessResultFrom(tagEvalResult);
                        result.setIsAccessDetermined(false);
                    }
                }
                if (!result.getIsAuditedDetermined() || !result.getIsAccessDetermined()) continue;
                break;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.isAccessAllowedForTagPolicies(" + request + ", " + result + ")"));
        }
    }

    @Override
    public void reorderPolicyEvaluators() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> reorderEvaluators()");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_REBALANCE_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_REBALANCE_LOG, "RangerPolicyEngine.reorderEvaluators()");
        }
        if (MapUtils.isNotEmpty(this.policyEvaluatorsMap)) {
            for (Map.Entry<Long, RangerPolicyEvaluator> entry : this.policyEvaluatorsMap.entrySet()) {
                entry.getValue().setUsageCountImmutable();
            }
        }
        if (this.tagPolicyRepository != null) {
            this.tagPolicyRepository.reorderPolicyEvaluators();
        }
        if (this.policyRepository != null) {
            this.policyRepository.reorderPolicyEvaluators();
        }
        if (MapUtils.isNotEmpty(this.policyEvaluatorsMap)) {
            for (Map.Entry<Long, RangerPolicyEvaluator> entry : this.policyEvaluatorsMap.entrySet()) {
                entry.getValue().resetUsageCount();
            }
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== reorderEvaluators()");
        }
    }

    @Override
    public boolean preCleanup() {
        boolean ret = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerPolicyEngineImpl.preCleanup()");
        }
        if (CollectionUtils.isNotEmpty(this.allContextEnrichers)) {
            for (RangerContextEnricher contextEnricher : this.allContextEnrichers) {
                boolean notReadyForCleanup = contextEnricher.preCleanup();
                if (notReadyForCleanup) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("contextEnricher.preCleanup() failed for contextEnricher=" + contextEnricher.getName()));
                }
                ret = false;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.preCleanup() : result=" + ret));
        }
        return ret;
    }

    @Override
    public void cleanup() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerPolicyEngineImpl.cleanup()");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "RangerPolicyEngine.cleanUp(hashCode=" + Integer.toHexString(System.identityHashCode(this)) + ")");
        }
        this.preCleanup();
        if (CollectionUtils.isNotEmpty(this.allContextEnrichers)) {
            for (RangerContextEnricher contextEnricher : this.allContextEnrichers) {
                contextEnricher.cleanup();
            }
        }
        this.allContextEnrichers = null;
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerPolicyEngineImpl.cleanup()");
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.cleanup();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void setUseForwardedIPAddress(boolean useForwardedIPAddress) {
        this.useForwardedIPAddress = useForwardedIPAddress;
    }

    @Override
    public void setTrustedProxyAddresses(String[] trustedProxyAddresses) {
        this.trustedProxyAddresses = trustedProxyAddresses;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerPolicyEngineImpl={");
        sb.append("serviceName={").append(this.getServiceName()).append("} ");
        sb.append(this.policyRepository);
        sb.append("}");
        return sb;
    }

    private void setResourceServiceDef(RangerAccessRequest request) {
        RangerAccessResource resource = request.getResource();
        if (resource.getServiceDef() == null) {
            if (resource instanceof RangerMutableResource) {
                RangerMutableResource mutable = (RangerMutableResource)resource;
                mutable.setServiceDef(this.getServiceDef());
            } else {
                LOG.debug((Object)"RangerPolicyEngineImpl.setResourceServiceDef(): Cannot set ServiceDef in RangerTagResourceMap.");
            }
        }
    }

    private boolean hasTagPolicies() {
        return this.tagPolicyRepository != null && CollectionUtils.isNotEmpty(this.tagPolicyRepository.getPolicies());
    }

    private boolean hasResourcePolicies() {
        return this.policyRepository != null && CollectionUtils.isNotEmpty(this.policyRepository.getPolicies());
    }

    private Map<Long, RangerPolicyEvaluator> createPolicyEvaluatorsMap() {
        HashMap<Long, RangerPolicyEvaluator> tmpPolicyEvaluatorMap = new HashMap<Long, RangerPolicyEvaluator>();
        if (this.tagPolicyRepository != null) {
            for (RangerPolicyEvaluator evaluator : this.tagPolicyRepository.getPolicyEvaluators()) {
                tmpPolicyEvaluatorMap.put(evaluator.getPolicy().getId(), evaluator);
            }
            for (RangerPolicyEvaluator evaluator : this.tagPolicyRepository.getDataMaskPolicyEvaluators()) {
                tmpPolicyEvaluatorMap.put(evaluator.getPolicy().getId(), evaluator);
            }
            for (RangerPolicyEvaluator evaluator : this.tagPolicyRepository.getRowFilterPolicyEvaluators()) {
                tmpPolicyEvaluatorMap.put(evaluator.getPolicy().getId(), evaluator);
            }
        }
        for (RangerPolicyEvaluator evaluator : this.policyRepository.getPolicyEvaluators()) {
            tmpPolicyEvaluatorMap.put(evaluator.getPolicy().getId(), evaluator);
        }
        for (RangerPolicyEvaluator evaluator : this.policyRepository.getDataMaskPolicyEvaluators()) {
            tmpPolicyEvaluatorMap.put(evaluator.getPolicy().getId(), evaluator);
        }
        for (RangerPolicyEvaluator evaluator : this.policyRepository.getRowFilterPolicyEvaluators()) {
            tmpPolicyEvaluatorMap.put(evaluator.getPolicy().getId(), evaluator);
        }
        return Collections.unmodifiableMap(tmpPolicyEvaluatorMap);
    }

    private void updatePolicyUsageCounts(RangerAccessRequest accessRequest, RangerAccessResult accessResult) {
        RangerPolicyEvaluator accessPolicy;
        boolean auditCountUpdated = false;
        if (accessResult.getIsAccessDetermined() && (accessPolicy = this.getPolicyEvaluator(accessResult.getPolicyId())) != null) {
            if (accessPolicy.getPolicy().getIsAuditEnabled().booleanValue()) {
                this.updateUsageCount(accessPolicy, 2);
                accessResult.setAuditPolicyId(accessResult.getPolicyId());
                auditCountUpdated = true;
            } else {
                this.updateUsageCount(accessPolicy, 1);
            }
        }
        if (!auditCountUpdated && accessResult.getIsAuditedDetermined()) {
            long auditPolicyId = accessResult.getAuditPolicyId();
            RangerPolicyEvaluator auditPolicy = auditPolicyId == -1L ? null : this.getPolicyEvaluator(auditPolicyId);
            this.updateUsageCount(auditPolicy, 1);
        }
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_USAGE_LOG)) {
            RangerAccessRequestImpl rangerAccessRequest = (RangerAccessRequestImpl)accessRequest;
            RangerPerfTracer perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_USAGE_LOG, "RangerPolicyEngine.usage(accessingUser=" + rangerAccessRequest.getUser() + ",accessedResource=" + rangerAccessRequest.getResource().getAsString() + ",accessType=" + rangerAccessRequest.getAccessType() + ",evaluatedPoliciesCount=" + accessResult.getEvaluatedPoliciesCount() + ")");
            RangerPerfTracer.logAlways(perf);
        }
    }

    private void updateUsageCount(RangerPolicyEvaluator evaluator, int number) {
        if (evaluator != null) {
            evaluator.incrementUsageCount(number);
        }
    }
}

