/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyevaluator;

import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceEvaluator;
import org.apache.ranger.plugin.util.ServiceDefUtil;

public abstract class RangerAbstractPolicyEvaluator
implements RangerPolicyEvaluator {
    private static final Log LOG = LogFactory.getLog(RangerAbstractPolicyEvaluator.class);
    private RangerPolicy policy = null;
    private RangerServiceDef serviceDef = null;
    private Integer leafResourceLevel = null;
    private int evalOrder = 0;
    protected long usageCount = 0L;
    protected boolean usageCountMutable = true;

    @Override
    public void init(RangerPolicy policy, RangerServiceDef serviceDef, RangerPolicyEngineOptions options) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAbstractPolicyEvaluator.init(" + policy + ", " + serviceDef + ")"));
        }
        this.policy = policy;
        this.serviceDef = serviceDef;
        this.leafResourceLevel = ServiceDefUtil.getLeafResourceLevel(serviceDef, this.getPolicyResource());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAbstractPolicyEvaluator.init(" + policy + ", " + serviceDef + ")"));
        }
    }

    @Override
    public long getId() {
        return this.policy != null ? this.policy.getId() : -1L;
    }

    @Override
    public Map<String, RangerPolicy.RangerPolicyResource> getPolicyResource() {
        return this.policy != null ? this.policy.getResources() : null;
    }

    @Override
    public RangerPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public RangerServiceDef getServiceDef() {
        return this.serviceDef;
    }

    @Override
    public Integer getLeafResourceLevel() {
        return this.leafResourceLevel;
    }

    @Override
    public boolean hasAllow() {
        return this.policy != null && CollectionUtils.isNotEmpty(this.policy.getPolicyItems());
    }

    protected boolean hasMatchablePolicyItem(RangerAccessRequest request) {
        return this.hasAllow() || this.hasDeny();
    }

    @Override
    public boolean hasDeny() {
        return this.policy != null && CollectionUtils.isNotEmpty(this.policy.getDenyPolicyItems());
    }

    @Override
    public long getUsageCount() {
        return this.usageCount;
    }

    @Override
    public int getEvalOrder() {
        return this.evalOrder;
    }

    @Override
    public boolean isAuditEnabled() {
        return this.policy != null && this.policy.getIsAuditEnabled() != false;
    }

    @Override
    public int compareTo(RangerPolicyResourceEvaluator obj) {
        int result;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAbstractPolicyEvaluator.compareTo()");
        }
        if (obj instanceof RangerPolicyEvaluator) {
            RangerPolicyEvaluator other = (RangerPolicyEvaluator)obj;
            if (this.hasDeny() && !other.hasDeny()) {
                result = -1;
            } else if (!this.hasDeny() && other.hasDeny()) {
                result = 1;
            } else {
                result = Long.compare(other.getUsageCount(), this.usageCount);
                if (result == 0) {
                    result = Integer.compare(this.evalOrder, other.getEvalOrder());
                }
            }
        } else {
            result = Long.compare(this.getId(), obj.getId());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAbstractPolicyEvaluator.compareTo(), result:" + result));
        }
        return result;
    }

    public void setEvalOrder(int evalOrder) {
        this.evalOrder = evalOrder;
    }

    @Override
    public void incrementUsageCount(int number) {
        if (this.usageCountMutable) {
            this.usageCount += (long)number;
        }
    }

    @Override
    public void setUsageCountImmutable() {
        this.usageCountMutable = false;
    }

    @Override
    public void resetUsageCount() {
        this.usageCount = 0L;
        this.usageCountMutable = true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerAbstractPolicyEvaluator={");
        sb.append("policy={").append(this.policy).append("} ");
        sb.append("serviceDef={").append(this.serviceDef).append("} ");
        sb.append("}");
        return sb;
    }
}

