/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.resourcematcher;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.util.StringTokenReplacer;

abstract class ResourceMatcher
implements Comparable<ResourceMatcher> {
    private static final Log LOG = LogFactory.getLog(ResourceMatcher.class);
    protected final String value;
    protected StringTokenReplacer tokenReplacer;
    static final int DYNAMIC_EVALUATION_PENALTY = 8;

    ResourceMatcher(String value) {
        this.value = value;
    }

    abstract boolean isMatch(String var1, Map<String, Object> var2);

    abstract int getPriority();

    boolean isMatchAny() {
        return this.value != null && this.value.length() == 0;
    }

    boolean getNeedsDynamicEval() {
        return this.tokenReplacer != null;
    }

    @Override
    public int compareTo(ResourceMatcher other) {
        return Integer.compare(this.getPriority(), other.getPriority());
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.value + ")";
    }

    void setDelimiters(char startDelimiterChar, char endDelimiterChar, char escapeChar, String tokenPrefix) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> setDelimiters(value= " + this.value + ", startDelimiter=" + startDelimiterChar + ", endDelimiter=" + endDelimiterChar + ", escapeChar=" + escapeChar + ", prefix=" + tokenPrefix));
        }
        if (this.value != null && (this.value.indexOf(escapeChar) != -1 || this.value.indexOf(startDelimiterChar) != -1 && this.value.indexOf(endDelimiterChar) != -1)) {
            this.tokenReplacer = new StringTokenReplacer(startDelimiterChar, endDelimiterChar, escapeChar, tokenPrefix);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== setDelimiters(value= " + this.value + ", startDelimiter=" + startDelimiterChar + ", endDelimiter=" + endDelimiterChar + ", escapeChar=" + escapeChar + ", prefix=" + tokenPrefix));
        }
    }

    String getExpandedValue(Map<String, Object> evalContext) {
        String ret = this.tokenReplacer != null ? this.tokenReplacer.replaceTokens(this.value, evalContext) : this.value;
        return ret;
    }
}

