/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.model.RangerBaseModelObject;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.store.EmbeddedServiceDefsUtil;
import org.apache.ranger.plugin.store.PList;
import org.apache.ranger.plugin.store.ServiceStore;
import org.apache.ranger.plugin.util.SearchFilter;

public abstract class AbstractServiceStore
implements ServiceStore {
    private static final Log LOG = LogFactory.getLog(AbstractServiceStore.class);
    public static final String COMPONENT_ACCESSTYPE_SEPARATOR = ":";
    private static final int MAX_ACCESS_TYPES_IN_SERVICE_DEF = 1000;

    protected abstract void updateServicesForServiceDefUpdate(RangerServiceDef var1) throws Exception;

    @Override
    public void updateTagServiceDefForAccessTypes() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> ServiceDefDBStore.updateTagServiceDefForAccessTypes()");
        }
        List<RangerServiceDef> allServiceDefs = this.getServiceDefs(new SearchFilter());
        for (RangerServiceDef serviceDef : allServiceDefs) {
            this.updateTagServiceDefForUpdatingAccessTypes(serviceDef);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== ServiceDefDBStore.updateTagServiceDefForAccessTypes()");
        }
    }

    @Override
    public PList<RangerServiceDef> getPaginatedServiceDefs(SearchFilter filter) throws Exception {
        List<RangerServiceDef> resultList = this.getServiceDefs(filter);
        return CollectionUtils.isEmpty(resultList) ? new PList<RangerServiceDef>() : new PList<RangerServiceDef>(resultList, 0, resultList.size(), resultList.size(), resultList.size(), filter.getSortType(), filter.getSortBy());
    }

    @Override
    public PList<RangerService> getPaginatedServices(SearchFilter filter) throws Exception {
        List<RangerService> resultList = this.getServices(filter);
        return CollectionUtils.isEmpty(resultList) ? new PList<RangerService>() : new PList<RangerService>(resultList, 0, resultList.size(), resultList.size(), resultList.size(), filter.getSortType(), filter.getSortBy());
    }

    @Override
    public PList<RangerPolicy> getPaginatedPolicies(SearchFilter filter) throws Exception {
        List<RangerPolicy> resultList = this.getPolicies(filter);
        return CollectionUtils.isEmpty(resultList) ? new PList<RangerPolicy>() : new PList<RangerPolicy>(resultList, 0, resultList.size(), resultList.size(), resultList.size(), filter.getSortType(), filter.getSortBy());
    }

    @Override
    public PList<RangerPolicy> getPaginatedServicePolicies(Long serviceId, SearchFilter filter) throws Exception {
        List<RangerPolicy> resultList = this.getServicePolicies(serviceId, filter);
        return CollectionUtils.isEmpty(resultList) ? new PList<RangerPolicy>() : new PList<RangerPolicy>(resultList, 0, resultList.size(), resultList.size(), resultList.size(), filter.getSortType(), filter.getSortBy());
    }

    @Override
    public PList<RangerPolicy> getPaginatedServicePolicies(String serviceName, SearchFilter filter) throws Exception {
        List<RangerPolicy> resultList = this.getServicePolicies(serviceName, filter);
        return CollectionUtils.isEmpty(resultList) ? new PList<RangerPolicy>() : new PList<RangerPolicy>(resultList, 0, resultList.size(), resultList.size(), resultList.size(), filter.getSortType(), filter.getSortBy());
    }

    @Override
    public Long getServicePolicyVersion(String serviceName) {
        RangerService service = null;
        try {
            service = this.getServiceByName(serviceName);
        }
        catch (Exception exception) {
            LOG.error((Object)("Failed to get service object for service:" + serviceName));
        }
        return service != null ? service.getPolicyVersion() : null;
    }

    protected void postCreate(RangerBaseModelObject obj) throws Exception {
        if (obj instanceof RangerServiceDef) {
            this.updateTagServiceDefForUpdatingAccessTypes((RangerServiceDef)obj);
        }
    }

    protected void postUpdate(RangerBaseModelObject obj) throws Exception {
        if (obj instanceof RangerServiceDef) {
            RangerServiceDef serviceDef = (RangerServiceDef)obj;
            this.updateTagServiceDefForUpdatingAccessTypes(serviceDef);
            this.updateServicesForServiceDefUpdate(serviceDef);
        }
    }

    protected void postDelete(RangerBaseModelObject obj) throws Exception {
        if (obj instanceof RangerServiceDef) {
            this.updateTagServiceDefForDeletingAccessTypes(((RangerServiceDef)obj).getName());
        }
    }

    protected final long getNextVersion(Long currentVersion) {
        return currentVersion == null ? 1L : currentVersion + 1L;
    }

    private RangerServiceDef.RangerAccessTypeDef findAccessTypeDef(long itemId, List<RangerServiceDef.RangerAccessTypeDef> accessTypeDefs) {
        RangerServiceDef.RangerAccessTypeDef ret = null;
        for (RangerServiceDef.RangerAccessTypeDef accessTypeDef : accessTypeDefs) {
            if (itemId != accessTypeDef.getItemId()) continue;
            ret = accessTypeDef;
            break;
        }
        return ret;
    }

    private void updateTagServiceDefForUpdatingAccessTypes(RangerServiceDef serviceDef) throws Exception {
        if (StringUtils.equals((String)serviceDef.getName(), (String)"tag")) {
            return;
        }
        if (EmbeddedServiceDefsUtil.instance().getTagServiceDefId() == -1L) {
            LOG.info((Object)("AbstractServiceStore.updateTagServiceDefForUpdatingAccessTypes(" + serviceDef.getName() + "): tag service-def does not exist"));
        }
        String serviceDefName = serviceDef.getName();
        RangerServiceDef tagServiceDef = null;
        try {
            tagServiceDef = this.getServiceDef(EmbeddedServiceDefsUtil.instance().getTagServiceDefId());
        }
        catch (Exception e) {
            LOG.error((Object)("AbstractServiceStore.updateTagServiceDefForUpdatingAccessTypes" + serviceDef.getName() + "): could not find TAG ServiceDef.. "), (Throwable)e);
            throw e;
        }
        if (tagServiceDef == null) {
            LOG.error((Object)("AbstractServiceStore.updateTagServiceDefForUpdatingAccessTypes(" + serviceDef.getName() + "): could not find TAG ServiceDef.. "));
            return;
        }
        ArrayList<RangerServiceDef.RangerAccessTypeDef> toAdd = new ArrayList<RangerServiceDef.RangerAccessTypeDef>();
        ArrayList<RangerServiceDef.RangerAccessTypeDef> toUpdate = new ArrayList<RangerServiceDef.RangerAccessTypeDef>();
        ArrayList<RangerServiceDef.RangerAccessTypeDef> toDelete = new ArrayList<RangerServiceDef.RangerAccessTypeDef>();
        List<RangerServiceDef.RangerAccessTypeDef> svcDefAccessTypes = serviceDef.getAccessTypes();
        List<RangerServiceDef.RangerAccessTypeDef> tagDefAccessTypes = tagServiceDef.getAccessTypes();
        long itemIdOffset = serviceDef.getId() * 1001L;
        for (RangerServiceDef.RangerAccessTypeDef svcAccessType : svcDefAccessTypes) {
            long tagAccessTypeItemId = svcAccessType.getItemId() + itemIdOffset;
            RangerServiceDef.RangerAccessTypeDef tagAccessType = this.findAccessTypeDef(tagAccessTypeItemId, tagDefAccessTypes);
            if (tagAccessType != null) continue;
            tagAccessType = new RangerServiceDef.RangerAccessTypeDef();
            tagAccessType.setItemId(tagAccessTypeItemId);
            tagAccessType.setName(serviceDefName + COMPONENT_ACCESSTYPE_SEPARATOR + svcAccessType.getName());
            tagAccessType.setLabel(svcAccessType.getLabel());
            tagAccessType.setRbKeyLabel(svcAccessType.getRbKeyLabel());
            tagAccessType.setImpliedGrants(new HashSet<String>());
            if (CollectionUtils.isNotEmpty(svcAccessType.getImpliedGrants())) {
                for (String svcImpliedGrant : svcAccessType.getImpliedGrants()) {
                    tagAccessType.getImpliedGrants().add(serviceDefName + COMPONENT_ACCESSTYPE_SEPARATOR + svcImpliedGrant);
                }
            }
            toAdd.add(tagAccessType);
        }
        for (RangerServiceDef.RangerAccessTypeDef tagAccessType : tagDefAccessTypes) {
            if (!tagAccessType.getName().startsWith(serviceDefName + COMPONENT_ACCESSTYPE_SEPARATOR)) continue;
            long svcAccessTypeItemId = tagAccessType.getItemId() - itemIdOffset;
            RangerServiceDef.RangerAccessTypeDef svcAccessType = this.findAccessTypeDef(svcAccessTypeItemId, svcDefAccessTypes);
            if (svcAccessType == null) {
                toDelete.add(tagAccessType);
                continue;
            }
            boolean isUpdated = false;
            if (!Objects.equals(tagAccessType.getName().substring(serviceDefName.length() + 1), svcAccessType.getName())) {
                isUpdated = true;
            } else if (!Objects.equals(tagAccessType.getLabel(), svcAccessType.getLabel())) {
                isUpdated = true;
            } else if (!Objects.equals(tagAccessType.getRbKeyLabel(), svcAccessType.getRbKeyLabel())) {
                isUpdated = true;
            } else {
                int svcImpliedGrantsLen;
                Collection<String> tagImpliedGrants = tagAccessType.getImpliedGrants();
                Collection<String> svcImpliedGrants = svcAccessType.getImpliedGrants();
                int tagImpliedGrantsLen = tagImpliedGrants == null ? 0 : tagImpliedGrants.size();
                int n = svcImpliedGrantsLen = svcImpliedGrants == null ? 0 : svcImpliedGrants.size();
                if (tagImpliedGrantsLen != svcImpliedGrantsLen) {
                    isUpdated = true;
                } else if (tagImpliedGrantsLen > 0) {
                    for (String svcImpliedGrant : svcImpliedGrants) {
                        if (tagImpliedGrants.contains(serviceDefName + COMPONENT_ACCESSTYPE_SEPARATOR + svcImpliedGrant)) continue;
                        isUpdated = true;
                        break;
                    }
                }
            }
            if (!isUpdated) continue;
            tagAccessType.setName(serviceDefName + COMPONENT_ACCESSTYPE_SEPARATOR + svcAccessType.getName());
            tagAccessType.setLabel(svcAccessType.getLabel());
            tagAccessType.setRbKeyLabel(svcAccessType.getRbKeyLabel());
            tagAccessType.setImpliedGrants(new HashSet<String>());
            if (CollectionUtils.isNotEmpty(svcAccessType.getImpliedGrants())) {
                for (String svcImpliedGrant : svcAccessType.getImpliedGrants()) {
                    tagAccessType.getImpliedGrants().add(serviceDefName + COMPONENT_ACCESSTYPE_SEPARATOR + svcImpliedGrant);
                }
            }
            toUpdate.add(tagAccessType);
        }
        if (CollectionUtils.isNotEmpty(toAdd) || CollectionUtils.isNotEmpty(toUpdate) || CollectionUtils.isNotEmpty(toDelete)) {
            tagDefAccessTypes.addAll(toAdd);
            tagDefAccessTypes.removeAll(toDelete);
            try {
                this.updateServiceDef(tagServiceDef);
                LOG.info((Object)("AbstractServiceStore.updateTagServiceDefForUpdatingAccessTypes -- updated TAG service def with " + serviceDefName + " access types"));
            }
            catch (Exception e) {
                LOG.error((Object)"AbstractServiceStore.updateTagServiceDefForUpdatingAccessTypes -- Failed to update TAG ServiceDef.. ", (Throwable)e);
                throw e;
            }
        }
    }

    private void updateTagServiceDefForDeletingAccessTypes(String serviceDefName) throws Exception {
        RangerServiceDef tagServiceDef;
        if (serviceDefName.equals("tag")) {
            return;
        }
        try {
            tagServiceDef = this.getServiceDef(EmbeddedServiceDefsUtil.instance().getTagServiceDefId());
        }
        catch (Exception e) {
            LOG.error((Object)("AbstractServiceStore.updateTagServiceDefForDeletingAccessTypes(" + serviceDefName + "): could not find TAG ServiceDef.. "), (Throwable)e);
            throw e;
        }
        if (tagServiceDef == null) {
            LOG.error((Object)("AbstractServiceStore.updateTagServiceDefForDeletingAccessTypes(" + serviceDefName + "): could not find TAG ServiceDef.. "));
            return;
        }
        ArrayList<RangerServiceDef.RangerAccessTypeDef> accessTypes = new ArrayList<RangerServiceDef.RangerAccessTypeDef>();
        for (RangerServiceDef.RangerAccessTypeDef accessType : tagServiceDef.getAccessTypes()) {
            if (!accessType.getName().startsWith(serviceDefName + COMPONENT_ACCESSTYPE_SEPARATOR)) continue;
            accessTypes.add(accessType);
        }
        tagServiceDef.getAccessTypes().removeAll(accessTypes);
        try {
            this.updateServiceDef(tagServiceDef);
            LOG.info((Object)("AbstractServiceStore.updateTagServiceDefForDeletingAccessTypes -- updated TAG service def with " + serviceDefName + " access types"));
        }
        catch (Exception e) {
            LOG.error((Object)"AbstractServiceStore.updateTagServiceDefForDeletingAccessTypes -- Failed to update TAG ServiceDef.. ", (Throwable)e);
            throw e;
        }
    }
}

