/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceEvaluator;
import org.apache.ranger.plugin.util.RangerResourceTrie;

class TrieNode<T extends RangerPolicyResourceEvaluator> {
    private final Character c;
    private Map<Character, TrieNode> children = null;
    private List<T> evaluators = null;
    private List<T> wildcardEvaluators = null;
    private boolean isSharingParentWildcardEvaluators = false;

    TrieNode(Character c) {
        this.c = c;
    }

    Character getChar() {
        return this.c;
    }

    Map<Character, TrieNode> getChildren() {
        return this.children;
    }

    List<T> getEvaluators() {
        return this.evaluators;
    }

    List<T> getWildcardEvaluators() {
        return this.wildcardEvaluators;
    }

    TrieNode getChild(Character c) {
        TrieNode ret = this.children == null ? null : this.children.get(c);
        return ret;
    }

    void populateTrieData(RangerResourceTrie.TrieData trieData) {
        ++trieData.nodeCount;
        if (this.wildcardEvaluators != null) {
            if (this.isSharingParentWildcardEvaluators) {
                ++trieData.wildcardEvaluatorListRefCount;
            } else {
                ++trieData.wildcardEvaluatorListCount;
            }
        }
        if (this.evaluators != null) {
            if (this.evaluators == this.wildcardEvaluators) {
                ++trieData.evaluatorListRefCount;
            } else {
                ++trieData.evaluatorListCount;
            }
        }
        if (this.children != null && this.children.size() > 0) {
            if (this.children.size() == 1) {
                ++trieData.singleChildNodeCount;
            }
            for (Map.Entry<Character, TrieNode> entry : this.children.entrySet()) {
                TrieNode child = entry.getValue();
                child.populateTrieData(trieData);
            }
        } else {
            ++trieData.leafNodeCount;
        }
    }

    int getMaxDepth() {
        int ret = 0;
        if (this.children != null) {
            for (Map.Entry<Character, TrieNode> entry : this.children.entrySet()) {
                TrieNode child = entry.getValue();
                int maxChildDepth = child.getMaxDepth();
                if (maxChildDepth <= ret) continue;
                ret = maxChildDepth;
            }
        }
        return ret + 1;
    }

    TrieNode getOrCreateChild(Character c) {
        TrieNode<T> child;
        if (this.children == null) {
            this.children = new HashMap<Character, TrieNode>();
        }
        if ((child = this.children.get(c)) == null) {
            child = new TrieNode<T>(c);
            this.children.put(c, child);
        }
        return child;
    }

    void addEvaluator(T evaluator) {
        if (this.evaluators == null) {
            this.evaluators = new ArrayList<T>();
        }
        if (!this.evaluators.contains(evaluator)) {
            this.evaluators.add(evaluator);
        }
    }

    void addWildcardEvaluator(T evaluator) {
        if (this.wildcardEvaluators == null) {
            this.wildcardEvaluators = new ArrayList<T>();
        }
        if (!this.wildcardEvaluators.contains(evaluator)) {
            this.wildcardEvaluators.add(evaluator);
        }
    }

    void postSetup(List<T> parentWildcardEvaluators) {
        if (parentWildcardEvaluators != null) {
            if (CollectionUtils.isEmpty(this.wildcardEvaluators)) {
                this.wildcardEvaluators = parentWildcardEvaluators;
            } else {
                for (RangerPolicyResourceEvaluator rangerPolicyResourceEvaluator : parentWildcardEvaluators) {
                    this.addWildcardEvaluator(rangerPolicyResourceEvaluator);
                }
            }
        }
        boolean bl = this.isSharingParentWildcardEvaluators = this.wildcardEvaluators == parentWildcardEvaluators;
        if (this.wildcardEvaluators != null) {
            if (CollectionUtils.isEmpty(this.evaluators)) {
                this.evaluators = this.wildcardEvaluators;
            } else {
                for (RangerPolicyResourceEvaluator rangerPolicyResourceEvaluator : this.wildcardEvaluators) {
                    this.addEvaluator(rangerPolicyResourceEvaluator);
                }
            }
        }
        if (!this.isSharingParentWildcardEvaluators && CollectionUtils.isNotEmpty(this.wildcardEvaluators)) {
            Collections.sort(this.wildcardEvaluators);
        }
        if (this.evaluators != this.wildcardEvaluators && CollectionUtils.isNotEmpty(this.evaluators)) {
            Collections.sort(this.evaluators);
        }
        if (this.children != null) {
            for (Map.Entry entry : this.children.entrySet()) {
                TrieNode child = (TrieNode)entry.getValue();
                child.postSetup(this.wildcardEvaluators);
            }
        }
    }

    void reorderEvaluators(List<T> parentWildcardEvaluators) {
        boolean isEvaluatorsSameAsWildcardEvaluators = this.evaluators == this.wildcardEvaluators;
        this.wildcardEvaluators = this.isSharingParentWildcardEvaluators ? parentWildcardEvaluators : this.getSortedCopy(this.wildcardEvaluators);
        this.evaluators = isEvaluatorsSameAsWildcardEvaluators ? this.wildcardEvaluators : this.getSortedCopy(this.evaluators);
        if (this.children != null) {
            for (Map.Entry<Character, TrieNode> entry : this.children.entrySet()) {
                TrieNode child = entry.getValue();
                child.reorderEvaluators(this.wildcardEvaluators);
            }
        }
    }

    public void toString(String prefix, StringBuilder sb) {
        String nodeValue = prefix;
        if (this.c.charValue() != '\u0000') {
            nodeValue = nodeValue + this.c;
        }
        sb.append("nodeValue=").append(nodeValue);
        sb.append("; childCount=").append(this.children == null ? 0 : this.children.size());
        sb.append("; evaluators=[ ");
        if (this.evaluators != null) {
            for (RangerPolicyResourceEvaluator rangerPolicyResourceEvaluator : this.evaluators) {
                sb.append(rangerPolicyResourceEvaluator.getId()).append(" ");
            }
        }
        sb.append("]");
        sb.append("; wildcardEvaluators=[ ");
        if (this.wildcardEvaluators != null) {
            for (RangerPolicyResourceEvaluator rangerPolicyResourceEvaluator : this.wildcardEvaluators) {
                sb.append(rangerPolicyResourceEvaluator.getId()).append(" ");
            }
        }
        sb.append("]");
        sb.append(13);
        if (this.children != null) {
            for (Map.Entry entry : this.children.entrySet()) {
                TrieNode child = (TrieNode)entry.getValue();
                child.toString(nodeValue, sb);
            }
        }
    }

    public void clear() {
        this.children = null;
        this.evaluators = null;
        this.wildcardEvaluators = null;
    }

    private List<T> getSortedCopy(List<T> evaluators) {
        List<T> ret;
        if (CollectionUtils.isNotEmpty(evaluators)) {
            ret = new ArrayList<T>(evaluators);
            Collections.sort(ret);
        } else {
            ret = evaluators;
        }
        return ret;
    }
}

