/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.tag;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.service.RangerBaseService;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.plugin.store.TagStore;

public class RangerServiceTag
extends RangerBaseService {
    private static final Log LOG = LogFactory.getLog(RangerServiceTag.class);
    public static final String TAG_RESOURCE_NAME = "tag";
    private TagStore tagStore = null;

    @Override
    public void init(RangerServiceDef serviceDef, RangerService service) {
        super.init(serviceDef, service);
    }

    public void setTagStore(TagStore tagStore) {
        this.tagStore = tagStore;
    }

    @Override
    public HashMap<String, Object> validateConfig() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerServiceTag.validateConfig(" + this.serviceName + " )"));
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("connectivityStatus", true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerServiceTag.validateConfig(" + this.serviceName + " ): " + ret));
        }
        return ret;
    }

    @Override
    public List<String> lookupResource(ResourceLookupContext context) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerServiceTag.lookupResource(" + context + ")"));
        }
        ArrayList<String> ret = new ArrayList<String>();
        if (context != null && StringUtils.equals((String)context.getResourceName(), (String)TAG_RESOURCE_NAME)) {
            try {
                List<String> tags;
                List<String> list = tags = this.tagStore != null ? this.tagStore.getTagTypes() : null;
                if (CollectionUtils.isNotEmpty(tags)) {
                    String valueToMatch;
                    List<String> valuesToExclude;
                    List<String> list2 = valuesToExclude = MapUtils.isNotEmpty(context.getResources()) ? context.getResources().get(TAG_RESOURCE_NAME) : null;
                    if (CollectionUtils.isNotEmpty(valuesToExclude)) {
                        for (String valueToExclude : valuesToExclude) {
                            tags.remove(valueToExclude);
                        }
                    }
                    if (StringUtils.isNotEmpty((String)(valueToMatch = context.getUserInput()))) {
                        if (!valueToMatch.endsWith("*")) {
                            valueToMatch = valueToMatch + "*";
                        }
                        for (String tag : tags) {
                            if (!FilenameUtils.wildcardMatch((String)tag, (String)valueToMatch)) continue;
                            ret.add(tag);
                        }
                    }
                }
            }
            catch (Exception excp) {
                LOG.error((Object)"RangerServiceTag.lookupResource()", (Throwable)excp);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerServiceTag.lookupResource(): tag count=" + ret.size()));
        }
        return ret;
    }
}

