/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.admin.client.RangerAdminClient;
import org.apache.ranger.admin.client.RangerAdminRESTClient;
import org.apache.ranger.audit.provider.AuditHandler;
import org.apache.ranger.audit.provider.AuditProviderFactory;
import org.apache.ranger.audit.provider.StandAloneAuditProviderFactory;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngine;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineImpl;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.policyengine.RangerResourceAccessInfo;
import org.apache.ranger.plugin.service.RangerAuthContext;
import org.apache.ranger.plugin.service.RangerAuthContextListener;
import org.apache.ranger.plugin.store.EmbeddedServiceDefsUtil;
import org.apache.ranger.plugin.util.GrantRevokeRequest;
import org.apache.ranger.plugin.util.PolicyRefresher;
import org.apache.ranger.plugin.util.ServicePolicies;

public class RangerBasePlugin {
    private static final Log LOG = LogFactory.getLog(RangerBasePlugin.class);
    public static final char RANGER_TRUSTED_PROXY_IPADDRESSES_SEPARATOR_CHAR = ',';
    private static Map<String, RangerBasePlugin> servicePluginMap = new ConcurrentHashMap<String, RangerBasePlugin>();
    private String serviceType;
    private String appId;
    private String serviceName;
    private String clusterName;
    private PolicyRefresher refresher;
    private RangerPolicyEngine policyEngine;
    private RangerPolicyEngineOptions policyEngineOptions = new RangerPolicyEngineOptions();
    private RangerAuthContext currentAuthContext;
    private RangerAuthContext readOnlyAuthContext;
    private RangerAccessResultProcessor resultProcessor;
    private boolean useForwardedIPAddress;
    private String[] trustedProxyAddresses;
    private Timer policyEngineRefreshTimer;
    private RangerAuthContextListener authContextListener;
    private AuditProviderFactory auditProviderFactory;
    Map<String, LogHistory> logHistoryList = new Hashtable<String, LogHistory>();
    int logInterval = 30000;

    public static Map<String, RangerBasePlugin> getServicePluginMap() {
        return servicePluginMap;
    }

    public static AuditHandler getAuditProvider(String serviceName) {
        AuditHandler ret = null;
        boolean useStandaloneAuditProvider = false;
        if (StringUtils.isNotEmpty((String)serviceName)) {
            RangerBasePlugin plugin = RangerBasePlugin.getServicePluginMap().get(serviceName);
            if (plugin != null) {
                if (plugin.getAuditProviderFactory() != null) {
                    ret = plugin.getAuditProviderFactory().getAuditProvider();
                } else {
                    LOG.error((Object)("NULL AuditProviderFactory for serviceName:[" + serviceName + "]"));
                }
            } else {
                useStandaloneAuditProvider = true;
            }
        } else {
            useStandaloneAuditProvider = true;
        }
        if (useStandaloneAuditProvider) {
            StandAloneAuditProviderFactory factory = StandAloneAuditProviderFactory.getInstance();
            if (factory.isInitDone()) {
                ret = factory.getAuditProvider();
            } else {
                String auditCfg;
                RangerConfiguration conf = RangerConfiguration.getInstance();
                if (conf.addResourceIfReadable(auditCfg = "ranger-standalone-audit.xml")) {
                    factory.init(conf.getProperties(), "StandAlone");
                    ret = factory.getAuditProvider();
                } else {
                    LOG.error((Object)("StandAlone audit handler configuration not readable:[" + auditCfg + "]"));
                }
            }
        }
        return ret;
    }

    public RangerBasePlugin(String serviceType, String appId) {
        this.serviceType = serviceType;
        this.appId = appId;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public RangerAuthContext createRangerAuthContext() {
        return new RangerAuthContext(this.readOnlyAuthContext);
    }

    public RangerAuthContext getCurrentRangerAuthContext() {
        return this.currentAuthContext;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public RangerServiceDef getServiceDef() {
        RangerPolicyEngine policyEngine = this.policyEngine;
        return policyEngine != null ? policyEngine.getServiceDef() : null;
    }

    public int getServiceDefId() {
        RangerServiceDef serviceDef = this.getServiceDef();
        return serviceDef != null && serviceDef.getId() != null ? serviceDef.getId().intValue() : -1;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public AuditProviderFactory getAuditProviderFactory() {
        return this.auditProviderFactory;
    }

    public void init() {
        this.cleanup();
        RangerConfiguration configuration = RangerConfiguration.getInstance();
        configuration.addResourcesForServiceType(this.serviceType);
        String propertyPrefix = "ranger.plugin." + this.serviceType;
        long pollingIntervalMs = configuration.getLong(propertyPrefix + ".policy.pollIntervalMs", 30000L);
        String cacheDir = configuration.get(propertyPrefix + ".policy.cache.dir");
        this.serviceName = configuration.get(propertyPrefix + ".service.name");
        this.clusterName = RangerConfiguration.getInstance().get(propertyPrefix + ".ambari.cluster.name", "");
        this.useForwardedIPAddress = configuration.getBoolean(propertyPrefix + ".use.x-forwarded-for.ipaddress", false);
        String trustedProxyAddressString = configuration.get(propertyPrefix + ".trusted.proxy.ipaddresses");
        this.trustedProxyAddresses = StringUtils.split((String)trustedProxyAddressString, (char)',');
        if (this.trustedProxyAddresses != null) {
            for (int i = 0; i < this.trustedProxyAddresses.length; ++i) {
                this.trustedProxyAddresses[i] = this.trustedProxyAddresses[i].trim();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(propertyPrefix + ".use.x-forwarded-for.ipaddress:" + this.useForwardedIPAddress));
            LOG.debug((Object)(propertyPrefix + ".trusted.proxy.ipaddresses:[" + StringUtils.join((Object[])this.trustedProxyAddresses, (String)", ") + "]"));
        }
        if (this.useForwardedIPAddress && StringUtils.isBlank((String)trustedProxyAddressString)) {
            LOG.warn((Object)("Property " + propertyPrefix + ".use.x-forwarded-for.ipaddress is set to true, and Property " + propertyPrefix + ".trusted.proxy.ipaddresses is not set"));
            LOG.warn((Object)"Ranger plugin will trust RemoteIPAddress and treat first X-Forwarded-Address in the access-request as the clientIPAddress");
        }
        if (configuration.getProperties() != null) {
            this.auditProviderFactory = new AuditProviderFactory();
            this.auditProviderFactory.init(configuration.getProperties(), this.appId);
        } else {
            LOG.error((Object)"Audit subsystem is not initialized correctly. Please check audit configuration. ");
            LOG.error((Object)"No authorization audits will be generated. ");
            this.auditProviderFactory = null;
        }
        this.policyEngineOptions.configureForPlugin(configuration, propertyPrefix);
        LOG.info((Object)this.policyEngineOptions);
        servicePluginMap.put(this.serviceName, this);
        RangerAdminClient admin = RangerBasePlugin.createAdminClient(this.serviceName, this.appId, propertyPrefix);
        this.refresher = new PolicyRefresher(this, this.serviceType, this.appId, this.serviceName, admin, pollingIntervalMs, cacheDir);
        this.refresher.setDaemon(true);
        this.refresher.startRefresher();
        long policyReorderIntervalMs = configuration.getLong(propertyPrefix + ".policy.policyReorderInterval", 60000L);
        if (policyReorderIntervalMs >= 0L && policyReorderIntervalMs < 15000L) {
            policyReorderIntervalMs = 15000L;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(propertyPrefix + ".policy.policyReorderInterval:" + policyReorderIntervalMs));
        }
        if (this.policyEngineOptions.disableTrieLookupPrefilter && policyReorderIntervalMs > 0L) {
            this.policyEngineRefreshTimer = new Timer("PolicyEngineRefreshTimer", true);
            try {
                this.policyEngineRefreshTimer.schedule((TimerTask)new PolicyEngineRefresher(this), policyReorderIntervalMs, policyReorderIntervalMs);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Scheduled PolicyEngineRefresher to reorder policies based on number of evaluations in and every " + policyReorderIntervalMs + " milliseconds"));
                }
            }
            catch (IllegalStateException exception) {
                LOG.error((Object)"Error scheduling policyEngineRefresher:", (Throwable)exception);
                LOG.error((Object)("*** PolicyEngine will NOT be reorderd based on number of evaluations every " + policyReorderIntervalMs + " milliseconds ***"));
                this.policyEngineRefreshTimer = null;
            }
        } else {
            LOG.info((Object)"Policies will NOT be reordered based on number of evaluations");
        }
    }

    public void setPolicies(ServicePolicies policies) {
        try {
            RangerPolicyEngine oldPolicyEngine = this.policyEngine;
            if (policies == null) {
                policies = this.getDefaultSvcPolicies();
            }
            if (policies == null) {
                this.policyEngine = null;
                this.readOnlyAuthContext = null;
            } else {
                this.currentAuthContext = new RangerAuthContext();
                RangerPolicyEngineImpl policyEngine = new RangerPolicyEngineImpl(this.appId, policies, this.policyEngineOptions);
                policyEngine.setUseForwardedIPAddress(this.useForwardedIPAddress);
                policyEngine.setTrustedProxyAddresses(this.trustedProxyAddresses);
                this.policyEngine = policyEngine;
                this.currentAuthContext.setPolicyEngine(this.policyEngine);
                this.readOnlyAuthContext = new RangerAuthContext(this.currentAuthContext);
            }
            this.contextChanged();
            if (oldPolicyEngine != null && !oldPolicyEngine.preCleanup()) {
                LOG.error((Object)"preCleanup() failed on the previous policy engine instance !!");
            }
        }
        catch (Exception e) {
            LOG.error((Object)"setPolicies: policy engine initialization failed!  Leaving current policy engine as-is. Exception : ", (Throwable)e);
        }
    }

    public void contextChanged() {
        RangerAuthContextListener authContextListener = this.authContextListener;
        if (authContextListener != null) {
            authContextListener.contextChanged();
        }
    }

    public void cleanup() {
        PolicyRefresher refresher = this.refresher;
        RangerPolicyEngine policyEngine = this.policyEngine;
        Timer policyEngineRefreshTimer = this.policyEngineRefreshTimer;
        String serviceName = this.serviceName;
        this.serviceName = null;
        this.policyEngine = null;
        this.refresher = null;
        this.policyEngineRefreshTimer = null;
        if (refresher != null) {
            refresher.stopRefresher();
        }
        if (policyEngineRefreshTimer != null) {
            policyEngineRefreshTimer.cancel();
        }
        if (policyEngine != null) {
            policyEngine.cleanup();
        }
        if (serviceName != null) {
            servicePluginMap.remove(serviceName);
        }
    }

    public void setResultProcessor(RangerAccessResultProcessor resultProcessor) {
        this.resultProcessor = resultProcessor;
    }

    public RangerAccessResultProcessor getResultProcessor() {
        return this.resultProcessor;
    }

    public RangerAccessResult isAccessAllowed(RangerAccessRequest request) {
        return this.isAccessAllowed(request, this.resultProcessor);
    }

    public Collection<RangerAccessResult> isAccessAllowed(Collection<RangerAccessRequest> requests) {
        return this.isAccessAllowed(requests, this.resultProcessor);
    }

    public RangerAccessResult isAccessAllowed(RangerAccessRequest request, RangerAccessResultProcessor resultProcessor) {
        RangerPolicyEngine policyEngine = this.policyEngine;
        if (policyEngine != null) {
            policyEngine.preProcess(request);
            return policyEngine.evaluatePolicies(request, 0, resultProcessor);
        }
        return null;
    }

    public Collection<RangerAccessResult> isAccessAllowed(Collection<RangerAccessRequest> requests, RangerAccessResultProcessor resultProcessor) {
        RangerPolicyEngine policyEngine = this.policyEngine;
        if (policyEngine != null) {
            policyEngine.preProcess(requests);
            return policyEngine.evaluatePolicies(requests, 0, resultProcessor);
        }
        return null;
    }

    public RangerAccessResult evalDataMaskPolicies(RangerAccessRequest request, RangerAccessResultProcessor resultProcessor) {
        RangerPolicyEngine policyEngine = this.policyEngine;
        if (policyEngine != null) {
            policyEngine.preProcess(request);
            return policyEngine.evaluatePolicies(request, 1, resultProcessor);
        }
        return null;
    }

    public RangerAccessResult evalRowFilterPolicies(RangerAccessRequest request, RangerAccessResultProcessor resultProcessor) {
        RangerPolicyEngine policyEngine = this.policyEngine;
        if (policyEngine != null) {
            policyEngine.preProcess(request);
            return policyEngine.evaluatePolicies(request, 2, resultProcessor);
        }
        return null;
    }

    public RangerResourceAccessInfo getResourceAccessInfo(RangerAccessRequest request) {
        RangerPolicyEngine policyEngine = this.policyEngine;
        if (policyEngine != null) {
            policyEngine.preProcess(request);
            return policyEngine.getResourceAccessInfo(request);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grantAccess(GrantRevokeRequest request, RangerAccessResultProcessor resultProcessor) throws Exception {
        PolicyRefresher refresher;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerBasePlugin.grantAccess(" + request + ")"));
        }
        RangerAdminClient admin = (refresher = this.refresher) == null ? null : refresher.getRangerAdminClient();
        boolean isSuccess = false;
        try {
            if (admin == null) {
                throw new Exception("ranger-admin client is null");
            }
            admin.grantAccess(request);
            isSuccess = true;
        }
        finally {
            this.auditGrantRevoke(request, "grant", isSuccess, resultProcessor);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerBasePlugin.grantAccess(" + request + ")"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeAccess(GrantRevokeRequest request, RangerAccessResultProcessor resultProcessor) throws Exception {
        PolicyRefresher refresher;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerBasePlugin.revokeAccess(" + request + ")"));
        }
        RangerAdminClient admin = (refresher = this.refresher) == null ? null : refresher.getRangerAdminClient();
        boolean isSuccess = false;
        try {
            if (admin == null) {
                throw new Exception("ranger-admin client is null");
            }
            admin.revokeAccess(request);
            isSuccess = true;
        }
        finally {
            this.auditGrantRevoke(request, "revoke", isSuccess, resultProcessor);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerBasePlugin.revokeAccess(" + request + ")"));
        }
    }

    public void registerAuthContextEventListener(RangerAuthContextListener authContextListener) {
        this.authContextListener = authContextListener;
    }

    public void unregisterAuthContextEventListener(RangerAuthContextListener authContextListener) {
        this.authContextListener = null;
    }

    public static RangerAdminClient createAdminClient(String rangerServiceName, String applicationId, String propertyPrefix) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerBasePlugin.createAdminClient(" + rangerServiceName + ", " + applicationId + ", " + propertyPrefix + ")"));
        }
        RangerAdminClient ret = null;
        String propertyName = propertyPrefix + ".policy.source.impl";
        String policySourceImpl = RangerConfiguration.getInstance().get(propertyName);
        if (StringUtils.isEmpty((String)policySourceImpl)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Value for property[%s] was null or empty. Unexpected! Will use policy source of type[%s]", propertyName, RangerAdminRESTClient.class.getName()));
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Value for property[%s] was [%s].", propertyName, policySourceImpl));
            }
            try {
                Class<?> adminClass = Class.forName(policySourceImpl);
                ret = (RangerAdminClient)adminClass.newInstance();
            }
            catch (Exception excp) {
                LOG.error((Object)("failed to instantiate policy source of type '" + policySourceImpl + "'. Will use policy source of type '" + RangerAdminRESTClient.class.getName() + "'"), (Throwable)excp);
            }
        }
        if (ret == null) {
            ret = new RangerAdminRESTClient();
        }
        ret.init(rangerServiceName, applicationId, propertyPrefix);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerBasePlugin.createAdminClient(" + rangerServiceName + ", " + applicationId + ", " + propertyPrefix + "): policySourceImpl=" + policySourceImpl + ", client=" + ret));
        }
        return ret;
    }

    private void auditGrantRevoke(GrantRevokeRequest request, String action, boolean isSuccess, RangerAccessResultProcessor resultProcessor) {
        if (request != null && resultProcessor != null) {
            RangerAccessRequestImpl accessRequest = new RangerAccessRequestImpl();
            accessRequest.setResource(new RangerAccessResourceImpl(StringUtil.toStringObjectMap(request.getResource())));
            accessRequest.setUser(request.getGrantor());
            accessRequest.setAccessType("_admin");
            accessRequest.setAction(action);
            accessRequest.setClientIPAddress(request.getClientIPAddress());
            accessRequest.setClientType(request.getClientType());
            accessRequest.setRequestData(request.getRequestData());
            accessRequest.setSessionId(request.getSessionId());
            accessRequest.setClusterName(request.getClusterName());
            RangerAccessResult accessResult = this.isAccessAllowed(accessRequest, null);
            if (accessResult != null && accessResult.getIsAudited()) {
                accessRequest.setAccessType(action);
                accessResult.setIsAllowed(isSuccess);
                if (!isSuccess) {
                    accessResult.setPolicyId(-1L);
                }
                resultProcessor.processResult(accessResult);
            }
        }
    }

    public RangerServiceDef getDefaultServiceDef() {
        RangerServiceDef ret = null;
        if (StringUtils.isNotBlank((String)this.serviceType)) {
            try {
                ret = EmbeddedServiceDefsUtil.instance().getEmbeddedServiceDef(this.serviceType);
            }
            catch (Exception exp) {
                LOG.error((Object)("Could not get embedded service-def for " + this.serviceType));
            }
        }
        return ret;
    }

    private ServicePolicies getDefaultSvcPolicies() {
        ServicePolicies ret = null;
        RangerServiceDef serviceDef = this.getServiceDef();
        if (serviceDef == null) {
            serviceDef = this.getDefaultServiceDef();
        }
        if (serviceDef != null) {
            ret = new ServicePolicies();
            ret.setServiceDef(serviceDef);
            ret.setServiceName(this.serviceName);
            ret.setPolicies(new ArrayList<RangerPolicy>());
        }
        return ret;
    }

    public boolean logErrorMessage(String message) {
        LogHistory log = this.logHistoryList.get(message);
        if (log == null) {
            log = new LogHistory();
            this.logHistoryList.put(message, log);
        }
        if (System.currentTimeMillis() - log.lastLogTime > (long)this.logInterval) {
            log.lastLogTime = System.currentTimeMillis();
            int counter = log.counter;
            log.counter = 0;
            if (counter > 0) {
                message = message + ". Messages suppressed before: " + counter;
            }
            LOG.error((Object)message);
            return true;
        }
        ++log.counter;
        return false;
    }

    private static final class PolicyEngineRefresher
    extends TimerTask {
        private final RangerBasePlugin plugin;

        PolicyEngineRefresher(RangerBasePlugin plugin) {
            this.plugin = plugin;
        }

        @Override
        public void run() {
            RangerPolicyEngine policyEngine = this.plugin.policyEngine;
            if (policyEngine != null) {
                policyEngine.reorderPolicyEvaluators();
            }
        }
    }

    static class LogHistory {
        long lastLogTime;
        int counter;

        LogHistory() {
        }
    }
}

