/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyevaluator;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.CacheMap;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyevaluator.RangerResourceAccessCache;

public class RangerResourceAccessCacheImpl
implements RangerResourceAccessCache {
    private static final Log LOG = LogFactory.getLog(RangerResourceAccessCacheImpl.class);
    private Map<String, String> matchedResourceCache;
    private Map<String, String> notMatchedResourceCache;

    public static synchronized RangerResourceAccessCache getInstance(RangerServiceDef serviceDef, RangerPolicy policy) {
        return new RangerResourceAccessCacheImpl(policy);
    }

    private RangerResourceAccessCacheImpl(RangerPolicy policy) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerResourceAccessCacheImpl.constructor(), policyName:" + policy.getName()));
        }
        int matchedCacheSize = RangerConfiguration.getInstance().getInt("ranger.policyengine.matched.cached.count", 1000);
        int notMatchedCacheSize = RangerConfiguration.getInstance().getInt("ranger.policyengine.not.matched.cached.count", matchedCacheSize * 10);
        this.matchedResourceCache = new CacheMap<String, String>(matchedCacheSize);
        this.notMatchedResourceCache = new CacheMap<String, String>(notMatchedCacheSize);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerResourceAccessCacheImpl.constructor(), policyName:" + policy.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RangerResourceAccessCache.LookupResult lookup(RangerAccessResource resource) {
        String strResource = resource.getCacheKey();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerResourceAccessCacheImpl.lookup(" + strResource + ")"));
        }
        RangerResourceAccessCache.LookupResult result = RangerResourceAccessCache.LookupResult.NOT_FOUND;
        try {
            RangerResourceAccessCacheImpl rangerResourceAccessCacheImpl = this;
            synchronized (rangerResourceAccessCacheImpl) {
                if (this.matchedResourceCache.containsKey(strResource)) {
                    result = RangerResourceAccessCache.LookupResult.IN_MATCHED_CACHE;
                } else if (this.notMatchedResourceCache.containsKey(strResource)) {
                    result = RangerResourceAccessCache.LookupResult.IN_NOTMATCHED_CACHE;
                }
            }
        }
        catch (Exception exception) {
            result = RangerResourceAccessCache.LookupResult.ERROR;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerResourceAccessCacheImpl.lookup(" + strResource + "): " + (Object)((Object)result)));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(RangerAccessResource resource, RangerResourceAccessCache.CacheType cacheType) {
        String strResource = resource.getCacheKey();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerResourceAccessCacheImpl.add(" + strResource + ", " + (Object)((Object)cacheType) + ")"));
        }
        RangerResourceAccessCacheImpl rangerResourceAccessCacheImpl = this;
        synchronized (rangerResourceAccessCacheImpl) {
            switch (cacheType) {
                case MATCHED_CACHE: {
                    this.matchedResourceCache.put(strResource, strResource);
                    break;
                }
                case NOTMATCHED_CACHE: {
                    this.notMatchedResourceCache.put(strResource, strResource);
                    break;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerResourceAccessCacheImpl.add(" + strResource + ", " + (Object)((Object)cacheType) + ")"));
        }
    }
}

