/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.policyengine.RangerResourceACLs;
import org.apache.ranger.plugin.policyengine.RangerResourceAccessInfo;
import org.apache.ranger.plugin.util.GrantRevokeRequest;
import org.apache.ranger.plugin.util.RangerRoles;

public interface RangerPolicyEngine {
    public static final String GROUP_PUBLIC = "public";
    public static final String ANY_ACCESS = "_any";
    public static final String ADMIN_ACCESS = "_admin";
    public static final String AUDIT_ALL = "audit-all";
    public static final String AUDIT_NONE = "audit-none";
    public static final String AUDIT_DEFAULT = "audit-default";
    public static final String PLUGIN_AUDIT_EXCLUDE_USERS = "ranger.plugin.audit.exclude.users";
    public static final String PLUGIN_AUDIT_EXCLUDE_GROUPS = "ranger.plugin.audit.exclude.groups";
    public static final String PLUGIN_AUDIT_EXCLUDE_ROLES = "ranger.plugin.audit.exclude.roles";
    public static final String PLUGIN_SUPER_USERS = "ranger.plugin.super.users";
    public static final String PLUGIN_SUPER_GROUPS = "ranger.plugin.super.groups";
    public static final String USER_CURRENT = "{USER}";
    public static final String RESOURCE_OWNER = "{OWNER}";

    public void setUseForwardedIPAddress(boolean var1);

    public void setTrustedProxyAddresses(String[] var1);

    public RangerServiceDef getServiceDef();

    public long getPolicyVersion();

    public long getRoleVersion();

    public void setRoles(RangerRoles var1);

    public RangerAccessResult evaluatePolicies(RangerAccessRequest var1, int var2, RangerAccessResultProcessor var3);

    public Collection<RangerAccessResult> evaluatePolicies(Collection<RangerAccessRequest> var1, int var2, RangerAccessResultProcessor var3);

    public RangerResourceACLs getResourceACLs(RangerAccessRequest var1);

    public Set<String> getRolesFromUserAndGroups(String var1, Set<String> var2);

    public String getUniquelyMatchedZoneName(GrantRevokeRequest var1);

    public List<RangerPolicy> getResourcePolicies(String var1);

    public List<RangerPolicy> getResourcePolicies();

    public List<RangerPolicy> getTagPolicies();

    public RangerResourceAccessInfo getResourceAccessInfo(RangerAccessRequest var1);
}

