/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.conditionevaluator;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.classloader.RangerPluginClassLoader;
import org.apache.ranger.plugin.conditionevaluator.RangerAbstractConditionEvaluator;
import org.apache.ranger.plugin.conditionevaluator.RangerScriptExecutionContext;
import org.apache.ranger.plugin.contextenricher.RangerTagForEval;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.util.RangerPerfTracer;

public class RangerScriptConditionEvaluator
extends RangerAbstractConditionEvaluator {
    private static final Log LOG = LogFactory.getLog(RangerScriptConditionEvaluator.class);
    private static final Log PERF_POLICY_CONDITION_SCRIPT_EVAL = RangerPerfTracer.getPerfLogger("policy.condition.script.eval");
    private static final String SCRIPT_PREEXEC = "_ctx=JSON.parse(_ctx_json);";
    private ScriptEngine scriptEngine;
    private boolean enableJsonCtx = false;

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerScriptConditionEvaluator.init(" + this.condition + ")"));
        }
        super.init();
        String engineName = "JavaScript";
        Map<String, String> evalOptions = this.conditionDef.getEvaluatorOptions();
        if (MapUtils.isNotEmpty(evalOptions)) {
            engineName = evalOptions.get("engineName");
            this.enableJsonCtx = Boolean.parseBoolean(evalOptions.getOrDefault("enableJsonCtx", Boolean.toString(this.enableJsonCtx)));
        }
        if (StringUtils.isBlank((String)engineName)) {
            engineName = "JavaScript";
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("RangerScriptConditionEvaluator.init() - engineName=" + engineName));
        }
        String conditionType = this.condition != null ? this.condition.getType() : null;
        try {
            ScriptEngineManager manager = new ScriptEngineManager();
            if (LOG.isDebugEnabled()) {
                List<ScriptEngineFactory> factories = manager.getEngineFactories();
                if (CollectionUtils.isEmpty(factories)) {
                    LOG.debug((Object)"List of scriptEngineFactories is empty!!");
                } else {
                    for (ScriptEngineFactory factory : factories) {
                        LOG.debug((Object)("engineName=" + factory.getEngineName() + ", language=" + factory.getLanguageName()));
                    }
                }
            }
            this.scriptEngine = manager.getEngineByName(engineName);
        }
        catch (Exception exp) {
            LOG.error((Object)("RangerScriptConditionEvaluator.init() failed with exception=" + exp));
        }
        if (this.scriptEngine == null) {
            LOG.warn((Object)("failed to initialize condition '" + conditionType + "': script engine '" + engineName + "' was not created in a default manner"));
            LOG.info((Object)"Will try to get script-engine from plugin-class-loader");
            try {
                RangerPluginClassLoader pluginClassLoader = RangerPluginClassLoader.getInstance((String)this.serviceDef.getName(), null);
                if (pluginClassLoader != null) {
                    this.scriptEngine = pluginClassLoader.getScriptEngine(engineName);
                } else {
                    LOG.error((Object)"Cannot get script-engine from null pluginClassLoader");
                }
            }
            catch (Throwable exp) {
                LOG.error((Object)"RangerScriptConditionEvaluator.init() failed with exception=", exp);
            }
        }
        if (this.scriptEngine == null) {
            LOG.error((Object)("failed to initialize condition '" + conditionType + "': script engine '" + engineName + "' was not created"));
        } else {
            LOG.info((Object)("ScriptEngine for engineName=[" + engineName + "] is successfully created"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerScriptConditionEvaluator.init(" + this.condition + ")"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean isMatched(RangerAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerScriptConditionEvaluator.isMatched()");
        }
        boolean result = true;
        if (this.scriptEngine != null) {
            String script = this.getScript();
            if (StringUtils.isNotBlank((String)script)) {
                RangerAccessRequest readOnlyRequest = request.getReadOnlyCopy();
                RangerScriptExecutionContext context = new RangerScriptExecutionContext(readOnlyRequest);
                RangerTagForEval currentTag = context.getCurrentTag();
                Map<Object, Object> tagAttribs = currentTag != null ? currentTag.getAttributes() : Collections.emptyMap();
                Bindings bindings = this.scriptEngine.createBindings();
                bindings.put("ctx", (Object)context);
                bindings.put("tag", (Object)currentTag);
                bindings.put("tagAttr", (Object)tagAttribs);
                if (this.enableJsonCtx) {
                    bindings.put("_ctx_json", (Object)context.toJson());
                    script = SCRIPT_PREEXEC + script;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("RangerScriptConditionEvaluator.isMatched(): script={" + script + "}"));
                }
                RangerPerfTracer perf = null;
                try {
                    Object ret;
                    long requestHash = request.hashCode();
                    if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICY_CONDITION_SCRIPT_EVAL)) {
                        perf = RangerPerfTracer.getPerfTracer(PERF_POLICY_CONDITION_SCRIPT_EVAL, "RangerScriptConditionEvaluator.isMatched(requestHash=" + requestHash + ")");
                    }
                    if ((ret = this.scriptEngine.eval(script, bindings)) == null) {
                        ret = context.getResult();
                    }
                    if (ret instanceof Boolean) {
                        result = (Boolean)ret;
                    }
                    RangerPerfTracer.log(perf);
                }
                catch (NullPointerException nullp) {
                    LOG.error((Object)"RangerScriptConditionEvaluator.isMatched(): eval called with NULL argument(s)", (Throwable)nullp);
                }
                catch (ScriptException exception) {
                    LOG.error((Object)("RangerScriptConditionEvaluator.isMatched(): failed to evaluate script, exception=" + exception));
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    RangerPerfTracer.log(perf);
                }
            } else {
                String conditionType = this.condition != null ? this.condition.getType() : null;
                LOG.error((Object)("failed to evaluate condition '" + conditionType + "': script is empty"));
            }
        } else {
            String conditionType = this.condition != null ? this.condition.getType() : null;
            LOG.error((Object)("failed to evaluate condition '" + conditionType + "': script engine not found"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerScriptConditionEvaluator.isMatched(), result=" + result));
        }
        return result;
    }

    protected String getScript() {
        String value;
        String ret = null;
        List<String> values = this.condition.getValues();
        if (CollectionUtils.isNotEmpty(values) && StringUtils.isNotBlank((String)(value = values.get(0)))) {
            ret = value.trim();
        }
        return ret;
    }
}

