/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.geo;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.geo.BinarySearchTree;
import org.apache.ranger.plugin.geo.GeolocationMetadata;
import org.apache.ranger.plugin.geo.RangerGeolocationData;
import org.apache.ranger.plugin.geo.ValuePrinter;

public class RangerGeolocationDatabase {
    private static final Log LOG = LogFactory.getLog(RangerGeolocationDatabase.class);
    private BinarySearchTree<RangerGeolocationData, Long> data = new BinarySearchTree();
    private GeolocationMetadata metadata = new GeolocationMetadata();

    public String getValue(RangerGeolocationData geolocationData, String attributeName) {
        String value = null;
        int index = -1;
        if (geolocationData != null && StringUtils.isNotBlank((String)attributeName)) {
            index = this.getMetadata().getDataItemNameIndex(attributeName);
            if (index != -1) {
                String[] attrValues = geolocationData.getLocationData();
                if (index < attrValues.length) {
                    value = attrValues[index];
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("RangerGeolocationDatabase.getValue() - No value specified attribute-name:" + attributeName));
                }
            } else {
                LOG.error((Object)("RangerGeolocationDatabase.getValue() - RangerGeolocationDatabase not initialized or Invalid attribute-name:" + attributeName));
            }
        }
        return value;
    }

    public RangerGeolocationData find(String ipAddressStr) {
        RangerGeolocationData ret = null;
        if (StringUtils.isNotBlank((String)ipAddressStr) && RangerGeolocationData.validateAsIP(ipAddressStr, true)) {
            ret = this.data.find(RangerGeolocationData.ipAddressToLong(ipAddressStr));
        }
        return ret;
    }

    public void optimize() {
        long start = 0L;
        long end = 0L;
        start = System.currentTimeMillis();
        this.data.rebalance();
        end = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("RangerGeolocationDatabase.optimize() - Time taken for optimizing database = " + (end - start) + " milliseconds"));
        }
    }

    public void setData(BinarySearchTree<RangerGeolocationData, Long> dataArg) {
        this.data = dataArg != null ? dataArg : new BinarySearchTree();
    }

    public void setMetadata(GeolocationMetadata metadataArg) {
        this.metadata = metadataArg != null ? metadataArg : new GeolocationMetadata();
    }

    public GeolocationMetadata getMetadata() {
        return this.metadata;
    }

    public BinarySearchTree<RangerGeolocationData, Long> getData() {
        return this.data;
    }

    public void dump(ValuePrinter<RangerGeolocationData> processor) {
        BinarySearchTree<RangerGeolocationData, Long> geoDatabase = this.getData();
        GeolocationMetadata metadata = this.getMetadata();
        processor.build();
        processor.print("#================== Geolocation metadata ==================");
        processor.print(metadata.toString());
        processor.print("#================== Dump of geoDatabase - START ==================");
        geoDatabase.preOrderTraverseTree(processor);
        processor.print("#================== Dump of geoDatabase - END   ==================");
        processor.close();
    }
}

