/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.resourcematcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.resourcematcher.CaseInsensitiveStringMatcher;
import org.apache.ranger.plugin.resourcematcher.RangerDefaultResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.ResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.ResourceMatcherWrapper;
import org.apache.ranger.plugin.util.ServiceDefUtil;

public class RangerPathResourceMatcher
extends RangerDefaultResourceMatcher {
    private static final Log LOG = LogFactory.getLog(RangerPathResourceMatcher.class);
    public static final String OPTION_PATH_SEPARATOR = "pathSeparatorChar";
    public static final char DEFAULT_PATH_SEPARATOR_CHAR = '/';
    private boolean policyIsRecursive;
    private Character pathSeparatorChar = Character.valueOf('/');

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerPathResourceMatcher.init()");
        }
        Map<String, String> options = this.resourceDef == null ? null : this.resourceDef.getMatcherOptions();
        this.policyIsRecursive = this.policyResource != null && this.policyResource.getIsRecursive() != false;
        this.pathSeparatorChar = Character.valueOf(ServiceDefUtil.getCharOption(options, OPTION_PATH_SEPARATOR, '/'));
        super.init();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerPathResourceMatcher.init()");
        }
    }

    @Override
    protected ResourceMatcherWrapper buildResourceMatchers() {
        ArrayList<ResourceMatcher> resourceMatchers = new ArrayList<ResourceMatcher>();
        boolean needsDynamicEval = false;
        for (String policyValue : this.policyValues) {
            ResourceMatcher matcher;
            if (this.optWildCard && this.policyIsRecursive && policyValue.charAt(policyValue.length() - 1) == this.pathSeparatorChar.charValue()) {
                policyValue = policyValue + "*";
            }
            if ((matcher = this.getMatcher(policyValue)) == null) continue;
            if (matcher.isMatchAny()) {
                resourceMatchers.clear();
                break;
            }
            if (!needsDynamicEval && matcher.getNeedsDynamicEval()) {
                needsDynamicEval = true;
            }
            resourceMatchers.add(matcher);
        }
        Collections.sort(resourceMatchers, new ResourceMatcher.PriorityComparator());
        return CollectionUtils.isNotEmpty(resourceMatchers) ? new ResourceMatcherWrapper(needsDynamicEval, resourceMatchers) : null;
    }

    @Override
    ResourceMatcher getMatcher(String policyValue) {
        int len;
        if (!this.policyIsRecursive) {
            return this.getPathMatcher(policyValue);
        }
        int n = len = policyValue != null ? policyValue.length() : 0;
        if (len == 0) {
            return null;
        }
        if (this.optWildCard && "*".equals(policyValue)) {
            return new CaseInsensitiveStringMatcher("");
        }
        boolean isWildcardPresent = false;
        if (this.optWildCard) {
            for (int i = 0; i < len; ++i) {
                char c = policyValue.charAt(i);
                if (c != '?' && c != '*') continue;
                isWildcardPresent = true;
                break;
            }
        }
        PathResourceMatcher ret = isWildcardPresent ? new RecursiveWildcardResourceMatcher(policyValue, this.pathSeparatorChar.charValue(), this.optIgnoreCase, RangerPathResourceMatcher::isRecursiveWildCardMatch, this.optIgnoreCase ? 8 : 7) : new RecursivePathResourceMatcher(policyValue, this.pathSeparatorChar.charValue(), this.optIgnoreCase ? StringUtils::equalsIgnoreCase : StringUtils::equals, this.optIgnoreCase ? StringUtils::startsWithIgnoreCase : StringUtils::startsWith, this.optIgnoreCase ? 8 : 7);
        if (this.optReplaceTokens) {
            ret.setDelimiters(this.startDelimiterChar, this.endDelimiterChar, this.escapeChar, this.tokenPrefix);
        }
        return ret;
    }

    static boolean isRecursiveWildCardMatch(String pathToCheck, String wildcardPath, Character pathSeparatorChar, IOCase caseSensitivity) {
        boolean ret = false;
        if (!StringUtils.isEmpty((String)pathToCheck)) {
            Object[] pathElements = StringUtils.split((String)pathToCheck, (char)pathSeparatorChar.charValue());
            if (!ArrayUtils.isEmpty((Object[])pathElements)) {
                StringBuilder sb = new StringBuilder();
                if (pathToCheck.charAt(0) == pathSeparatorChar.charValue()) {
                    sb.append(pathSeparatorChar);
                }
                for (Object p : pathElements) {
                    sb.append((String)p);
                    ret = FilenameUtils.wildcardMatch((String)sb.toString(), (String)wildcardPath, (IOCase)caseSensitivity);
                    if (ret) break;
                    sb.append(pathSeparatorChar);
                }
                sb = null;
            } else {
                ret = FilenameUtils.wildcardMatch((String)pathToCheck, (String)wildcardPath, (IOCase)caseSensitivity);
            }
        }
        return ret;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerPathResourceMatcher={");
        super.toString(sb);
        sb.append("policyIsRecursive={").append(this.policyIsRecursive).append("} ");
        sb.append("}");
        return sb;
    }

    private ResourceMatcher getPathMatcher(String policyValue) {
        PathResourceMatcher ret;
        int len;
        int n = len = policyValue != null ? policyValue.length() : 0;
        if (len == 0) {
            return null;
        }
        int wildcardStartIdx = -1;
        int wildcardEndIdx = -1;
        boolean needWildcardMatch = false;
        if (this.optWildCard) {
            for (int i = 0; i < len; ++i) {
                char c = policyValue.charAt(i);
                if (c == '?') {
                    needWildcardMatch = true;
                    break;
                }
                if (c != '*') continue;
                if (wildcardEndIdx == -1 || wildcardEndIdx == i - 1) {
                    wildcardEndIdx = i;
                    if (wildcardStartIdx != -1) continue;
                    wildcardStartIdx = i;
                    continue;
                }
                needWildcardMatch = true;
                break;
            }
        }
        if (needWildcardMatch) {
            ret = new WildcardResourceMatcher(policyValue, this.pathSeparatorChar.charValue(), this.optIgnoreCase, FilenameUtils::wildcardMatch, 6);
        } else if (wildcardStartIdx == -1) {
            ret = new StringResourceMatcher(policyValue, this.pathSeparatorChar.charValue(), this.optIgnoreCase ? StringUtils::equalsIgnoreCase : StringUtils::equals, this.optIgnoreCase ? 2 : 1);
        } else if (wildcardStartIdx == 0) {
            String matchStr = policyValue.substring(wildcardEndIdx + 1);
            ret = new StringResourceMatcher(matchStr, this.pathSeparatorChar.charValue(), this.optIgnoreCase ? StringUtils::endsWithIgnoreCase : StringUtils::endsWith, this.optIgnoreCase ? 4 : 3);
        } else if (wildcardEndIdx != len - 1) {
            ret = new WildcardResourceMatcher(policyValue, this.pathSeparatorChar.charValue(), this.optIgnoreCase, FilenameUtils::wildcardMatch, 6);
        } else {
            String matchStr = policyValue.substring(0, wildcardStartIdx);
            ret = new StringResourceMatcher(matchStr, this.pathSeparatorChar.charValue(), this.optIgnoreCase ? StringUtils::startsWithIgnoreCase : StringUtils::startsWith, this.optIgnoreCase ? 4 : 3);
        }
        if (this.optReplaceTokens) {
            ret.setDelimiters(this.startDelimiterChar, this.endDelimiterChar, this.escapeChar, this.tokenPrefix);
        }
        return ret;
    }

    static class RecursivePathResourceMatcher
    extends PathResourceMatcher {
        String valueWithoutSeparator;
        String valueWithSeparator;
        final BiFunction<String, String, Boolean> primaryFunction;
        final BiFunction<String, String, Boolean> fallbackFunction;

        RecursivePathResourceMatcher(String value, char pathSeparatorChar, BiFunction<String, String, Boolean> primaryFunction, BiFunction<String, String, Boolean> fallbackFunction, int priority) {
            super(value, pathSeparatorChar, priority);
            this.primaryFunction = primaryFunction;
            this.fallbackFunction = fallbackFunction;
        }

        String getStringToCompare(String policyValue) {
            if (StringUtils.isEmpty((String)policyValue)) {
                return policyValue;
            }
            return policyValue.lastIndexOf(this.pathSeparatorChar) == policyValue.length() - 1 ? policyValue.substring(0, policyValue.length() - 1) : policyValue;
        }

        @Override
        boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
            String withSeparator;
            String noSeparator;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("==> RecursivePathResourceMatcher.isMatch(resourceValue=" + resourceValue + ", evalContext=" + evalContext + ")"));
            }
            if (this.getNeedsDynamicEval()) {
                String expandedPolicyValue = this.getExpandedValue(evalContext);
                noSeparator = expandedPolicyValue != null ? this.getStringToCompare(expandedPolicyValue) : null;
            } else {
                if (this.valueWithoutSeparator == null && this.value != null) {
                    this.valueWithoutSeparator = this.getStringToCompare(this.value);
                    this.valueWithSeparator = this.valueWithoutSeparator + this.pathSeparatorChar;
                }
                noSeparator = this.valueWithoutSeparator;
            }
            boolean ret = this.primaryFunction.apply(resourceValue, noSeparator);
            if (!ret && noSeparator != null && !(ret = this.fallbackFunction.apply(resourceValue, withSeparator = this.getNeedsDynamicEval() ? noSeparator + this.pathSeparatorChar : this.valueWithSeparator).booleanValue())) {
                int lastLevelSeparatorIndex;
                RangerAccessRequest.ResourceMatchingScope scope;
                RangerAccessRequest.ResourceMatchingScope resourceMatchingScope = scope = MapUtils.isNotEmpty(evalContext) ? (RangerAccessRequest.ResourceMatchingScope)((Object)evalContext.get("Scope")) : null;
                if (scope == RangerAccessRequest.ResourceMatchingScope.SELF_OR_CHILD && (lastLevelSeparatorIndex = noSeparator.lastIndexOf(this.pathSeparatorChar)) != -1) {
                    String shorterExpandedValue = noSeparator.substring(0, lastLevelSeparatorIndex);
                    if (resourceValue.charAt(resourceValue.length() - 1) == this.pathSeparatorChar) {
                        resourceValue = resourceValue.substring(0, resourceValue.length() - 1);
                    }
                    ret = this.primaryFunction.apply(resourceValue, shorterExpandedValue);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("<== RecursivePathResourceMatcher.isMatch(resourceValue=" + resourceValue + ", expandedValueWithoutTrailingSeparatorChar=" + noSeparator + ") : result:[" + ret + "]"));
            }
            return ret;
        }
    }

    static class RecursiveWildcardResourceMatcher
    extends PathResourceMatcher {
        final QuadFunction<String, String, Character, IOCase, Boolean> function;
        final IOCase ioCase;

        RecursiveWildcardResourceMatcher(String value, char pathSeparatorChar, boolean optIgnoreCase, QuadFunction<String, String, Character, IOCase, Boolean> function, int priority) {
            super(value, pathSeparatorChar, priority);
            this.function = function;
            this.ioCase = optIgnoreCase ? IOCase.INSENSITIVE : IOCase.SENSITIVE;
        }

        @Override
        boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
            String expandedValue;
            boolean ret;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("==> RecursiveWildcardResourceMatcher.isMatch(resourceValue=" + resourceValue + ", evalContext=" + evalContext + ")"));
            }
            if (!(ret = this.function.apply(resourceValue, expandedValue = this.getExpandedValue(evalContext), Character.valueOf(this.pathSeparatorChar), this.ioCase).booleanValue())) {
                int lastLevelSeparatorIndex;
                RangerAccessRequest.ResourceMatchingScope scope;
                RangerAccessRequest.ResourceMatchingScope resourceMatchingScope = scope = MapUtils.isNotEmpty(evalContext) ? (RangerAccessRequest.ResourceMatchingScope)((Object)evalContext.get("Scope")) : null;
                if (scope == RangerAccessRequest.ResourceMatchingScope.SELF_OR_CHILD && (lastLevelSeparatorIndex = expandedValue.lastIndexOf(this.pathSeparatorChar)) != -1) {
                    String shorterExpandedValue = expandedValue.substring(0, lastLevelSeparatorIndex);
                    if (resourceValue.charAt(resourceValue.length() - 1) == this.pathSeparatorChar) {
                        resourceValue = resourceValue.substring(0, resourceValue.length() - 1);
                    }
                    ret = this.function.apply(resourceValue, shorterExpandedValue, Character.valueOf(this.pathSeparatorChar), this.ioCase);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("<== RecursiveWildcardResourceMatcher.isMatch(resourceValue=" + resourceValue + ", expandedValue=" + expandedValue + ") : result:[" + ret + "]"));
            }
            return ret;
        }
    }

    static class WildcardResourceMatcher
    extends PathResourceMatcher {
        final TriFunction<String, String, IOCase, Boolean> function;
        final IOCase ioCase;

        WildcardResourceMatcher(String value, char pathSeparatorChar, boolean optIgnoreCase, TriFunction<String, String, IOCase, Boolean> function, int priority) {
            super(value, pathSeparatorChar, priority);
            this.function = function;
            this.ioCase = optIgnoreCase ? IOCase.INSENSITIVE : IOCase.SENSITIVE;
        }

        @Override
        boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
            String expandedValue;
            boolean ret;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("==> WildcardResourceMatcher.isMatch(resourceValue=" + resourceValue + ", evalContext=" + evalContext + ")"));
            }
            if (!(ret = this.function.apply(resourceValue, expandedValue = this.getExpandedValue(evalContext), this.ioCase).booleanValue())) {
                int lastLevelSeparatorIndex;
                RangerAccessRequest.ResourceMatchingScope scope;
                RangerAccessRequest.ResourceMatchingScope resourceMatchingScope = scope = MapUtils.isNotEmpty(evalContext) ? (RangerAccessRequest.ResourceMatchingScope)((Object)evalContext.get("Scope")) : null;
                if (scope == RangerAccessRequest.ResourceMatchingScope.SELF_OR_CHILD && (lastLevelSeparatorIndex = expandedValue.lastIndexOf(this.pathSeparatorChar)) != -1) {
                    String shorterExpandedValue = expandedValue.substring(0, lastLevelSeparatorIndex);
                    if (resourceValue.charAt(resourceValue.length() - 1) == this.pathSeparatorChar) {
                        resourceValue = resourceValue.substring(0, resourceValue.length() - 1);
                    }
                    ret = this.function.apply(resourceValue, shorterExpandedValue, this.ioCase);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("<== WildcardResourceMatcher.isMatch(resourceValue=" + resourceValue + ", expandedValue=" + expandedValue + ") : result:[" + ret + "]"));
            }
            return ret;
        }
    }

    static class StringResourceMatcher
    extends PathResourceMatcher {
        final BiFunction<String, String, Boolean> function;

        StringResourceMatcher(String value, char pathSeparatorChar, BiFunction<String, String, Boolean> function, int priority) {
            super(value, pathSeparatorChar, priority);
            this.function = function;
        }

        @Override
        boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
            String expandedValue;
            boolean ret;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("==> StringResourceMatcher.isMatch(resourceValue=" + resourceValue + ", evalContext=" + evalContext + ")"));
            }
            if (!(ret = this.function.apply(resourceValue, expandedValue = this.getExpandedValue(evalContext)).booleanValue())) {
                int lastLevelSeparatorIndex;
                RangerAccessRequest.ResourceMatchingScope scope;
                RangerAccessRequest.ResourceMatchingScope resourceMatchingScope = scope = MapUtils.isNotEmpty(evalContext) ? (RangerAccessRequest.ResourceMatchingScope)((Object)evalContext.get("Scope")) : null;
                if (scope == RangerAccessRequest.ResourceMatchingScope.SELF_OR_CHILD && (lastLevelSeparatorIndex = expandedValue.lastIndexOf(this.pathSeparatorChar)) != -1) {
                    String shorterExpandedValue = expandedValue.substring(0, lastLevelSeparatorIndex);
                    if (resourceValue.charAt(resourceValue.length() - 1) == this.pathSeparatorChar) {
                        resourceValue = resourceValue.substring(0, resourceValue.length() - 1);
                    }
                    ret = this.function.apply(resourceValue, shorterExpandedValue);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("<== StringResourceMatcher.isMatch(resourceValue=" + resourceValue + ", expandedValue=" + expandedValue + ") : result:[" + ret + "]"));
            }
            return ret;
        }
    }

    static abstract class PathResourceMatcher
    extends ResourceMatcher {
        final char pathSeparatorChar;
        final int priority;

        PathResourceMatcher(String value, char pathSeparatorChar, int priority) {
            super(value);
            this.pathSeparatorChar = pathSeparatorChar;
            this.priority = priority;
        }

        @Override
        int getPriority() {
            return this.priority + (this.getNeedsDynamicEval() ? 8 : 0);
        }
    }

    static interface QuadFunction<T, U, V, W, R> {
        public R apply(T var1, U var2, V var3, W var4);
    }

    static interface TriFunction<T, U, V, R> {
        public R apply(T var1, U var2, V var3);
    }
}

