/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model.util;

import java.util.List;
import org.apache.rave.persistence.BasicEntity;

public class SearchResult<T extends BasicEntity> {
    private List<T> resultSet;
    private int pageSize;
    private int totalResults;

    public SearchResult(List<T> resultset, int totalResults) {
        this.resultSet = resultset;
        this.totalResults = totalResults;
    }

    public List<T> getResultSet() {
        return this.resultSet;
    }

    public int getTotalResults() {
        return this.totalResults;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getNumberOfPages() {
        if (this.pageSize == 0) {
            return 0;
        }
        int numberOfPages = this.totalResults / this.pageSize;
        if (this.totalResults % this.pageSize > 0) {
            ++numberOfPages;
        }
        return numberOfPages;
    }
}

