/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.repository.impl;

import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.commons.lang.StringUtils;
import org.apache.rave.persistence.jpa.AbstractJpaRepository;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.Widget;
import org.apache.rave.portal.model.WidgetStatus;
import org.apache.rave.portal.repository.WidgetRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class JpaWidgetRepository
extends AbstractJpaRepository<Widget>
implements WidgetRepository {
    private final Logger log = LoggerFactory.getLogger(JpaWidgetRepository.class);

    public JpaWidgetRepository() {
        super(Widget.class);
    }

    @Override
    public List<Widget> getAll() {
        this.log.warn("Requesting potentially large resultset of Widget. No pagesize set.");
        TypedQuery query = this.manager.createNamedQuery("Widget.getAll", Widget.class);
        return query.getResultList();
    }

    @Override
    public List<Widget> getLimitedList(int offset, int pageSize) {
        TypedQuery query = this.manager.createNamedQuery("Widget.getAll", Widget.class);
        return JpaUtil.getPagedResultList((TypedQuery)query, (int)offset, (int)pageSize);
    }

    @Override
    public int getCountAll() {
        Query query = this.manager.createNamedQuery("Widget.countAll");
        Number countResult = (Number)query.getSingleResult();
        return countResult.intValue();
    }

    @Override
    public List<Widget> getByFreeTextSearch(String searchTerm, int offset, int pageSize) {
        TypedQuery query = this.manager.createNamedQuery("Widget.getByFreeText", Widget.class);
        this.setFreeTextSearchTerm((Query)query, searchTerm);
        return JpaUtil.getPagedResultList((TypedQuery)query, (int)offset, (int)pageSize);
    }

    @Override
    public int getCountFreeTextSearch(String searchTerm) {
        Query query = this.manager.createNamedQuery("Widget.countByFreeText");
        this.setFreeTextSearchTerm(query, searchTerm);
        Number countResult = (Number)query.getSingleResult();
        return countResult.intValue();
    }

    @Override
    public List<Widget> getByStatus(WidgetStatus widgetStatus, int offset, int pageSize) {
        TypedQuery query = this.manager.createNamedQuery("Widget.getByStatus", Widget.class);
        query.setParameter("widgetStatus", (Object)widgetStatus);
        return JpaUtil.getPagedResultList((TypedQuery)query, (int)offset, (int)pageSize);
    }

    @Override
    public int getCountByStatus(WidgetStatus widgetStatus) {
        Query query = this.manager.createNamedQuery("Widget.countByStatus");
        query.setParameter("widgetStatus", (Object)widgetStatus);
        Number countResult = (Number)query.getSingleResult();
        return countResult.intValue();
    }

    @Override
    public List<Widget> getByStatusAndFreeTextSearch(WidgetStatus widgetStatus, String searchTerm, int offset, int pageSize) {
        TypedQuery query = this.manager.createNamedQuery("Widget.getByStatusAndFreeText", Widget.class);
        query.setParameter("widgetStatus", (Object)widgetStatus);
        this.setFreeTextSearchTerm((Query)query, searchTerm);
        return JpaUtil.getPagedResultList((TypedQuery)query, (int)offset, (int)pageSize);
    }

    @Override
    public int getCountByStatusAndFreeText(WidgetStatus widgetStatus, String searchTerm) {
        Query query = this.manager.createNamedQuery("Widget.countByStatusAndFreeText");
        query.setParameter("widgetStatus", (Object)widgetStatus);
        this.setFreeTextSearchTerm(query, searchTerm);
        Number countResult = (Number)query.getSingleResult();
        return countResult.intValue();
    }

    @Override
    public Widget getByUrl(String widgetUrl) {
        if (StringUtils.isBlank((String)widgetUrl)) {
            throw new IllegalArgumentException("Widget URL must not be empty");
        }
        TypedQuery query = this.manager.createNamedQuery("Widget.getByUrl", Widget.class);
        query.setParameter("url", (Object)widgetUrl);
        List resultList = query.getResultList();
        return (Widget)JpaUtil.getSingleResult((List)resultList);
    }

    protected void setFreeTextSearchTerm(Query query, String searchTerm) {
        query.setParameter("searchTerm", (Object)("%" + searchTerm.toLowerCase() + "%"));
    }
}

