/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.service.impl;

import org.apache.rave.portal.model.NewUser;
import org.apache.rave.portal.model.User;
import org.apache.rave.portal.service.NewAccountService;
import org.apache.rave.portal.service.PageLayoutService;
import org.apache.rave.portal.service.PageService;
import org.apache.rave.portal.service.RegionService;
import org.apache.rave.portal.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.dao.SaltSource;
import org.springframework.security.authentication.encoding.PasswordEncoder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

@Service
public class DefaultNewAccountService
implements NewAccountService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final UserService userService;
    private final PageService pageService;
    private final PageLayoutService pageLayoutService;
    private final RegionService regionService;
    @Autowired
    private SaltSource saltSource;
    @Autowired
    private PasswordEncoder passwordEncoder;

    @Autowired
    public DefaultNewAccountService(UserService userService, PageService pageService, PageLayoutService pageLayoutService, RegionService regionService) {
        this.userService = userService;
        this.pageService = pageService;
        this.pageLayoutService = pageLayoutService;
        this.regionService = regionService;
    }

    @Override
    public void createNewAccount(NewUser newUser) throws Exception {
        String userName = newUser.getUsername();
        String password = newUser.getPassword();
        String userPageLayout = newUser.getPageLayout();
        String email = newUser.getEmail();
        this.throwExceptionIfUserExists(userName, email);
        User user = new User();
        user.setUsername(userName);
        user.setEmail(email);
        String saltedHashedPassword = this.passwordEncoder.encodePassword(password, this.saltSource.getSalt((UserDetails)user));
        this.logger.debug("Salt Source: {}", this.saltSource.getSalt((UserDetails)user));
        user.setPassword(saltedHashedPassword);
        user.setExpired(false);
        user.setLocked(false);
        user.setEnabled(true);
        this.userService.registerNewUser(user);
        this.pageService.addNewDefaultPage(this.userService.getUserByUsername(user.getUsername()), userPageLayout);
    }

    private void throwExceptionIfUserExists(String userName, String email) {
        User existingUser = this.userService.getUserByUsername(userName);
        if (existingUser != null) {
            throw new IllegalArgumentException("A user already exists for username " + userName);
        }
        existingUser = this.userService.getUserByEmail(email);
        if (existingUser != null) {
            throw new IllegalArgumentException("A user already exists for email " + email);
        }
    }
}

