/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.rave.persistence.Repository;
import org.apache.rave.portal.model.Page;
import org.apache.rave.portal.model.PageLayout;
import org.apache.rave.portal.model.Region;
import org.apache.rave.portal.model.RegionWidget;
import org.apache.rave.portal.model.User;
import org.apache.rave.portal.model.Widget;
import org.apache.rave.portal.repository.PageLayoutRepository;
import org.apache.rave.portal.repository.PageRepository;
import org.apache.rave.portal.repository.RegionRepository;
import org.apache.rave.portal.repository.RegionWidgetRepository;
import org.apache.rave.portal.repository.WidgetRepository;
import org.apache.rave.portal.service.PageService;
import org.apache.rave.portal.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultPageService
implements PageService {
    private final PageRepository pageRepository;
    private final RegionRepository regionRepository;
    private final RegionWidgetRepository regionWidgetRepository;
    private final WidgetRepository widgetRepository;
    private final PageLayoutRepository pageLayoutRepository;
    private final UserService userService;
    private final String defaultPageName;
    private final long MOVE_PAGE_DEFAULT_POSITION_INDEX = -1L;

    @Autowired
    public DefaultPageService(PageRepository pageRepository, RegionRepository regionRepository, WidgetRepository widgetRepository, RegionWidgetRepository regionWidgetRepository, PageLayoutRepository pageLayoutRepository, UserService userService, @Value(value="${portal.page.default_name}") String defaultPageName) {
        this.pageRepository = pageRepository;
        this.regionRepository = regionRepository;
        this.regionWidgetRepository = regionWidgetRepository;
        this.widgetRepository = widgetRepository;
        this.pageLayoutRepository = pageLayoutRepository;
        this.userService = userService;
        this.defaultPageName = defaultPageName;
    }

    @Override
    public Page getPage(long pageId) {
        return (Page)this.pageRepository.get(pageId);
    }

    @Override
    public List<Page> getAllPages(long userId) {
        return this.pageRepository.getAllPages(userId);
    }

    @Override
    public Page getPageFromList(long pageId, List<Page> pages) {
        Page pageToFind = new Page(pageId);
        int index = pages.indexOf(pageToFind);
        return index == -1 ? null : pages.get(index);
    }

    @Override
    @Transactional
    public Page addNewPage(String pageName, String pageLayoutCode) {
        return this.addNewPage(this.userService.getAuthenticatedUser(), pageName, pageLayoutCode);
    }

    @Override
    @Transactional
    public Page addNewDefaultPage(User user, String pageLayoutCode) {
        return this.addNewPage(user, this.defaultPageName, pageLayoutCode);
    }

    @Override
    public String getDefaultPageName() {
        return this.defaultPageName;
    }

    @Override
    @Transactional
    public void deletePage(long pageId) {
        User user = this.userService.getAuthenticatedUser();
        this.pageRepository.delete(this.pageRepository.get(pageId));
        List<Page> pages = this.pageRepository.getAllPages(user.getEntityId());
        this.updatePageRenderSequences(pages);
    }

    @Override
    @Transactional
    public RegionWidget moveRegionWidget(long regionWidgetId, int newPosition, long toRegion, long fromRegion) {
        Region target = DefaultPageService.getFromRepository(toRegion, this.regionRepository);
        if (toRegion == fromRegion) {
            this.moveWithinRegion(regionWidgetId, newPosition, target);
        } else {
            this.moveBetweenRegions(regionWidgetId, newPosition, fromRegion, target);
        }
        target = (Region)this.regionRepository.save(target);
        return DefaultPageService.findRegionWidgetById(regionWidgetId, target.getRegionWidgets());
    }

    @Override
    @Transactional
    public Region removeWidgetFromPage(long regionWidgetId) {
        RegionWidget widget = DefaultPageService.getFromRepository(regionWidgetId, this.regionWidgetRepository);
        this.regionWidgetRepository.delete(widget);
        return DefaultPageService.getFromRepository(widget.getRegion().getEntityId(), this.regionRepository);
    }

    @Override
    @Transactional
    public RegionWidget addWidgetToPage(long pageId, long widgetId) {
        Page page = DefaultPageService.getFromRepository(pageId, this.pageRepository);
        Widget widget = DefaultPageService.getFromRepository(widgetId, this.widgetRepository);
        Region region = page.getRegions().get(0);
        return this.createWidgetInstance(widget, region, 0);
    }

    @Override
    @Transactional
    public Page movePage(long pageId, long moveAfterPageId) {
        return this.doMovePage(pageId, moveAfterPageId);
    }

    @Override
    @Transactional
    public Page movePageToDefault(long pageId) {
        return this.doMovePage(pageId, -1L);
    }

    @Override
    @Transactional
    public Page updatePage(long pageId, String name, String pageLayoutCode) {
        PageLayout curLayout;
        Page page = (Page)this.pageRepository.get(pageId);
        PageLayout newLayout = this.pageLayoutRepository.getByPageLayoutCode(pageLayoutCode);
        if (this.isLayoutAdjustmentNeeded(newLayout, curLayout = page.getPageLayout())) {
            if (curLayout.getNumberOfRegions() > newLayout.getNumberOfRegions()) {
                this.reduceRegionsForPage(page, newLayout.getNumberOfRegions());
            } else {
                long numberOfNewRegionsToAdd = newLayout.getNumberOfRegions() - curLayout.getNumberOfRegions();
                this.createAdditionalRegionsForPage(page, numberOfNewRegionsToAdd);
            }
        }
        page.setName(name);
        page.setPageLayout(newLayout);
        this.pageRepository.save(page);
        return page;
    }

    private boolean isLayoutAdjustmentNeeded(PageLayout newLayout, PageLayout curLayout) {
        return newLayout != null && !curLayout.equals(newLayout) && !curLayout.getNumberOfRegions().equals(newLayout.getNumberOfRegions());
    }

    private void createAdditionalRegionsForPage(Page page, long numberOfNewRegionsToAdd) {
        List<Region> regions = page.getRegions();
        int lastRegionRenderOrder = regions.get(regions.size() - 1).getRenderOrder() + 1;
        int i = 0;
        while ((long)i < numberOfNewRegionsToAdd) {
            Region newRegion = new Region();
            newRegion.setPage(page);
            newRegion.setRenderOrder(lastRegionRenderOrder++);
            regions.add(newRegion);
            ++i;
        }
    }

    private void reduceRegionsForPage(Page page, long numberOfRegionsInNewLayout) {
        List<Region> regions = page.getRegions();
        Region lastValidRegion = regions.get((int)(numberOfRegionsInNewLayout - 1L));
        while ((long)regions.size() > numberOfRegionsInNewLayout) {
            Region deletedRegion = regions.remove(regions.size() - 1);
            for (RegionWidget widget : deletedRegion.getRegionWidgets()) {
                this.moveRegionWidgetToNewRegion(widget, lastValidRegion);
            }
            this.regionRepository.delete(deletedRegion);
        }
        this.regionRepository.save(lastValidRegion);
    }

    private void moveRegionWidgetToNewRegion(RegionWidget regionWidget, Region moveToRegion) {
        List<RegionWidget> regionWidgets = moveToRegion.getRegionWidgets();
        int renderOrder = regionWidgets.isEmpty() ? 1 : regionWidgets.get(regionWidgets.size() - 1).getRenderOrder() + 1;
        regionWidget.setRegion(moveToRegion);
        regionWidget.setRenderOrder(renderOrder);
        moveToRegion.getRegionWidgets().add(regionWidget);
    }

    private RegionWidget createWidgetInstance(Widget widget, Region region, int position) {
        RegionWidget regionWidget = new RegionWidget();
        regionWidget.setRenderOrder(position);
        regionWidget.setWidget(widget);
        region.getRegionWidgets().add(position, regionWidget);
        DefaultPageService.updateRenderSequences(region.getRegionWidgets());
        Region persistedRegion = (Region)this.regionRepository.save(region);
        return persistedRegion.getRegionWidgets().get(position);
    }

    private void moveWithinRegion(long regionWidgetId, int newPosition, Region target) {
        this.replaceRegionWidget(regionWidgetId, newPosition, target, target);
        DefaultPageService.updateRenderSequences(target.getRegionWidgets());
    }

    private void moveBetweenRegions(long regionWidgetId, int newPosition, long fromRegion, Region target) {
        Region source = DefaultPageService.getFromRepository(fromRegion, this.regionRepository);
        this.replaceRegionWidget(regionWidgetId, newPosition, target, source);
        DefaultPageService.updateRenderSequences(source.getRegionWidgets());
        DefaultPageService.updateRenderSequences(target.getRegionWidgets());
        this.regionRepository.save(source);
    }

    private void replaceRegionWidget(long regionWidgetId, int newPosition, Region target, Region source) {
        RegionWidget widget = DefaultPageService.findRegionWidgetById(regionWidgetId, source.getRegionWidgets());
        source.getRegionWidgets().remove(widget);
        target.getRegionWidgets().add(newPosition, widget);
    }

    private Page addNewPage(User user, String pageName, String pageLayoutCode) {
        PageLayout pageLayout = this.pageLayoutRepository.getByPageLayoutCode(pageLayoutCode);
        ArrayList<Region> regions = new ArrayList<Region>();
        int regionCount = 0;
        while ((long)regionCount < pageLayout.getNumberOfRegions()) {
            Region region = new Region();
            region.setRenderOrder(regionCount);
            regions.add(region);
            ++regionCount;
        }
        long renderSequence = this.getAllPages(user.getEntityId()).size() + 1;
        Page page = new Page();
        page.setName(pageName);
        page.setOwner(user);
        page.setPageLayout(pageLayout);
        page.setRenderSequence(renderSequence);
        page.setRegions(regions);
        this.pageRepository.save(page);
        return page;
    }

    private void updatePageRenderSequences(List<Page> pages) {
        if (pages != null && !pages.isEmpty()) {
            for (int i = 0; i < pages.size(); ++i) {
                Page p = pages.get(i);
                p.setRenderSequence((long)i + 1L);
            }
            for (Page page : pages) {
                this.pageRepository.save(page);
            }
        }
    }

    private Page doMovePage(long pageId, long moveAfterPageId) {
        ArrayList<Page> pages;
        User user = this.userService.getAuthenticatedUser();
        Page movingPage = (Page)this.pageRepository.get(pageId);
        Page afterPage = null;
        int newIndex = 0;
        if (moveAfterPageId != -1L) {
            afterPage = (Page)this.pageRepository.get(moveAfterPageId);
        }
        if (!(pages = new ArrayList<Page>(this.pageRepository.getAllPages(user.getEntityId()))).remove(movingPage)) {
            throw new RuntimeException("unable to find pageId " + pageId + " attempted to be moved for user " + user);
        }
        if (afterPage != null) {
            newIndex = pages.indexOf(afterPage) + 1;
        }
        pages.add(newIndex, movingPage);
        this.updatePageRenderSequences(pages);
        return movingPage;
    }

    private static <T> T getFromRepository(long id, Repository<T> repo) {
        Object object = repo.get(id);
        if (object == null) {
            throw new IllegalArgumentException("Could not find object of given id in " + repo.getClass().getSimpleName());
        }
        return (T)object;
    }

    private static void updateRenderSequences(List<RegionWidget> regionWidgets) {
        int count = 0;
        for (RegionWidget widget : regionWidgets) {
            widget.setRenderOrder(count);
            ++count;
        }
    }

    private static RegionWidget findRegionWidgetById(Long id, List<RegionWidget> regionWidgets) {
        for (RegionWidget widget : regionWidgets) {
            if (!widget.getEntityId().equals(id)) continue;
            return widget;
        }
        throw new IllegalArgumentException("Invalid RegionWidget ID");
    }
}

