/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.service.impl;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.rave.portal.model.Widget;
import org.apache.rave.portal.model.WidgetStatus;
import org.apache.rave.portal.model.util.SearchResult;
import org.apache.rave.portal.repository.WidgetRepository;
import org.apache.rave.portal.service.WidgetService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultWidgetService
implements WidgetService {
    private static Logger logger = LoggerFactory.getLogger(DefaultWidgetService.class);
    private final WidgetRepository widgetRepository;

    @Autowired
    public DefaultWidgetService(WidgetRepository widgetRepository) {
        this.widgetRepository = widgetRepository;
    }

    @Override
    public SearchResult<Widget> getAllWidgets() {
        int count = this.widgetRepository.getCountAll();
        List<Widget> widgets = this.widgetRepository.getAll();
        return new SearchResult<Widget>(widgets, count);
    }

    @Override
    public SearchResult<Widget> getLimitedListOfWidgets(int offset, int pageSize) {
        int count = this.widgetRepository.getCountAll();
        List<Widget> widgets = this.widgetRepository.getLimitedList(offset, pageSize);
        SearchResult<Widget> searchResult = new SearchResult<Widget>(widgets, count);
        searchResult.setPageSize(pageSize);
        return searchResult;
    }

    @Override
    public SearchResult<Widget> getWidgetsByFreeTextSearch(String searchTerm, int offset, int pageSize) {
        if (StringUtils.isBlank((String)searchTerm)) {
            return this.getLimitedListOfWidgets(offset, pageSize);
        }
        int count = this.widgetRepository.getCountFreeTextSearch(searchTerm);
        List<Widget> widgets = this.widgetRepository.getByFreeTextSearch(searchTerm, offset, pageSize);
        SearchResult<Widget> searchResult = new SearchResult<Widget>(widgets, count);
        searchResult.setPageSize(pageSize);
        return searchResult;
    }

    @Override
    public Widget getWidget(long id) {
        return (Widget)this.widgetRepository.get(id);
    }

    @Override
    public SearchResult<Widget> getPublishedWidgets(int offset, int pageSize) {
        int count = this.widgetRepository.getCountByStatus(WidgetStatus.PUBLISHED);
        List<Widget> widgets = this.widgetRepository.getByStatus(WidgetStatus.PUBLISHED, offset, pageSize);
        SearchResult<Widget> searchResult = new SearchResult<Widget>(widgets, count);
        searchResult.setPageSize(pageSize);
        return searchResult;
    }

    @Override
    public SearchResult<Widget> getPublishedWidgetsByFreeTextSearch(String searchTerm, int offset, int pageSize) {
        if (StringUtils.isBlank((String)searchTerm)) {
            return this.getPublishedWidgets(offset, pageSize);
        }
        int count = this.widgetRepository.getCountByStatusAndFreeText(WidgetStatus.PUBLISHED, searchTerm);
        List<Widget> widgets = this.widgetRepository.getByStatusAndFreeTextSearch(WidgetStatus.PUBLISHED, searchTerm, offset, pageSize);
        SearchResult<Widget> searchResult = new SearchResult<Widget>(widgets, count);
        searchResult.setPageSize(pageSize);
        return searchResult;
    }

    @Override
    public Widget getWidgetByUrl(String widgetUrl) {
        return this.widgetRepository.getByUrl(widgetUrl);
    }

    @Override
    public Widget registerNewWidget(Widget widget) {
        if (this.getWidgetByUrl(widget.getUrl()) != null) {
            logger.debug("Trying to add an existing widget for url {}", (Object)widget.getUrl());
            return null;
        }
        return (Widget)this.widgetRepository.save(widget);
    }
}

