/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PreRemove;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;
import org.apache.rave.persistence.BasicEntity;
import org.apache.rave.portal.model.Authority;
import org.apache.rave.portal.model.PageLayout;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

@Entity
@Table(name="raveuser")
@NamedQueries(value={@NamedQuery(name="User.getByUsername", query="select u from User u where u.username = :username"), @NamedQuery(name="User.getByUserEmail", query="select u from User u where u.email = :email"), @NamedQuery(name="User.getAll", query="select u from User u order by u.username asc"), @NamedQuery(name="User.countAll", query="select count(u) from User u"), @NamedQuery(name="User.findByUsernameOrEmail", query="select u from User u where lower(u.username) like :searchTerm or lower(u.email) like :searchTerm order by u.username asc"), @NamedQuery(name="User.countFindByUsernameOrEmail", query="select count(u) from User u where lower(u.username) like :searchTerm or lower(u.email) like :searchTerm")})
public class User
implements UserDetails,
BasicEntity,
Serializable,
PersistenceCapable {
    private static final long serialVersionUID = 1L;
    public static final String USER_GET_BY_USERNAME = "User.getByUsername";
    public static final String USER_GET_BY_USER_EMAIL = "User.getByUserEmail";
    public static final String USER_GET_ALL = "User.getAll";
    public static final String USER_COUNT_ALL = "User.countAll";
    public static final String USER_FIND_BY_USERNAME_OR_EMAIL = "User.findByUsernameOrEmail";
    public static final String USER_COUNT_FIND_BY_USERNAME_OR_EMAIL = "User.countFindByUsernameOrEmail";
    public static final String PARAM_USERNAME = "username";
    public static final String PARAM_EMAIL = "email";
    public static final String PARAM_SEARCHTERM = "searchTerm";
    @Id
    @Column(name="entity_id")
    @GeneratedValue(strategy=GenerationType.TABLE, generator="raveuserIdGenerator")
    @TableGenerator(name="raveuserIdGenerator", table="RAVE_PORTAL_SEQUENCES", pkColumnName="SEQ_NAME", valueColumnName="SEQ_COUNT", pkColumnValue="raveuser", allocationSize=1, initialValue=1)
    private Long entityId;
    @Basic
    @Column(name="username", unique=true)
    private String username;
    @Basic
    @Column(name="password")
    private String password;
    @Basic
    @Column(name="expired")
    private boolean expired;
    @Basic
    @Column(name="locked")
    private boolean locked;
    @Basic
    @Column(name="enabled")
    private boolean enabled;
    @Basic
    @Column(name="email", unique=true)
    private String email;
    @Basic
    @Column(name="openid")
    private String openId;
    @ManyToOne
    @JoinColumn(name="default_page_layout_id")
    private PageLayout defaultPageLayout;
    @Transient
    private String confirmPassword;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="user_authorities", joinColumns={@JoinColumn(name="user_id", referencedColumnName="entity_id")}, inverseJoinColumns={@JoinColumn(name="authority_id", referencedColumnName="entity_id")})
    private Collection<Authority> authorities;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$util$Collection;
    static /* synthetic */ Class class$Lorg$apache$rave$portal$model$PageLayout;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$lang$Long;
    static /* synthetic */ Class class$Lorg$apache$rave$portal$model$User;
    private transient Object pcDetachedState;

    public User() {
        this(null, null);
    }

    public User(Long entityId) {
        this(entityId, null);
    }

    public User(Long entityId, String username) {
        this.entityId = entityId;
        this.username = username;
        this.authorities = new ArrayList<Authority>();
    }

    public Long getEntityId() {
        return User.pcGetentityId(this);
    }

    public void setEntityId(Long entityId) {
        User.pcSetentityId(this, entityId);
    }

    public Collection<GrantedAuthority> getAuthorities() {
        ArrayList<GrantedAuthority> grantedAuthorities = new ArrayList<GrantedAuthority>();
        grantedAuthorities.addAll(User.pcGetauthorities(this));
        return grantedAuthorities;
    }

    public void addAuthority(Authority authority) {
        if (!User.pcGetauthorities(this).contains(authority)) {
            User.pcGetauthorities(this).add(authority);
        }
        if (!authority.getUsers().contains(this)) {
            authority.addUser(this);
        }
    }

    public void removeAuthority(Authority authority) {
        if (User.pcGetauthorities(this).contains(authority)) {
            User.pcGetauthorities(this).remove(authority);
        }
    }

    public void setAuthorities(Collection<Authority> newAuthorities) {
        User.pcSetauthorities(this, newAuthorities);
    }

    public String getPassword() {
        return User.pcGetpassword(this);
    }

    public void setPassword(String password) {
        User.pcSetpassword(this, password);
    }

    public String getUsername() {
        return User.pcGetusername(this);
    }

    public void setUsername(String username) {
        User.pcSetusername(this, username);
    }

    public boolean isAccountNonLocked() {
        return !User.pcGetlocked(this);
    }

    public boolean isLocked() {
        return User.pcGetlocked(this);
    }

    public void setLocked(boolean locked) {
        User.pcSetlocked(this, locked);
    }

    public boolean isCredentialsNonExpired() {
        return !User.pcGetexpired(this);
    }

    public boolean isAccountNonExpired() {
        return this.isCredentialsNonExpired();
    }

    public boolean isExpired() {
        return User.pcGetexpired(this);
    }

    public void setExpired(boolean expired) {
        User.pcSetexpired(this, expired);
    }

    public boolean isEnabled() {
        return User.pcGetenabled(this);
    }

    public void setEnabled(boolean enabled) {
        User.pcSetenabled(this, enabled);
    }

    public String getEmail() {
        return User.pcGetemail(this);
    }

    public void setEmail(String email) {
        User.pcSetemail(this, email);
    }

    public String getOpenId() {
        return User.pcGetopenId(this);
    }

    public void setOpenId(String openId) {
        User.pcSetopenId(this, openId);
    }

    public PageLayout getDefaultPageLayout() {
        return User.pcGetdefaultPageLayout(this);
    }

    public void setDefaultPageLayout(PageLayout defaultPageLayout) {
        User.pcSetdefaultPageLayout(this, defaultPageLayout);
    }

    public String getConfirmPassword() {
        if (this.confirmPassword != null && this.confirmPassword.length() > 0) {
            return this.confirmPassword;
        }
        return User.pcGetpassword(this);
    }

    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }

    @PreRemove
    public void preRemove() {
        for (Authority authority : User.pcGetauthorities(this)) {
            authority.removeUser(this);
        }
        User.pcSetauthorities(this, null);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return User.pcGetentityId(this) == User.pcGetentityId(other) || User.pcGetentityId(this) != null && User.pcGetentityId(this).equals(User.pcGetentityId(other));
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + (User.pcGetentityId(this) != null ? User.pcGetentityId(this).hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("User");
        sb.append("{entityId=").append(User.pcGetentityId(this));
        sb.append(", username='").append(User.pcGetusername(this)).append('\'');
        sb.append(", expired=").append(User.pcGetexpired(this));
        sb.append(", locked=").append(User.pcGetlocked(this));
        sb.append(", enabled=").append(User.pcGetenabled(this));
        sb.append(", email='").append(User.pcGetemail(this)).append('\'');
        sb.append(", openId='").append(User.pcGetopenId(this)).append('\'');
        sb.append(", authorities=[");
        boolean first = true;
        for (Authority a : User.pcGetauthorities(this)) {
            if (!first) {
                sb.append(',');
            }
            sb.append('\'').append(a.getAuthority()).append('\'');
            first = false;
        }
        sb.append(']');
        sb.append('}');
        return sb.toString();
    }

    public int pcGetEnhancementContractVersion() {
        return 1055128;
    }

    static {
        pcFieldNames = new String[]{"authorities", "defaultPageLayout", PARAM_EMAIL, "enabled", "entityId", "expired", "locked", "openId", "password", PARAM_USERNAME};
        Class[] classArray = new Class[10];
        Class clazz = class$Ljava$util$Collection != null ? class$Ljava$util$Collection : (class$Ljava$util$Collection = User.class$("java.util.Collection"));
        classArray[0] = clazz;
        Class clazz2 = class$Lorg$apache$rave$portal$model$PageLayout != null ? class$Lorg$apache$rave$portal$model$PageLayout : (class$Lorg$apache$rave$portal$model$PageLayout = User.class$("org.apache.rave.portal.model.PageLayout"));
        classArray[1] = clazz2;
        Class clazz3 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = User.class$("java.lang.String"));
        classArray[2] = clazz3;
        classArray[3] = Boolean.TYPE;
        Class clazz4 = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = User.class$("java.lang.Long"));
        classArray[4] = clazz4;
        classArray[5] = Boolean.TYPE;
        classArray[6] = Boolean.TYPE;
        classArray[7] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = User.class$("java.lang.String"));
        classArray[8] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = User.class$("java.lang.String"));
        classArray[9] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = User.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{10, 26, 26, 26, 26, 26, 26, 26, 26, 26};
        Class clazz5 = class$Lorg$apache$rave$portal$model$User != null ? class$Lorg$apache$rave$portal$model$User : (class$Lorg$apache$rave$portal$model$User = User.class$("org.apache.rave.portal.model.User"));
        PCRegistry.register((Class)clazz5, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"User", (PersistenceCapable)new User());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.authorities = null;
        this.defaultPageLayout = null;
        this.email = null;
        this.enabled = false;
        this.entityId = null;
        this.expired = false;
        this.locked = false;
        this.openId = null;
        this.password = null;
        this.username = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        User user = new User();
        if (bl) {
            user.pcClearFields();
        }
        user.pcStateManager = stateManager;
        user.pcCopyKeyFieldsFromObjectId(object);
        return user;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        User user = new User();
        if (bl) {
            user.pcClearFields();
        }
        user.pcStateManager = stateManager;
        return user;
    }

    protected static int pcGetManagedFieldCount() {
        return 10;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.authorities = (Collection)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.defaultPageLayout = (PageLayout)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.email = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.enabled = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.entityId = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.expired = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.locked = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.openId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.password = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.username = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.authorities);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.defaultPageLayout);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.email);
                return;
            }
            case 3: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.enabled);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.entityId);
                return;
            }
            case 5: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.expired);
                return;
            }
            case 6: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.locked);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.openId);
                return;
            }
            case 8: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.password);
                return;
            }
            case 9: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.username);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(User user, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.authorities = user.authorities;
                return;
            }
            case 1: {
                this.defaultPageLayout = user.defaultPageLayout;
                return;
            }
            case 2: {
                this.email = user.email;
                return;
            }
            case 3: {
                this.enabled = user.enabled;
                return;
            }
            case 4: {
                this.entityId = user.entityId;
                return;
            }
            case 5: {
                this.expired = user.expired;
                return;
            }
            case 6: {
                this.locked = user.locked;
                return;
            }
            case 7: {
                this.openId = user.openId;
                return;
            }
            case 8: {
                this.password = user.password;
                return;
            }
            case 9: {
                this.username = user.username;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        User user = (User)object;
        if (user.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(user, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public synchronized void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        LongId longId = (LongId)object;
        fieldConsumer.storeObjectField(4 + pcInheritedFieldCount, (Object)new Long(longId.getId()));
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        LongId longId = (LongId)object;
        this.entityId = new Long(longId.getId());
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$rave$portal$model$User != null ? class$Lorg$apache$rave$portal$model$User : (class$Lorg$apache$rave$portal$model$User = User.class$("org.apache.rave.portal.model.User"));
        return new LongId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$rave$portal$model$User != null ? class$Lorg$apache$rave$portal$model$User : (class$Lorg$apache$rave$portal$model$User = User.class$("org.apache.rave.portal.model.User"));
        return new LongId(clazz, this.entityId);
    }

    private static final Collection pcGetauthorities(User user) {
        if (user.pcStateManager == null) {
            return user.authorities;
        }
        int n = pcInheritedFieldCount + 0;
        user.pcStateManager.accessingField(n);
        return user.authorities;
    }

    private static final void pcSetauthorities(User user, Collection collection) {
        if (user.pcStateManager == null) {
            user.authorities = collection;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 0, user.authorities, (Object)collection, 0);
    }

    private static final PageLayout pcGetdefaultPageLayout(User user) {
        if (user.pcStateManager == null) {
            return user.defaultPageLayout;
        }
        int n = pcInheritedFieldCount + 1;
        user.pcStateManager.accessingField(n);
        return user.defaultPageLayout;
    }

    private static final void pcSetdefaultPageLayout(User user, PageLayout pageLayout) {
        if (user.pcStateManager == null) {
            user.defaultPageLayout = pageLayout;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 1, (Object)user.defaultPageLayout, (Object)pageLayout, 0);
    }

    private static final String pcGetemail(User user) {
        if (user.pcStateManager == null) {
            return user.email;
        }
        int n = pcInheritedFieldCount + 2;
        user.pcStateManager.accessingField(n);
        return user.email;
    }

    private static final void pcSetemail(User user, String string) {
        if (user.pcStateManager == null) {
            user.email = string;
            return;
        }
        user.pcStateManager.settingStringField((PersistenceCapable)user, pcInheritedFieldCount + 2, user.email, string, 0);
    }

    private static final boolean pcGetenabled(User user) {
        if (user.pcStateManager == null) {
            return user.enabled;
        }
        int n = pcInheritedFieldCount + 3;
        user.pcStateManager.accessingField(n);
        return user.enabled;
    }

    private static final void pcSetenabled(User user, boolean bl) {
        if (user.pcStateManager == null) {
            user.enabled = bl;
            return;
        }
        user.pcStateManager.settingBooleanField((PersistenceCapable)user, pcInheritedFieldCount + 3, user.enabled, bl, 0);
    }

    private static final Long pcGetentityId(User user) {
        if (user.pcStateManager == null) {
            return user.entityId;
        }
        int n = pcInheritedFieldCount + 4;
        user.pcStateManager.accessingField(n);
        return user.entityId;
    }

    private static final void pcSetentityId(User user, Long l) {
        if (user.pcStateManager == null) {
            user.entityId = l;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 4, (Object)user.entityId, (Object)l, 0);
    }

    private static final boolean pcGetexpired(User user) {
        if (user.pcStateManager == null) {
            return user.expired;
        }
        int n = pcInheritedFieldCount + 5;
        user.pcStateManager.accessingField(n);
        return user.expired;
    }

    private static final void pcSetexpired(User user, boolean bl) {
        if (user.pcStateManager == null) {
            user.expired = bl;
            return;
        }
        user.pcStateManager.settingBooleanField((PersistenceCapable)user, pcInheritedFieldCount + 5, user.expired, bl, 0);
    }

    private static final boolean pcGetlocked(User user) {
        if (user.pcStateManager == null) {
            return user.locked;
        }
        int n = pcInheritedFieldCount + 6;
        user.pcStateManager.accessingField(n);
        return user.locked;
    }

    private static final void pcSetlocked(User user, boolean bl) {
        if (user.pcStateManager == null) {
            user.locked = bl;
            return;
        }
        user.pcStateManager.settingBooleanField((PersistenceCapable)user, pcInheritedFieldCount + 6, user.locked, bl, 0);
    }

    private static final String pcGetopenId(User user) {
        if (user.pcStateManager == null) {
            return user.openId;
        }
        int n = pcInheritedFieldCount + 7;
        user.pcStateManager.accessingField(n);
        return user.openId;
    }

    private static final void pcSetopenId(User user, String string) {
        if (user.pcStateManager == null) {
            user.openId = string;
            return;
        }
        user.pcStateManager.settingStringField((PersistenceCapable)user, pcInheritedFieldCount + 7, user.openId, string, 0);
    }

    private static final String pcGetpassword(User user) {
        if (user.pcStateManager == null) {
            return user.password;
        }
        int n = pcInheritedFieldCount + 8;
        user.pcStateManager.accessingField(n);
        return user.password;
    }

    private static final void pcSetpassword(User user, String string) {
        if (user.pcStateManager == null) {
            user.password = string;
            return;
        }
        user.pcStateManager.settingStringField((PersistenceCapable)user, pcInheritedFieldCount + 8, user.password, string, 0);
    }

    private static final String pcGetusername(User user) {
        if (user.pcStateManager == null) {
            return user.username;
        }
        int n = pcInheritedFieldCount + 9;
        user.pcStateManager.accessingField(n);
        return user.username;
    }

    private static final void pcSetusername(User user, String string) {
        if (user.pcStateManager == null) {
            user.username = string;
            return;
        }
        user.pcStateManager.settingStringField((PersistenceCapable)user, pcInheritedFieldCount + 9, user.username, string, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.entityId != null) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        if (this.pcGetDetachedState() == null) {
            return Boolean.FALSE;
        }
        return null;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

