/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.security.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.rave.portal.model.RegionWidget;
import org.apache.rave.portal.model.User;
import org.apache.rave.portal.repository.RegionWidgetRepository;
import org.apache.rave.portal.security.ModelPermissionEvaluator;
import org.apache.rave.portal.security.impl.AbstractModelPermissionEvaluator;
import org.apache.rave.portal.security.impl.RaveSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class DefaultRegionWidgetPermissionEvaluator
extends AbstractModelPermissionEvaluator<RegionWidget> {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private RegionWidgetRepository regionWidgetRepository;

    @Autowired
    public DefaultRegionWidgetPermissionEvaluator(RegionWidgetRepository regionWidgetRepository) {
        this.regionWidgetRepository = regionWidgetRepository;
    }

    @Override
    public Class<RegionWidget> getType() {
        return RegionWidget.class;
    }

    @Override
    public boolean hasPermission(Authentication authentication, RegionWidget regionWidget, ModelPermissionEvaluator.Permission permission) {
        return this.hasPermission(authentication, regionWidget, permission, false);
    }

    @Override
    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, ModelPermissionEvaluator.Permission permission) {
        boolean hasPermission = false;
        hasPermission = targetId instanceof RaveSecurityContext ? this.verifyRaveSecurityContext(authentication, (RaveSecurityContext)targetId) : this.hasPermission(authentication, (RegionWidget)this.regionWidgetRepository.get((Long)targetId), permission, true);
        return hasPermission;
    }

    private boolean hasPermission(Authentication authentication, RegionWidget regionWidget, ModelPermissionEvaluator.Permission permission, boolean trustedDomainObject) {
        ArrayList<RegionWidget> trustedRegionWidgetContainer = new ArrayList<RegionWidget>();
        if (super.hasPermission(authentication, regionWidget, permission)) {
            return true;
        }
        boolean hasPermission = false;
        switch (permission) {
            case ADMINISTER: {
                break;
            }
            case CREATE: 
            case DELETE: 
            case READ: 
            case UPDATE: {
                hasPermission = this.isRegionWidgetOwner(authentication, regionWidget, trustedRegionWidgetContainer, trustedDomainObject);
                break;
            }
            default: {
                this.log.warn("unknown permission: " + (Object)((Object)permission));
            }
        }
        return hasPermission;
    }

    private RegionWidget getTrustedRegionWidget(long regionWidgetId, List<RegionWidget> trustedRegionWidgetContainer) {
        RegionWidget regionWidget = null;
        if (trustedRegionWidgetContainer.isEmpty()) {
            regionWidget = (RegionWidget)this.regionWidgetRepository.get(regionWidgetId);
            trustedRegionWidgetContainer.add(regionWidget);
        } else {
            regionWidget = trustedRegionWidgetContainer.get(0);
        }
        return regionWidget;
    }

    private boolean isRegionWidgetOwner(Authentication authentication, RegionWidget regionWidget, List<RegionWidget> trustedRegionWidgetContainer, boolean trustedDomainObject) {
        RegionWidget trustedRegionWidget = null;
        trustedRegionWidget = trustedDomainObject ? regionWidget : this.getTrustedRegionWidget(regionWidget.getEntityId(), trustedRegionWidgetContainer);
        return this.isRegionWidgetOwnerByUsername(authentication, this.getUsernameFromRegionWidget(trustedRegionWidget));
    }

    private boolean isRegionWidgetOwnerByUsername(Authentication authentication, String username) {
        return ((User)authentication.getPrincipal()).getUsername().equals(username);
    }

    private boolean isRegionWidgetOwnerById(Authentication authentication, Long userId) {
        return ((User)authentication.getPrincipal()).getEntityId().equals(userId);
    }

    private boolean verifyRaveSecurityContext(Authentication authentication, RaveSecurityContext raveSecurityContext) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(raveSecurityContext.getType());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("unknown class specified in RaveSecurityContext: ", ex);
        }
        if (User.class == clazz) {
            return this.isRegionWidgetOwnerById(authentication, (Long)raveSecurityContext.getId());
        }
        throw new IllegalArgumentException("unknown RaveSecurityContext type: " + raveSecurityContext.getType());
    }

    private String getUsernameFromRegionWidget(RegionWidget regionWidget) {
        return regionWidget.getRegion().getPage().getOwner().getUsername();
    }
}

