/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.security.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.rave.portal.model.User;
import org.apache.rave.portal.model.Widget;
import org.apache.rave.portal.model.WidgetStatus;
import org.apache.rave.portal.repository.WidgetRepository;
import org.apache.rave.portal.security.ModelPermissionEvaluator;
import org.apache.rave.portal.security.impl.AbstractModelPermissionEvaluator;
import org.apache.rave.portal.security.impl.RaveSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class DefaultWidgetPermissionEvaluator
extends AbstractModelPermissionEvaluator<Widget> {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private WidgetRepository widgetRepository;

    @Autowired
    public DefaultWidgetPermissionEvaluator(WidgetRepository widgetRepository) {
        this.widgetRepository = widgetRepository;
    }

    @Override
    public Class<Widget> getType() {
        return Widget.class;
    }

    @Override
    public boolean hasPermission(Authentication authentication, Widget widget, ModelPermissionEvaluator.Permission permission) {
        return this.hasPermission(authentication, widget, permission, false);
    }

    @Override
    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, ModelPermissionEvaluator.Permission permission) {
        boolean hasPermission = false;
        hasPermission = targetId instanceof RaveSecurityContext ? this.verifyRaveSecurityContext(authentication, (RaveSecurityContext)targetId) : this.hasPermission(authentication, (Widget)this.widgetRepository.get((Long)targetId), permission, true);
        return hasPermission;
    }

    private boolean hasPermission(Authentication authentication, Widget widget, ModelPermissionEvaluator.Permission permission, boolean trustedDomainObject) {
        ArrayList<Widget> trustedWidgetContainer = new ArrayList<Widget>();
        if (super.hasPermission(authentication, widget, permission)) {
            return true;
        }
        boolean hasPermission = false;
        switch (permission) {
            case ADMINISTER: {
                break;
            }
            case READ: {
                hasPermission = this.isWidgetOwner(authentication, widget, trustedWidgetContainer, trustedDomainObject) || this.isPublishedWidget(widget, trustedWidgetContainer, trustedDomainObject);
                break;
            }
            case CREATE: 
            case UPDATE: 
            case DELETE: {
                hasPermission = this.isWidgetOwner(authentication, widget, trustedWidgetContainer, trustedDomainObject);
                break;
            }
            default: {
                this.log.warn("unknown permission: " + (Object)((Object)permission));
            }
        }
        return hasPermission;
    }

    private Widget getTrustedWidget(long widgetId, List<Widget> trustedWidgetContainer) {
        Widget widget = null;
        if (trustedWidgetContainer.isEmpty()) {
            widget = (Widget)this.widgetRepository.get(widgetId);
            trustedWidgetContainer.add(widget);
        } else {
            widget = trustedWidgetContainer.get(0);
        }
        return widget;
    }

    private boolean isWidgetOwner(Authentication authentication, Widget widget, List<Widget> trustedWidgetContainer, boolean trustedDomainObject) {
        Widget trustedWidget = null;
        trustedWidget = trustedDomainObject ? widget : this.getTrustedWidget(widget.getEntityId(), trustedWidgetContainer);
        return this.isWidgetOwnerByUsername(authentication, trustedWidget.getOwner().getUsername());
    }

    private boolean isWidgetOwnerByUsername(Authentication authentication, String username) {
        return ((User)authentication.getPrincipal()).getUsername().equals(username);
    }

    private boolean isWidgetOwnerById(Authentication authentication, Long userId) {
        return ((User)authentication.getPrincipal()).getEntityId().equals(userId);
    }

    private boolean isPublishedWidget(Widget widget, List<Widget> trustedWidgetContainer, boolean trustedDomainObject) {
        Widget trustedWidget = null;
        trustedWidget = trustedDomainObject ? widget : this.getTrustedWidget(widget.getEntityId(), trustedWidgetContainer);
        return WidgetStatus.PUBLISHED.equals((Object)trustedWidget.getWidgetStatus());
    }

    private boolean verifyRaveSecurityContext(Authentication authentication, RaveSecurityContext raveSecurityContext) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(raveSecurityContext.getType());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("unknown class specified in RaveSecurityContext: ", ex);
        }
        if (User.class == clazz) {
            return this.isWidgetOwnerById(authentication, (Long)raveSecurityContext.getId());
        }
        throw new IllegalArgumentException("unknown RaveSecurityContext type: " + raveSecurityContext.getType());
    }
}

