/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.security.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.rave.portal.model.User;
import org.apache.rave.portal.model.WidgetRating;
import org.apache.rave.portal.repository.WidgetRatingRepository;
import org.apache.rave.portal.security.ModelPermissionEvaluator;
import org.apache.rave.portal.security.impl.AbstractModelPermissionEvaluator;
import org.apache.rave.portal.security.impl.RaveSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class DefaultWidgetRatingPermissionEvaluator
extends AbstractModelPermissionEvaluator<WidgetRating> {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private WidgetRatingRepository widgetRatingRepository;

    @Autowired
    public DefaultWidgetRatingPermissionEvaluator(WidgetRatingRepository widgetRatingRepository) {
        this.widgetRatingRepository = widgetRatingRepository;
    }

    @Override
    public Class<WidgetRating> getType() {
        return WidgetRating.class;
    }

    @Override
    public boolean hasPermission(Authentication authentication, WidgetRating widgetRating, ModelPermissionEvaluator.Permission permission) {
        return this.hasPermission(authentication, widgetRating, permission, false);
    }

    @Override
    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, ModelPermissionEvaluator.Permission permission) {
        boolean hasPermission = false;
        hasPermission = targetId instanceof RaveSecurityContext ? this.verifyRaveSecurityContext(authentication, (RaveSecurityContext)targetId) : this.hasPermission(authentication, (WidgetRating)this.widgetRatingRepository.get((Long)targetId), permission, true);
        return hasPermission;
    }

    private boolean hasPermission(Authentication authentication, WidgetRating widgetRating, ModelPermissionEvaluator.Permission permission, boolean trustedDomainObject) {
        ArrayList<WidgetRating> trustedWidgetRatingContainer = new ArrayList<WidgetRating>();
        if (super.hasPermission(authentication, widgetRating, permission)) {
            return true;
        }
        boolean hasPermission = false;
        switch (permission) {
            case ADMINISTER: {
                break;
            }
            case CREATE: 
            case DELETE: 
            case READ: 
            case UPDATE: {
                hasPermission = this.isWidgetRatingOwner(authentication, widgetRating, trustedWidgetRatingContainer, trustedDomainObject);
                break;
            }
            default: {
                this.log.warn("unknown permission: " + (Object)((Object)permission));
            }
        }
        return hasPermission;
    }

    private WidgetRating getTrustedWidgetRating(long widgetRatingId, List<WidgetRating> trustedWidgetRatingContainer) {
        WidgetRating widgetRating = null;
        if (trustedWidgetRatingContainer.isEmpty()) {
            widgetRating = (WidgetRating)this.widgetRatingRepository.get(widgetRatingId);
            trustedWidgetRatingContainer.add(widgetRating);
        } else {
            widgetRating = trustedWidgetRatingContainer.get(0);
        }
        return widgetRating;
    }

    private boolean isWidgetRatingOwner(Authentication authentication, WidgetRating widgetRating, List<WidgetRating> trustedWidgetRatingContainer, boolean trustedDomainObject) {
        WidgetRating trustedWidgetRating = null;
        trustedWidgetRating = trustedDomainObject ? widgetRating : this.getTrustedWidgetRating(widgetRating.getEntityId(), trustedWidgetRatingContainer);
        return this.isWidgetRatingOwnerById(authentication, trustedWidgetRating.getUserId());
    }

    private boolean isWidgetRatingOwnerByUsername(Authentication authentication, String username) {
        return ((User)authentication.getPrincipal()).getUsername().equals(username);
    }

    private boolean isWidgetRatingOwnerById(Authentication authentication, Long userId) {
        return ((User)authentication.getPrincipal()).getEntityId().equals(userId);
    }

    private boolean verifyRaveSecurityContext(Authentication authentication, RaveSecurityContext raveSecurityContext) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(raveSecurityContext.getType());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("unknown class specified in RaveSecurityContext: ", ex);
        }
        if (User.class == clazz) {
            return this.isWidgetRatingOwnerById(authentication, (Long)raveSecurityContext.getId());
        }
        throw new IllegalArgumentException("unknown RaveSecurityContext type: " + raveSecurityContext.getType());
    }
}

