/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.service.impl;

import java.util.List;
import org.apache.rave.portal.model.User;
import org.apache.rave.portal.model.util.SearchResult;
import org.apache.rave.portal.repository.UserRepository;
import org.apache.rave.portal.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="userService")
public class DefaultUserService
implements UserService {
    protected static final Logger log = LoggerFactory.getLogger(DefaultUserService.class);
    private UserRepository userRepository;

    @Autowired
    public DefaultUserService(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        log.debug("loadUserByUsername called with: {}", (Object)username);
        User user = this.userRepository.getByUsername(username);
        if (user == null) {
            throw new UsernameNotFoundException("User with username '" + username + "' was not found!");
        }
        return user;
    }

    @Override
    public User getAuthenticatedUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.getPrincipal() instanceof User) {
            return (User)authentication.getPrincipal();
        }
        throw new SecurityException("Could not get the authenticated user!");
    }

    @Override
    public void setAuthenticatedUser(long userId) {
        User user = (User)this.userRepository.get(userId);
        if (user == null) {
            throw new UsernameNotFoundException("User with id '" + userId + "' was not found!");
        }
        SecurityContext securityContext = this.createContext(user);
        SecurityContextHolder.setContext((SecurityContext)securityContext);
    }

    @Override
    public void clearAuthenticatedUser() {
        SecurityContextHolder.clearContext();
    }

    private SecurityContext createContext(final User user) {
        SecurityContextImpl securityContext = new SecurityContextImpl();
        securityContext.setAuthentication((Authentication)new AbstractAuthenticationToken(user.getAuthorities()){

            public Object getCredentials() {
                return "N/A";
            }

            public Object getPrincipal() {
                return user;
            }

            public boolean isAuthenticated() {
                return true;
            }
        });
        return securityContext;
    }

    @Override
    @Transactional
    public void registerNewUser(User user) {
        this.userRepository.save(user);
    }

    @Override
    public User getUserById(Long id) {
        return (User)this.userRepository.get(id);
    }

    @Override
    public User getUserByUsername(String userName) {
        return this.userRepository.getByUsername(userName);
    }

    @Override
    public User getUserByEmail(String userEmail) {
        return this.userRepository.getByUserEmail(userEmail);
    }

    @Override
    public void updateUserProfile(User user) {
        this.userRepository.save(user);
    }

    @Override
    public SearchResult<User> getLimitedListOfUsers(int offset, int pageSize) {
        int count = this.userRepository.getCountAll();
        List<User> users = this.userRepository.getLimitedList(offset, pageSize);
        SearchResult<User> searchResult = new SearchResult<User>(users, count);
        searchResult.setOffset(offset);
        searchResult.setPageSize(pageSize);
        return searchResult;
    }

    @Override
    public SearchResult<User> getUsersByFreeTextSearch(String searchTerm, int offset, int pageSize) {
        int count = this.userRepository.getCountByUsernameOrEmail(searchTerm);
        List<User> users = this.userRepository.findByUsernameOrEmail(searchTerm, offset, pageSize);
        SearchResult<User> searchResult = new SearchResult<User>(users, count);
        searchResult.setOffset(offset);
        searchResult.setPageSize(pageSize);
        return searchResult;
    }
}

