/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.service.impl;

import org.apache.rave.portal.model.WidgetRating;
import org.apache.rave.portal.repository.WidgetRatingRepository;
import org.apache.rave.portal.service.WidgetRatingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultWidgetRatingService
implements WidgetRatingService {
    private final WidgetRatingRepository repository;

    @Autowired
    public DefaultWidgetRatingService(WidgetRatingRepository repository) {
        this.repository = repository;
    }

    @Override
    public WidgetRating getByWidgetIdAndUserId(Long widgetId, Long userId) {
        return this.repository.getByWidgetIdAndUserId(widgetId, userId);
    }

    @Override
    @Transactional
    public void saveWidgetRating(Long widgetId, Integer score, Long userId) {
        WidgetRating rating = this.getByWidgetIdAndUserId(widgetId, userId);
        if (rating == null) {
            rating = new WidgetRating();
            rating.setScore(score);
            rating.setUserId(userId);
            rating.setWidgetId(widgetId);
        } else {
            rating.setScore(score);
        }
        this.repository.save(rating);
    }

    @Override
    @Transactional
    public void removeWidgetRating(Long widgetId, Long userId) {
        WidgetRating widgetRating = this.repository.getByWidgetIdAndUserId(widgetId, userId);
        if (widgetRating == null) {
            return;
        }
        this.repository.delete(widgetRating);
    }
}

