/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.service.impl;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.rave.portal.model.Widget;
import org.apache.rave.portal.model.WidgetStatus;
import org.apache.rave.portal.model.util.SearchResult;
import org.apache.rave.portal.model.util.WidgetStatistics;
import org.apache.rave.portal.repository.WidgetRepository;
import org.apache.rave.portal.service.WidgetService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultWidgetService
implements WidgetService {
    private static Logger logger = LoggerFactory.getLogger(DefaultWidgetService.class);
    private final WidgetRepository widgetRepository;

    @Autowired
    public DefaultWidgetService(WidgetRepository widgetRepository) {
        this.widgetRepository = widgetRepository;
    }

    @Override
    public SearchResult<Widget> getAllWidgets() {
        int count = this.widgetRepository.getCountAll();
        List<Widget> widgets = this.widgetRepository.getAll();
        return new SearchResult<Widget>(widgets, count);
    }

    @Override
    public SearchResult<Widget> getLimitedListOfWidgets(int offset, int pageSize) {
        int count = this.widgetRepository.getCountAll();
        List<Widget> widgets = this.widgetRepository.getLimitedList(offset, pageSize);
        SearchResult<Widget> searchResult = new SearchResult<Widget>(widgets, count);
        searchResult.setOffset(offset);
        searchResult.setPageSize(pageSize);
        return searchResult;
    }

    @Override
    public SearchResult<Widget> getWidgetsByFreeTextSearch(String searchTerm, int offset, int pageSize) {
        if (StringUtils.isBlank((String)searchTerm)) {
            return this.getLimitedListOfWidgets(offset, pageSize);
        }
        int count = this.widgetRepository.getCountFreeTextSearch(searchTerm);
        List<Widget> widgets = this.widgetRepository.getByFreeTextSearch(searchTerm, offset, pageSize);
        SearchResult<Widget> searchResult = new SearchResult<Widget>(widgets, count);
        searchResult.setOffset(offset);
        searchResult.setPageSize(pageSize);
        return searchResult;
    }

    @Override
    public Widget getWidget(long id) {
        return (Widget)this.widgetRepository.get(id);
    }

    @Override
    public SearchResult<Widget> getPublishedWidgets(int offset, int pageSize) {
        int count = this.widgetRepository.getCountByStatus(WidgetStatus.PUBLISHED);
        List<Widget> widgets = this.widgetRepository.getByStatus(WidgetStatus.PUBLISHED, offset, pageSize);
        SearchResult<Widget> searchResult = new SearchResult<Widget>(widgets, count);
        searchResult.setOffset(offset);
        searchResult.setPageSize(pageSize);
        return searchResult;
    }

    @Override
    public SearchResult<Widget> getPublishedWidgetsByFreeTextSearch(String searchTerm, int offset, int pageSize) {
        return this.getWidgetsBySearchCriteria(searchTerm, null, WidgetStatus.PUBLISHED.getWidgetStatus(), offset, pageSize);
    }

    @Override
    public SearchResult<Widget> getWidgetsBySearchCriteria(String searchTerm, String widgetType, String widgetStatus, int offset, int pageSize) {
        WidgetStatus status = StringUtils.isBlank((String)widgetStatus) ? null : WidgetStatus.get(widgetStatus);
        int count = this.widgetRepository.getCountByStatusAndTypeAndFreeText(status, widgetType, searchTerm);
        List<Widget> widgets = this.widgetRepository.getByStatusAndTypeAndFreeTextSearch(status, widgetType, searchTerm, offset, pageSize);
        SearchResult<Widget> searchResult = new SearchResult<Widget>(widgets, count);
        searchResult.setOffset(offset);
        searchResult.setPageSize(pageSize);
        return searchResult;
    }

    @Override
    public Widget getWidgetByUrl(String widgetUrl) {
        return this.widgetRepository.getByUrl(widgetUrl);
    }

    @Override
    @Transactional
    public Widget registerNewWidget(Widget widget) {
        if (this.getWidgetByUrl(widget.getUrl()) != null) {
            logger.debug("Trying to add an existing widget for url {}", (Object)widget.getUrl());
            return null;
        }
        return (Widget)this.widgetRepository.save(widget);
    }

    @Override
    public WidgetStatistics getWidgetStatistics(long widgetId, long userId) {
        return this.widgetRepository.getWidgetStatistics(widgetId, userId);
    }

    @Override
    public Map<Long, WidgetStatistics> getAllWidgetStatistics(long userId) {
        return this.widgetRepository.getAllWidgetStatistics(userId);
    }

    @Override
    @Transactional
    public void updateWidget(Widget widget) {
        this.widgetRepository.save(widget);
    }
}

