/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.repository.impl;

import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.rave.persistence.jpa.AbstractJpaRepository;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.Page;
import org.apache.rave.portal.model.User;
import org.apache.rave.portal.model.WidgetComment;
import org.apache.rave.portal.model.WidgetRating;
import org.apache.rave.portal.repository.UserRepository;
import org.springframework.stereotype.Repository;

@Repository
public class JpaUserRepository
extends AbstractJpaRepository<User>
implements UserRepository {
    public JpaUserRepository() {
        super(User.class);
    }

    @Override
    public User getByUsername(String username) {
        TypedQuery query = this.manager.createNamedQuery("User.getByUsername", User.class);
        query.setParameter("username", (Object)username);
        return (User)JpaUtil.getSingleResult((List)query.getResultList());
    }

    @Override
    public User getByUserEmail(String userEmail) {
        TypedQuery query = this.manager.createNamedQuery("User.getByUserEmail", User.class);
        query.setParameter("email", (Object)userEmail);
        return (User)JpaUtil.getSingleResult((List)query.getResultList());
    }

    @Override
    public List<User> getLimitedList(int offset, int pageSize) {
        TypedQuery query = this.manager.createNamedQuery("User.getAll", User.class);
        return JpaUtil.getPagedResultList((TypedQuery)query, (int)offset, (int)pageSize);
    }

    @Override
    public int getCountAll() {
        Query query = this.manager.createNamedQuery("User.countAll");
        Number countResult = (Number)query.getSingleResult();
        return countResult.intValue();
    }

    @Override
    public List<User> findByUsernameOrEmail(String searchTerm, int offset, int pageSize) {
        TypedQuery query = this.manager.createNamedQuery("User.findByUsernameOrEmail", User.class);
        query.setParameter("searchTerm", (Object)("%" + searchTerm.toLowerCase() + "%"));
        return JpaUtil.getPagedResultList((TypedQuery)query, (int)offset, (int)pageSize);
    }

    @Override
    public int getCountByUsernameOrEmail(String searchTerm) {
        Query query = this.manager.createNamedQuery("User.countFindByUsernameOrEmail");
        query.setParameter("searchTerm", (Object)("%" + searchTerm.toLowerCase() + "%"));
        Number countResult = (Number)query.getSingleResult();
        return countResult.intValue();
    }

    @Override
    public void removeUser(User user) {
        this.deletePages(user);
        this.deleteWidgetComments(user);
        this.deleteWidgetRatings(user);
        this.removeUserFromWidget(user);
        this.delete(user);
    }

    private void deletePages(User user) {
        TypedQuery pageQuery = this.manager.createNamedQuery("Page.getByUserId", Page.class);
        pageQuery.setParameter("userId", (Object)user.getEntityId());
        List resultList = pageQuery.getResultList();
        for (Page p : resultList) {
            this.manager.remove((Object)p);
        }
    }

    private void deleteWidgetRatings(User user) {
        TypedQuery widgetRatingQuery = this.manager.createNamedQuery("widget_all_user_ratings", WidgetRating.class);
        widgetRatingQuery.setParameter("userId", (Object)user.getEntityId());
        List resultList = widgetRatingQuery.getResultList();
        for (WidgetRating widgetRating : resultList) {
            this.manager.remove((Object)widgetRating);
        }
    }

    private void deleteWidgetComments(User user) {
        TypedQuery widgetCommentQuery = this.manager.createQuery("SELECT wc FROM WidgetComment wc WHERE wc.user = :user", WidgetComment.class);
        widgetCommentQuery.setParameter("user", (Object)user);
        List resultList = widgetCommentQuery.getResultList();
        for (WidgetComment widgetComment : resultList) {
            this.manager.remove((Object)widgetComment);
        }
    }

    private void removeUserFromWidget(User user) {
        Query query = this.manager.createQuery("UPDATE Widget w SET w.owner = null WHERE w.owner = :user");
        query.setParameter("user", (Object)user);
        query.executeUpdate();
    }
}

