/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.security.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.rave.persistence.BasicEntity;
import org.apache.rave.portal.security.ModelPermissionEvaluator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class RavePermissionEvaluator
implements PermissionEvaluator {
    private Map<String, ModelPermissionEvaluator> modelPermissionEvaluatorMap;

    @Autowired
    public RavePermissionEvaluator(List<ModelPermissionEvaluator> modelPermissionEvaluatorList) {
        Collections.sort(modelPermissionEvaluatorList, new Comparator<ModelPermissionEvaluator>(){

            @Override
            public int compare(ModelPermissionEvaluator o1, ModelPermissionEvaluator o2) {
                return new Integer(o1.getLoadOrder()).compareTo(new Integer(o2.getLoadOrder()));
            }
        });
        this.modelPermissionEvaluatorMap = new HashMap<String, ModelPermissionEvaluator>();
        for (ModelPermissionEvaluator mpe : modelPermissionEvaluatorList) {
            this.modelPermissionEvaluatorMap.put(mpe.getType().getName(), mpe);
        }
    }

    public boolean hasPermission(Authentication authentication, Object targetDomainObject, Object permissionString) {
        if (targetDomainObject == null) {
            return false;
        }
        return this.getEvaluator(targetDomainObject.getClass().getName()).hasPermission(authentication, targetDomainObject, this.getPermission(targetDomainObject, (String)permissionString));
    }

    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, Object permissionString) {
        ModelPermissionEvaluator.Permission permission = ModelPermissionEvaluator.Permission.fromString((String)permissionString);
        if (permission == ModelPermissionEvaluator.Permission.CREATE_OR_UPDATE) {
            throw new IllegalArgumentException("CREATE_OR_UPDATE not supported in this context.");
        }
        return this.getEvaluator(targetType).hasPermission(authentication, targetId, targetType, permission);
    }

    private ModelPermissionEvaluator getEvaluator(String targetType) throws IllegalArgumentException {
        ModelPermissionEvaluator mpe = this.modelPermissionEvaluatorMap.get(targetType);
        if (mpe == null) {
            throw new IllegalArgumentException("ModelPermissionEvaluator not found for type " + targetType);
        }
        return mpe;
    }

    private ModelPermissionEvaluator.Permission getPermission(Object targetDomainObject, String permissionString) {
        ModelPermissionEvaluator.Permission permission = ModelPermissionEvaluator.Permission.fromString(permissionString);
        if (permission.equals((Object)ModelPermissionEvaluator.Permission.CREATE_OR_UPDATE)) {
            if (targetDomainObject instanceof BasicEntity) {
                Long id = ((BasicEntity)targetDomainObject).getEntityId();
                permission = id == null ? ModelPermissionEvaluator.Permission.CREATE : ModelPermissionEvaluator.Permission.UPDATE;
            } else {
                throw new IllegalArgumentException("CREATE_OR_UPDATE is currently only supported for BasicEntity types");
            }
        }
        return permission;
    }
}

