/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.rave.portal.model.PortalPreference;
import org.apache.rave.portal.repository.PortalPreferenceRepository;
import org.apache.rave.portal.service.PortalPreferenceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultPortalPreferenceService
implements PortalPreferenceService {
    private final PortalPreferenceRepository repository;

    @Autowired
    public DefaultPortalPreferenceService(PortalPreferenceRepository repository) {
        this.repository = repository;
    }

    @Override
    public Map<String, PortalPreference> getPreferencesAsMap() {
        List<PortalPreference> portalPreferences = this.repository.getAll();
        HashMap<String, PortalPreference> preferenceMap = new HashMap<String, PortalPreference>();
        for (PortalPreference preference : portalPreferences) {
            preferenceMap.put(preference.getKey(), preference);
        }
        return preferenceMap;
    }

    @Override
    public PortalPreference getPreference(String key) {
        return this.repository.getByKey(key);
    }

    @Override
    public void savePreference(String key, String value) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        this.savePreference(key, values);
    }

    @Override
    public void savePreference(String key, List<String> values) {
        PortalPreference preference = this.getPreference(key);
        if (preference == null) {
            preference = new PortalPreference(key, values);
        } else {
            preference.setValues(values);
        }
        this.savePreference(preference);
    }

    @Override
    public void savePreference(PortalPreference preference) {
        this.repository.save(preference);
    }
}

