/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.util;

import com.ibm.icu.util.GlobalizationPreferences;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.rave.portal.model.util.LocalizedString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalizationUtils {
    static Logger _logger = LoggerFactory.getLogger(LocalizationUtils.class);

    private LocalizationUtils() {
    }

    public static LocalizedString getLocalizedElement(LocalizedString[] elements, String[] locales) {
        if (elements == null) {
            return null;
        }
        if ((elements = LocalizationUtils.processElementsByLocales(elements, locales)).length == 0) {
            return null;
        }
        return elements[0];
    }

    public static LocalizedString[] processElementsByLocales(LocalizedString[] elements, String[] locales) {
        if (elements == null) {
            return null;
        }
        List<ULocale> localesList = LocalizationUtils.getProcessedLocaleList(locales);
        Arrays.sort(elements, new LocaleComparator(localesList));
        return LocalizationUtils.filter(elements, localesList);
    }

    public static LocalizedString[] processElementsByDefaultLocales(LocalizedString[] elements) {
        if (elements == null) {
            return null;
        }
        List<ULocale> localesList = LocalizationUtils.getDefaultLocaleList();
        Arrays.sort(elements, new LocaleComparator(localesList));
        return LocalizationUtils.filter(elements, localesList);
    }

    protected static LocalizedString[] filter(LocalizedString[] elements, List<ULocale> locales) {
        for (LocalizedString element : elements) {
            String lang = element.getLang();
            boolean found = false;
            for (ULocale locale : locales) {
                if (!locale.toLanguageTag().equalsIgnoreCase(lang)) continue;
                found = true;
            }
            if (found || lang == null) continue;
            elements = (LocalizedString[])ArrayUtils.removeElement((Object[])elements, (Object)element);
        }
        if (elements.length > 0 && elements[0].getLang() != null) {
            for (LocalizedString element : elements) {
                if (element.getLang() != null) continue;
                elements = (LocalizedString[])ArrayUtils.removeElement((Object[])elements, (Object)element);
            }
        }
        return elements;
    }

    public static List<ULocale> getProcessedLocaleList(String[] locales) {
        if (locales == null) {
            return LocalizationUtils.getDefaultLocaleList();
        }
        GlobalizationPreferences prefs = new GlobalizationPreferences();
        ArrayList<ULocale> ulocales = new ArrayList<ULocale>();
        for (String locale : locales) {
            if (locale == null) continue;
            try {
                ULocale ulocale = ULocale.forLanguageTag((String)locale);
                if (ulocale.getLanguage().equals("")) continue;
                ulocales.add(ulocale);
            }
            catch (Exception e) {
                _logger.error("icu4j:ULocale.forLanguageTag(" + locale + ") threw Exception:", (Throwable)e);
            }
        }
        if (ulocales.isEmpty()) {
            return LocalizationUtils.getDefaultLocaleList();
        }
        prefs.setLocales(ulocales.toArray(new ULocale[ulocales.size()]));
        return prefs.getLocales();
    }

    protected static List<ULocale> getDefaultLocaleList() {
        GlobalizationPreferences prefs = new GlobalizationPreferences();
        return prefs.getLocales();
    }

    public static boolean isValidLanguageTag(String tag) {
        try {
            ULocale locale = ULocale.forLanguageTag((String)tag);
            if (locale.toLanguageTag() == null) {
                return false;
            }
            if (locale.getExtension("x".charAt(0)) != null) {
                return false;
            }
            return locale.toLanguageTag().equalsIgnoreCase(tag);
        }
        catch (Exception e) {
            return false;
        }
    }

    static class LocaleComparator
    implements Comparator<LocalizedString> {
        private List<ULocale> locales;

        public LocaleComparator(List<ULocale> locales) {
            this.locales = locales;
        }

        @Override
        public int compare(LocalizedString o1, LocalizedString o2) {
            if (o1.getLang() != null && o2.getLang() == null) {
                return -1;
            }
            if (o1.getLang() == null && o2.getLang() != null) {
                return 1;
            }
            if (o1.getLang() == null && o2.getLang() == null) {
                return 0;
            }
            int o1i = -1;
            int o2i = -1;
            for (int i = 0; i < this.locales.size(); ++i) {
                if (o1.getLang().equalsIgnoreCase(this.locales.get(i).toLanguageTag())) {
                    o1i = i;
                }
                if (!o2.getLang().equalsIgnoreCase(this.locales.get(i).toLanguageTag())) continue;
                o2i = i;
            }
            if (o1i == -1 && o2i > -1) {
                return 1;
            }
            if (o1i > -1 && o2i == -1) {
                return -1;
            }
            return o1i - o2i;
        }
    }
}

