/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.renderer.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.rave.exception.NotSupportedException;
import org.apache.rave.portal.model.RegionWidget;
import org.apache.rave.portal.web.renderer.RegionWidgetRenderer;
import org.apache.rave.portal.web.renderer.RenderService;
import org.apache.rave.portal.web.renderer.Renderer;
import org.apache.rave.portal.web.renderer.model.RenderContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultRenderService
implements RenderService {
    private final Map<String, RegionWidgetRenderer> supportedWidgets = new HashMap<String, RegionWidgetRenderer>();

    @Autowired
    public DefaultRenderService(List<RegionWidgetRenderer> widgetRenderers) {
        DefaultRenderService.mapRenderersByType(this.supportedWidgets, widgetRenderers);
    }

    @Override
    public Collection<String> getSupportedWidgetTypes() {
        return this.supportedWidgets.keySet();
    }

    @Override
    public String render(RegionWidget widget, RenderContext context) {
        RegionWidgetRenderer renderer = this.supportedWidgets.get(widget.getWidget().getType());
        if (renderer == null) {
            throw new NotSupportedException(widget.getWidget().getType() + " is not supported");
        }
        return renderer.render(widget, context);
    }

    private static <T extends Renderer> void mapRenderersByType(Map<String, T> map, List<T> renderers) {
        for (Renderer renderer : renderers) {
            map.put(renderer.getSupportedContext(), renderer);
        }
    }
}

