/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.repository.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang.StringUtils;
import org.apache.rave.persistence.jpa.AbstractJpaRepository;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.User;
import org.apache.rave.portal.model.Widget;
import org.apache.rave.portal.model.WidgetRating;
import org.apache.rave.portal.model.WidgetStatus;
import org.apache.rave.portal.model.util.WidgetStatistics;
import org.apache.rave.portal.repository.WidgetRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class JpaWidgetRepository
extends AbstractJpaRepository<Widget>
implements WidgetRepository {
    private final Logger log = LoggerFactory.getLogger(JpaWidgetRepository.class);

    public JpaWidgetRepository() {
        super(Widget.class);
    }

    @Override
    public List<Widget> getAll() {
        this.log.warn("Requesting potentially large resultset of Widget. No pagesize set.");
        TypedQuery query = this.manager.createNamedQuery("Widget.getAll", Widget.class);
        return query.getResultList();
    }

    @Override
    public List<Widget> getLimitedList(int offset, int pageSize) {
        TypedQuery query = this.manager.createNamedQuery("Widget.getAll", Widget.class);
        return JpaUtil.getPagedResultList((TypedQuery)query, (int)offset, (int)pageSize);
    }

    @Override
    public int getCountAll() {
        Query query = this.manager.createNamedQuery("Widget.countAll");
        Number countResult = (Number)query.getSingleResult();
        return countResult.intValue();
    }

    @Override
    public List<Widget> getByFreeTextSearch(String searchTerm, int offset, int pageSize) {
        TypedQuery query = this.manager.createNamedQuery("Widget.getByFreeText", Widget.class);
        this.setFreeTextSearchTerm((Query)query, searchTerm);
        return JpaUtil.getPagedResultList((TypedQuery)query, (int)offset, (int)pageSize);
    }

    @Override
    public int getCountFreeTextSearch(String searchTerm) {
        Query query = this.manager.createNamedQuery("Widget.countByFreeText");
        this.setFreeTextSearchTerm(query, searchTerm);
        Number countResult = (Number)query.getSingleResult();
        return countResult.intValue();
    }

    @Override
    public List<Widget> getByStatus(WidgetStatus widgetStatus, int offset, int pageSize) {
        TypedQuery query = this.manager.createNamedQuery("Widget.getByStatus", Widget.class);
        query.setParameter("widgetStatus", (Object)widgetStatus);
        return JpaUtil.getPagedResultList((TypedQuery)query, (int)offset, (int)pageSize);
    }

    @Override
    public int getCountByStatus(WidgetStatus widgetStatus) {
        Query query = this.manager.createNamedQuery("Widget.countByStatus");
        query.setParameter("widgetStatus", (Object)widgetStatus);
        Number countResult = (Number)query.getSingleResult();
        return countResult.intValue();
    }

    @Override
    public List<Widget> getByStatusAndTypeAndFreeTextSearch(WidgetStatus widgetStatus, String type, String searchTerm, int offset, int pageSize) {
        CriteriaBuilder cb = this.manager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(Widget.class);
        Root widgetType = query.from(Widget.class);
        query.where(this.getStatusAndTypeAndFreeTextPredicates(cb, (Root<Widget>)widgetType, widgetStatus, type, searchTerm));
        query.orderBy(new Order[]{this.getOrderByTitleAsc(cb, (Root<Widget>)widgetType)});
        return JpaUtil.getPagedResultList((TypedQuery)this.manager.createQuery(query), (int)offset, (int)pageSize);
    }

    @Override
    public int getCountByStatusAndTypeAndFreeText(WidgetStatus widgetStatus, String type, String searchTerm) {
        CriteriaBuilder cb = this.manager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(Long.class);
        Root widgetType = query.from(Widget.class);
        query.select((Selection)cb.count((Expression)widgetType));
        query.where(this.getStatusAndTypeAndFreeTextPredicates(cb, (Root<Widget>)widgetType, widgetStatus, type, searchTerm));
        Long countResult = (Long)this.manager.createQuery(query).getSingleResult();
        return countResult.intValue();
    }

    @Override
    public List<Widget> getByOwner(User owner, int offset, int pageSize) {
        TypedQuery query = this.manager.createNamedQuery("Widget.getByOwner", Widget.class);
        query.setParameter("owner", (Object)owner);
        return JpaUtil.getPagedResultList((TypedQuery)query, (int)offset, (int)pageSize);
    }

    @Override
    public int getCountByOwner(User owner, int offset, int pageSize) {
        Query query = this.manager.createNamedQuery("Widget.countByOwner");
        query.setParameter("owner", (Object)owner);
        Number countResult = (Number)query.getSingleResult();
        return countResult.intValue();
    }

    @Override
    public Widget getByUrl(String widgetUrl) {
        if (StringUtils.isBlank((String)widgetUrl)) {
            throw new IllegalArgumentException("Widget URL must not be empty");
        }
        TypedQuery query = this.manager.createNamedQuery("Widget.getByUrl", Widget.class);
        query.setParameter("url", (Object)widgetUrl);
        List resultList = query.getResultList();
        return (Widget)JpaUtil.getSingleResult((List)resultList);
    }

    @Override
    public WidgetStatistics getWidgetStatistics(long widget_id, long user_id) {
        WidgetStatistics widgetStatistics = new WidgetStatistics();
        Query query = this.manager.createNamedQuery("widget_total_likes");
        query.setParameter("widgetId", (Object)widget_id);
        widgetStatistics.setTotalLike(((Number)query.getSingleResult()).intValue());
        query = this.manager.createNamedQuery("widget_total_dislikes");
        query.setParameter("widgetId", (Object)widget_id);
        widgetStatistics.setTotalDislike(((Number)query.getSingleResult()).intValue());
        query = this.manager.createNamedQuery("RegionWidget.getDistinctUserCount");
        query.setParameter("widgetId", (Object)widget_id);
        widgetStatistics.setTotalUserCount(((Number)query.getSingleResult()).intValue());
        try {
            query = this.manager.createNamedQuery("widget_user_rating");
            query.setParameter("widgetId", (Object)widget_id);
            query.setParameter("userId", (Object)user_id);
            widgetStatistics.setUserRating(((Number)query.getSingleResult()).intValue());
        }
        catch (NoResultException e) {
            widgetStatistics.setUserRating(WidgetRating.UNSET);
        }
        return widgetStatistics;
    }

    @Override
    public Map<Long, WidgetRating> getUsersWidgetRatings(long user_id) {
        TypedQuery query = this.manager.createNamedQuery("widget_all_user_ratings", WidgetRating.class);
        query.setParameter("userId", (Object)user_id);
        HashMap<Long, WidgetRating> map = new HashMap<Long, WidgetRating>();
        for (WidgetRating widgetRating : query.getResultList()) {
            map.put(widgetRating.getWidgetId(), widgetRating);
        }
        return map;
    }

    @Override
    public Map<Long, WidgetStatistics> getAllWidgetStatistics(long userId) {
        WidgetStatistics widgetStatistics;
        Long widgetId;
        HashMap<Long, WidgetStatistics> map = new HashMap<Long, WidgetStatistics>();
        Query query = this.manager.createNamedQuery("widget_all_total_likes");
        for (Object[] result : query.getResultList()) {
            Long totalLikes = (Long)result[0];
            widgetId = (Long)result[1];
            widgetStatistics = new WidgetStatistics();
            widgetStatistics.setTotalLike(totalLikes.intValue());
            map.put(widgetId, widgetStatistics);
        }
        query = this.manager.createNamedQuery("widget_all_total_dislikes");
        for (Object[] result : query.getResultList()) {
            Long totalDislikes = (Long)result[0];
            widgetId = (Long)result[1];
            widgetStatistics = (WidgetStatistics)map.get(widgetId);
            if (widgetStatistics == null) {
                widgetStatistics = new WidgetStatistics();
                map.put(widgetId, widgetStatistics);
            }
            widgetStatistics.setTotalDislike(totalDislikes.intValue());
        }
        query = this.manager.createNamedQuery("RegionWidget.getDistinctUserCountForAllWidgets");
        for (Object[] result : query.getResultList()) {
            Long widgetId2 = (Long)result[0];
            Long totalUserCount = (Long)result[1];
            widgetStatistics = map.get(widgetId2);
            if (widgetStatistics == null) {
                widgetStatistics = new WidgetStatistics();
                map.put(widgetId2, widgetStatistics);
            }
            widgetStatistics.setTotalUserCount(totalUserCount.intValue());
        }
        Map<Long, WidgetRating> userRatings = this.getUsersWidgetRatings(userId);
        for (Map.Entry entry : map.entrySet()) {
            if (userRatings.containsKey(entry.getKey())) {
                ((WidgetStatistics)entry.getValue()).setUserRating(userRatings.get(entry.getKey()).getScore());
                continue;
            }
            ((WidgetStatistics)entry.getValue()).setUserRating(WidgetRating.UNSET);
        }
        return map;
    }

    protected void setFreeTextSearchTerm(Query query, String searchTerm) {
        query.setParameter("searchTerm", (Object)this.getLowercaseWildcardSearchTerm(searchTerm));
    }

    private Predicate[] getStatusAndTypeAndFreeTextPredicates(CriteriaBuilder cb, Root<Widget> widgetType, WidgetStatus widgetStatus, String type, String searchTerm) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (StringUtils.isNotBlank((String)searchTerm)) {
            predicates.add(cb.or((Expression)cb.like(cb.lower(this.getTitleField(widgetType)), this.getLowercaseWildcardSearchTerm(searchTerm)), (Expression)cb.like(cb.lower(this.getDescriptionField(widgetType)), this.getLowercaseWildcardSearchTerm(searchTerm))));
        }
        if (StringUtils.isNotBlank((String)type)) {
            predicates.add(cb.and(new Predicate[]{cb.equal(this.getTypeField(widgetType), (Object)type)}));
        }
        if (widgetStatus != null) {
            predicates.add(cb.and(new Predicate[]{cb.equal(this.getWidgetStatusField(widgetType), (Object)widgetStatus)}));
        }
        return predicates.toArray(new Predicate[predicates.size()]);
    }

    private Order getOrderByTitleAsc(CriteriaBuilder cb, Root<Widget> widgetType) {
        return cb.asc(this.getTitleField(widgetType));
    }

    private Path<String> getTitleField(Root<Widget> widgetType) {
        return widgetType.get("title");
    }

    private Path<String> getDescriptionField(Root<Widget> widgetType) {
        return widgetType.get("description");
    }

    private Path<String> getTypeField(Root<Widget> widgetType) {
        return widgetType.get("type");
    }

    private Path<WidgetStatus> getWidgetStatusField(Root<Widget> widgetType) {
        return widgetType.get("widgetStatus");
    }

    private String getLowercaseWildcardSearchTerm(String searchTerm) {
        if (StringUtils.isBlank((String)searchTerm)) {
            return searchTerm;
        }
        return "%" + searchTerm.toLowerCase() + "%";
    }
}

