/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.security.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.rave.portal.model.Page;
import org.apache.rave.portal.model.User;
import org.apache.rave.portal.repository.PageRepository;
import org.apache.rave.portal.security.ModelPermissionEvaluator;
import org.apache.rave.portal.security.impl.AbstractModelPermissionEvaluator;
import org.apache.rave.portal.security.impl.RaveSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class DefaultPagePermissionEvaluator
extends AbstractModelPermissionEvaluator<Page> {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private PageRepository pageRepository;

    @Autowired
    public DefaultPagePermissionEvaluator(PageRepository pageRepository) {
        this.pageRepository = pageRepository;
    }

    @Override
    public Class<Page> getType() {
        return Page.class;
    }

    @Override
    public boolean hasPermission(Authentication authentication, Page page, ModelPermissionEvaluator.Permission permission) {
        return this.hasPermission(authentication, page, permission, false);
    }

    @Override
    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, ModelPermissionEvaluator.Permission permission) {
        boolean hasPermission = false;
        hasPermission = targetId instanceof RaveSecurityContext ? this.verifyRaveSecurityContext(authentication, (RaveSecurityContext)targetId) : this.hasPermission(authentication, (Page)this.pageRepository.get((Long)targetId), permission, true);
        return hasPermission;
    }

    private boolean hasPermission(Authentication authentication, Page page, ModelPermissionEvaluator.Permission permission, boolean trustedDomainObject) {
        ArrayList<Page> trustedPageContainer = new ArrayList<Page>();
        if (super.hasPermission(authentication, page, permission)) {
            return true;
        }
        boolean hasPermission = false;
        switch (permission) {
            case ADMINISTER: {
                break;
            }
            case CREATE: 
            case DELETE: 
            case READ: 
            case UPDATE: {
                hasPermission = this.isPageOwner(authentication, page, trustedPageContainer, trustedDomainObject);
                break;
            }
            default: {
                this.log.warn("unknown permission: " + (Object)((Object)permission));
            }
        }
        return hasPermission;
    }

    private Page getTrustedPage(long pageId, List<Page> trustedPageContainer) {
        Page p = null;
        if (trustedPageContainer.isEmpty()) {
            p = (Page)this.pageRepository.get(pageId);
            trustedPageContainer.add(p);
        } else {
            p = trustedPageContainer.get(0);
        }
        return p;
    }

    private boolean isPageOwner(Authentication authentication, Page page, List<Page> trustedPageContainer, boolean trustedDomainObject) {
        Page trustedPage = null;
        trustedPage = trustedDomainObject ? page : this.getTrustedPage(page.getEntityId(), trustedPageContainer);
        return this.isPageOwnerByUsername(authentication, trustedPage.getOwner().getUsername());
    }

    private boolean isPageOwnerByUsername(Authentication authentication, String username) {
        return ((User)authentication.getPrincipal()).getUsername().equals(username);
    }

    private boolean isPageOwnerById(Authentication authentication, Long userId) {
        return ((User)authentication.getPrincipal()).getEntityId().equals(userId);
    }

    private boolean verifyRaveSecurityContext(Authentication authentication, RaveSecurityContext raveSecurityContext) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(raveSecurityContext.getType());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("unknown class specified in RaveSecurityContext: ", ex);
        }
        if (User.class == clazz) {
            return this.isPageOwnerById(authentication, (Long)raveSecurityContext.getId());
        }
        throw new IllegalArgumentException("unknown RaveSecurityContext type: " + raveSecurityContext.getType());
    }
}

