/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.service;

import java.util.List;
import org.apache.rave.portal.model.Page;
import org.apache.rave.portal.model.Region;
import org.apache.rave.portal.model.RegionWidget;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;

public interface PageService {
    @PostAuthorize(value="hasPermission(returnObject, 'read')")
    public Page getPage(long var1);

    @PreAuthorize(value="hasPermission(new org.apache.rave.portal.security.impl.RaveSecurityContext(#userId, 'org.apache.rave.portal.model.User'), 'org.apache.rave.portal.model.Page', 'read')")
    public List<Page> getAllPages(long var1);

    public Page getPageFromList(long var1, List<Page> var3);

    public Page getDefaultPageFromList(List<Page> var1);

    @PostAuthorize(value="hasPermission(returnObject, 'create')")
    public Page addNewPage(String var1, String var2);

    @PreAuthorize(value="hasPermission(new org.apache.rave.portal.security.impl.RaveSecurityContext(#userId, 'org.apache.rave.portal.model.User'), 'org.apache.rave.portal.model.Page', 'create')")
    public Page addNewDefaultPage(long var1);

    public String getDefaultPageName();

    @PreAuthorize(value="hasPermission(#pageId, 'org.apache.rave.portal.model.Page', 'delete')")
    public void deletePage(long var1);

    @PreAuthorize(value="hasPermission(#regionWidgetId, 'org.apache.rave.portal.model.RegionWidget', 'update') and hasPermission(#toRegionId, 'org.apache.rave.portal.model.Region', 'update') and hasPermission(#fromRegionId, 'org.apache.rave.portal.model.Region', 'update')")
    public RegionWidget moveRegionWidget(long var1, int var3, long var4, long var6);

    @PreAuthorize(value="hasPermission(#regionWidgetId, 'org.apache.rave.portal.model.RegionWidget', 'update') and hasPermission(#toPageId, 'org.apache.rave.portal.model.Page', 'update')")
    public RegionWidget moveRegionWidgetToPage(long var1, long var3);

    @PreAuthorize(value="hasPermission(#pageId, 'org.apache.rave.portal.model.Page', 'update') and hasPermission(#widgetId, 'org.apache.rave.portal.model.Widget', 'read')")
    public RegionWidget addWidgetToPage(long var1, long var3);

    @PreAuthorize(value="hasPermission(#regionWidgetId, 'org.apache.rave.portal.model.RegionWidget', 'delete')")
    public Region removeWidgetFromPage(long var1);

    @PreAuthorize(value="hasPermission(#pageId, 'org.apache.rave.portal.model.Page', 'update')")
    public Page updatePage(long var1, String var3, String var4);

    @PreAuthorize(value="hasPermission(#pageId, 'org.apache.rave.portal.model.Page', 'update') and hasPermission(#moveAfterPageId, 'org.apache.rave.portal.model.Page', 'update')")
    public Page movePage(long var1, long var3);

    @PreAuthorize(value="hasPermission(#pageId, 'org.apache.rave.portal.model.Page', 'update')")
    public Page movePageToDefault(long var1);
}

