/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.service;

import java.util.Map;
import org.apache.rave.portal.model.Widget;
import org.apache.rave.portal.model.util.SearchResult;
import org.apache.rave.portal.model.util.WidgetStatistics;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;

public interface WidgetService {
    public SearchResult<Widget> getAllWidgets();

    public SearchResult<Widget> getLimitedListOfWidgets(int var1, int var2);

    public SearchResult<Widget> getWidgetsByFreeTextSearch(String var1, int var2, int var3);

    @PostAuthorize(value="hasPermission(returnObject, 'read')")
    public Widget getWidget(long var1);

    public SearchResult<Widget> getPublishedWidgets(int var1, int var2);

    public SearchResult<Widget> getPublishedWidgetsByFreeTextSearch(String var1, int var2, int var3);

    public SearchResult<Widget> getWidgetsBySearchCriteria(String var1, String var2, String var3, int var4, int var5);

    public SearchResult<Widget> getWidgetsByOwner(Long var1, int var2, int var3);

    @PostAuthorize(value="hasPermission(returnObject, 'read')")
    public Widget getWidgetByUrl(String var1);

    public boolean isRegisteredUrl(String var1);

    @PostAuthorize(value="hasPermission(returnObject, 'create')")
    public Widget registerNewWidget(Widget var1);

    public WidgetStatistics getWidgetStatistics(long var1, long var3);

    public Map<Long, WidgetStatistics> getAllWidgetStatistics(long var1);

    @PreAuthorize(value="hasPermission(#widget.entityId, 'org.apache.rave.portal.model.Widget', 'update')")
    public void updateWidget(Widget var1);
}

