/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.repository.impl;

import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.rave.persistence.jpa.AbstractJpaRepository;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.Tag;
import org.apache.rave.portal.repository.TagRepository;
import org.springframework.stereotype.Repository;

@Repository
public class JpaTagRepository
extends AbstractJpaRepository<Tag>
implements TagRepository {
    public JpaTagRepository() {
        super(Tag.class);
    }

    @Override
    public List<Tag> getAll() {
        TypedQuery query = this.manager.createNamedQuery("getAll", Tag.class);
        return query.getResultList();
    }

    @Override
    public int getCountAll() {
        Query query = this.manager.createNamedQuery("countAll");
        Number countResult = (Number)query.getSingleResult();
        return countResult.intValue();
    }

    @Override
    public Tag getByKeyword(String keyword) {
        if (keyword != null) {
            keyword = keyword.trim();
        }
        TypedQuery query = this.manager.createNamedQuery("findByKeyword", Tag.class);
        query.setParameter("keyword", (Object)keyword);
        return (Tag)JpaUtil.getSingleResult((List)query.getResultList());
    }

    @Override
    public List<Tag> getAvailableTagsByWidgetId(Long widgetId) {
        TypedQuery query = this.manager.createNamedQuery("getAllNotInWidget", Tag.class);
        query.setParameter("widgetId", (Object)widgetId);
        return query.getResultList();
    }
}

