/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.security.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.rave.portal.model.User;
import org.apache.rave.portal.model.WidgetComment;
import org.apache.rave.portal.repository.WidgetCommentRepository;
import org.apache.rave.portal.security.ModelPermissionEvaluator;
import org.apache.rave.portal.security.impl.AbstractModelPermissionEvaluator;
import org.apache.rave.portal.security.impl.RaveSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class DefaultWidgetCommentPermissionEvaluator
extends AbstractModelPermissionEvaluator<WidgetComment> {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private WidgetCommentRepository widgetCommentRepository;

    @Autowired
    public DefaultWidgetCommentPermissionEvaluator(WidgetCommentRepository widgetCommentRepository) {
        this.widgetCommentRepository = widgetCommentRepository;
    }

    @Override
    public Class<WidgetComment> getType() {
        return WidgetComment.class;
    }

    @Override
    public boolean hasPermission(Authentication authentication, WidgetComment widgetComment, ModelPermissionEvaluator.Permission permission) {
        return this.hasPermission(authentication, widgetComment, permission, false);
    }

    @Override
    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, ModelPermissionEvaluator.Permission permission) {
        boolean hasPermission = false;
        hasPermission = targetId instanceof RaveSecurityContext ? this.verifyRaveSecurityContext(authentication, (RaveSecurityContext)targetId, permission) : this.hasPermission(authentication, (WidgetComment)this.widgetCommentRepository.get((Long)targetId), permission, true);
        return hasPermission;
    }

    private boolean hasPermission(Authentication authentication, WidgetComment widgetComment, ModelPermissionEvaluator.Permission permission, boolean trustedDomainObject) {
        ArrayList<WidgetComment> trustedWidgetCommentContainer = new ArrayList<WidgetComment>();
        if (super.hasPermission(authentication, widgetComment, permission)) {
            return true;
        }
        boolean hasPermission = false;
        switch (permission) {
            case ADMINISTER: {
                break;
            }
            case READ: {
                hasPermission = true;
                break;
            }
            case CREATE: {
                hasPermission = this.isWidgetCommentOwnerById(authentication, widgetComment.getUser().getEntityId());
                break;
            }
            case DELETE: 
            case UPDATE: {
                hasPermission = this.isWidgetCommentOwner(authentication, widgetComment, trustedWidgetCommentContainer, trustedDomainObject);
                break;
            }
            default: {
                this.log.warn("unknown permission: " + (Object)((Object)permission));
            }
        }
        return hasPermission;
    }

    private boolean verifyRaveSecurityContext(Authentication authentication, RaveSecurityContext raveSecurityContext, ModelPermissionEvaluator.Permission permission) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(raveSecurityContext.getType());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("unknown class specified in RaveSecurityContext: ", ex);
        }
        if (WidgetComment.class == clazz) {
            boolean hasPermission = false;
            switch (permission) {
                case ADMINISTER: {
                    break;
                }
                case READ: {
                    hasPermission = true;
                    break;
                }
                case CREATE: 
                case DELETE: 
                case UPDATE: {
                    hasPermission = this.isWidgetCommentOwnerById(authentication, (Long)raveSecurityContext.getId());
                    break;
                }
                default: {
                    this.log.warn("unknown permission: " + (Object)((Object)permission));
                }
            }
            return hasPermission;
        }
        throw new IllegalArgumentException("unknown RaveSecurityContext type: " + raveSecurityContext.getType());
    }

    private boolean isWidgetCommentOwner(Authentication authentication, WidgetComment widgetComment, List<WidgetComment> trustedPageContainer, boolean trustedDomainObject) {
        WidgetComment trustedWidgetComment = null;
        trustedWidgetComment = trustedDomainObject ? widgetComment : this.getTrustedWidgetComment(widgetComment.getEntityId(), trustedPageContainer);
        return this.isWidgetCommentOwnerByUsername(authentication, trustedWidgetComment.getUser().getUsername());
    }

    private WidgetComment getTrustedWidgetComment(long widgetCommentId, List<WidgetComment> trustedWidgetCommentContainer) {
        WidgetComment p = null;
        if (trustedWidgetCommentContainer.isEmpty()) {
            p = (WidgetComment)this.widgetCommentRepository.get(widgetCommentId);
            trustedWidgetCommentContainer.add(p);
        } else {
            p = trustedWidgetCommentContainer.get(0);
        }
        return p;
    }

    private boolean isWidgetCommentOwnerByUsername(Authentication authentication, String username) {
        return ((User)authentication.getPrincipal()).getUsername().equals(username);
    }

    private boolean isWidgetCommentOwnerById(Authentication authentication, Long userId) {
        return ((User)authentication.getPrincipal()).getEntityId().equals(userId);
    }
}

